/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.style.URLSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.accessibility.JellyBeanBrowserAccessibilityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
public class BrowserAccessibilityManager {
    private static final String TAG = "BrowserAccessibilityManager";
    private ContentViewCore mContentViewCore;
    private final AccessibilityManager mAccessibilityManager;
    private final RenderCoordinates mRenderCoordinates;
    private long mNativeObj;
    private int mAccessibilityFocusId;
    private boolean mIsHovering;
    private int mLastHoverId = -1;
    private int mCurrentRootId;
    private final int[] mTempLocation = new int[2];
    private final ViewGroup mView;
    private boolean mUserHasTouchExplored;
    private boolean mPendingScrollToMakeNodeVisible;

    @CalledByNative
    private static BrowserAccessibilityManager create(long nativeBrowserAccessibilityManagerAndroid, ContentViewCore contentViewCore) {
        if (Build.VERSION.SDK_INT >= 16) {
            return new JellyBeanBrowserAccessibilityManager(nativeBrowserAccessibilityManagerAndroid, contentViewCore);
        }
        return new BrowserAccessibilityManager(nativeBrowserAccessibilityManagerAndroid, contentViewCore);
    }

    protected BrowserAccessibilityManager(long nativeBrowserAccessibilityManagerAndroid, ContentViewCore contentViewCore) {
        this.mNativeObj = nativeBrowserAccessibilityManagerAndroid;
        this.mContentViewCore = contentViewCore;
        this.mContentViewCore.setBrowserAccessibilityManager(this);
        this.mAccessibilityFocusId = -1;
        this.mIsHovering = false;
        this.mCurrentRootId = -1;
        this.mView = this.mContentViewCore.getContainerView();
        this.mRenderCoordinates = this.mContentViewCore.getRenderCoordinates();
        this.mAccessibilityManager = (AccessibilityManager)this.mContentViewCore.getContext().getSystemService("accessibility");
    }

    @CalledByNative
    private void onNativeObjectDestroyed() {
        if (this.mContentViewCore.getBrowserAccessibilityManager() == this) {
            this.mContentViewCore.setBrowserAccessibilityManager(null);
        }
        this.mNativeObj = 0L;
        this.mContentViewCore = null;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        return null;
    }

    protected AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0L) {
            return null;
        }
        int rootId = this.nativeGetRootId(this.mNativeObj);
        if (virtualViewId == -1) {
            return this.createNodeForHost(rootId);
        }
        if (!this.isFrameInfoInitialized()) {
            return null;
        }
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain((View)this.mView);
        info.setPackageName((CharSequence)this.mContentViewCore.getContext().getPackageName());
        info.setSource((View)this.mView, virtualViewId);
        if (virtualViewId == rootId) {
            info.setParent((View)this.mView);
        }
        if (this.nativePopulateAccessibilityNodeInfo(this.mNativeObj, info, virtualViewId)) {
            return info;
        }
        info.recycle();
        return null;
    }

    protected List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text, int virtualViewId) {
        return new ArrayList<AccessibilityNodeInfo>();
    }

    protected boolean performAction(int virtualViewId, int action, Bundle arguments) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0L || !this.nativeIsNodeValid(this.mNativeObj, virtualViewId)) {
            return false;
        }
        switch (action) {
            case 64: {
                if (this.mAccessibilityFocusId == virtualViewId) {
                    return true;
                }
                this.mAccessibilityFocusId = virtualViewId;
                this.sendAccessibilityEvent(this.mAccessibilityFocusId, 32768);
                if (!this.mIsHovering) {
                    this.nativeScrollToMakeNodeVisible(this.mNativeObj, this.mAccessibilityFocusId);
                } else {
                    this.mPendingScrollToMakeNodeVisible = true;
                }
                return true;
            }
            case 128: {
                if (this.mAccessibilityFocusId == virtualViewId) {
                    this.sendAccessibilityEvent(this.mAccessibilityFocusId, 65536);
                    this.mAccessibilityFocusId = -1;
                }
                return true;
            }
            case 16: {
                this.nativeClick(this.mNativeObj, virtualViewId);
                this.sendAccessibilityEvent(virtualViewId, 1);
                return true;
            }
            case 1: {
                this.nativeFocus(this.mNativeObj, virtualViewId);
                return true;
            }
            case 2: {
                this.nativeBlur(this.mNativeObj);
                return true;
            }
            case 1024: {
                if (arguments == null) {
                    return false;
                }
                String elementType = arguments.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                if (elementType == null) {
                    return false;
                }
                elementType = elementType.toUpperCase(Locale.US);
                return this.jumpToElementType(elementType, true);
            }
            case 2048: {
                if (arguments == null) {
                    return false;
                }
                String elementType = arguments.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                if (elementType == null) {
                    return false;
                }
                elementType = elementType.toUpperCase(Locale.US);
                return this.jumpToElementType(elementType, false);
            }
        }
        return false;
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0L) {
            return false;
        }
        if (event.getAction() == 10) {
            this.mIsHovering = false;
            if (this.mPendingScrollToMakeNodeVisible) {
                this.nativeScrollToMakeNodeVisible(this.mNativeObj, this.mAccessibilityFocusId);
            }
            this.mPendingScrollToMakeNodeVisible = false;
            return true;
        }
        this.mIsHovering = true;
        this.mUserHasTouchExplored = true;
        float x = event.getX();
        float y = event.getY();
        int cssX = (int)this.mRenderCoordinates.fromPixToLocalCss(x);
        int cssY = (int)this.mRenderCoordinates.fromPixToLocalCss(y);
        this.nativeHitTest(this.mNativeObj, cssX, cssY);
        return true;
    }

    public void notifyFrameInfoInitialized() {
        this.mView.sendAccessibilityEvent(2048);
        if (this.mAccessibilityFocusId != -1) {
            this.sendAccessibilityEvent(this.mAccessibilityFocusId, 32768);
        }
    }

    private boolean jumpToElementType(String elementType, boolean forwards) {
        int id2 = this.nativeFindElementType(this.mNativeObj, this.mAccessibilityFocusId, elementType, forwards);
        if (id2 == 0) {
            return false;
        }
        this.mAccessibilityFocusId = id2;
        this.sendAccessibilityEvent(id2, 32768);
        return true;
    }

    private void sendAccessibilityEvent(int virtualViewId, int eventType) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0L || !this.isFrameInfoInitialized()) {
            return;
        }
        this.mView.postInvalidate();
        if (virtualViewId == -1) {
            this.mView.sendAccessibilityEvent(eventType);
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
        event.setPackageName((CharSequence)this.mContentViewCore.getContext().getPackageName());
        event.setSource((View)this.mView, virtualViewId);
        if (!this.nativePopulateAccessibilityEvent(this.mNativeObj, event, virtualViewId, eventType)) {
            event.recycle();
            return;
        }
        this.mView.requestSendAccessibilityEvent((View)this.mView, event);
    }

    private Bundle getOrCreateBundleForAccessibilityEvent(AccessibilityEvent event) {
        Bundle bundle = (Bundle)event.getParcelableData();
        if (bundle == null) {
            bundle = new Bundle();
            event.setParcelableData((Parcelable)bundle);
        }
        return bundle;
    }

    private AccessibilityNodeInfo createNodeForHost(int rootId) {
        AccessibilityNodeInfo result = AccessibilityNodeInfo.obtain((View)this.mView);
        AccessibilityNodeInfo source = AccessibilityNodeInfo.obtain((View)this.mView);
        this.mView.onInitializeAccessibilityNodeInfo(source);
        Rect rect = new Rect();
        source.getBoundsInParent(rect);
        result.setBoundsInParent(rect);
        source.getBoundsInScreen(rect);
        result.setBoundsInScreen(rect);
        ViewParent parent = this.mView.getParentForAccessibility();
        if (parent instanceof View) {
            result.setParent((View)parent);
        }
        result.setVisibleToUser(source.isVisibleToUser());
        result.setEnabled(source.isEnabled());
        result.setPackageName(source.getPackageName());
        result.setClassName(source.getClassName());
        if (this.isFrameInfoInitialized()) {
            result.addChild((View)this.mView, rootId);
        }
        return result;
    }

    private boolean isFrameInfoInitialized() {
        return (double)this.mRenderCoordinates.getContentWidthCss() != 0.0 || (double)this.mRenderCoordinates.getContentHeightCss() != 0.0;
    }

    @CalledByNative
    private void handlePageLoaded(int id2) {
        if (this.mUserHasTouchExplored) {
            return;
        }
        this.mAccessibilityFocusId = id2;
        this.sendAccessibilityEvent(id2, 32768);
    }

    @CalledByNative
    private void handleFocusChanged(int id2) {
        this.sendAccessibilityEvent(id2, 8);
        if (this.mAccessibilityFocusId != id2) {
            this.sendAccessibilityEvent(id2, 32768);
            this.mAccessibilityFocusId = id2;
        }
    }

    @CalledByNative
    private void handleCheckStateChanged(int id2) {
        this.sendAccessibilityEvent(id2, 1);
    }

    @CalledByNative
    private void handleTextSelectionChanged(int id2) {
        this.sendAccessibilityEvent(id2, 8192);
    }

    @CalledByNative
    private void handleEditableTextChanged(int id2) {
        this.sendAccessibilityEvent(id2, 16);
    }

    @CalledByNative
    private void handleContentChanged(int id2) {
        int rootId = this.nativeGetRootId(this.mNativeObj);
        if (rootId != this.mCurrentRootId) {
            this.mCurrentRootId = rootId;
            this.mView.sendAccessibilityEvent(2048);
        } else {
            this.sendAccessibilityEvent(id2, 2048);
        }
    }

    @CalledByNative
    private void handleNavigate() {
        this.mAccessibilityFocusId = -1;
        this.mUserHasTouchExplored = false;
        this.mView.sendAccessibilityEvent(2048);
    }

    @CalledByNative
    private void handleScrollPositionChanged(int id2) {
        this.sendAccessibilityEvent(id2, 4096);
    }

    @CalledByNative
    private void handleScrolledToAnchor(int id2) {
        if (this.mAccessibilityFocusId == id2) {
            return;
        }
        this.mAccessibilityFocusId = id2;
        this.sendAccessibilityEvent(id2, 32768);
    }

    @CalledByNative
    private void handleHover(int id2) {
        if (this.mLastHoverId == id2) {
            return;
        }
        this.sendAccessibilityEvent(id2, 128);
        this.sendAccessibilityEvent(this.mLastHoverId, 256);
        this.mLastHoverId = id2;
    }

    @CalledByNative
    private void announceLiveRegionText(String text) {
        this.mView.announceForAccessibility((CharSequence)text);
    }

    @CalledByNative
    private void setAccessibilityNodeInfoParent(AccessibilityNodeInfo node, int parentId) {
        node.setParent((View)this.mView, parentId);
    }

    @CalledByNative
    private void addAccessibilityNodeInfoChild(AccessibilityNodeInfo node, int childId) {
        node.addChild((View)this.mView, childId);
    }

    @CalledByNative
    private void setAccessibilityNodeInfoBooleanAttributes(AccessibilityNodeInfo node, int virtualViewId, boolean checkable, boolean checked, boolean clickable, boolean enabled, boolean focusable, boolean focused, boolean password, boolean scrollable, boolean selected, boolean visibleToUser) {
        node.setCheckable(checkable);
        node.setChecked(checked);
        node.setClickable(clickable);
        node.setEnabled(enabled);
        node.setFocusable(focusable);
        node.setFocused(focused);
        node.setPassword(password);
        node.setScrollable(scrollable);
        node.setSelected(selected);
        node.setVisibleToUser(visibleToUser);
        node.addAction(1024);
        node.addAction(2048);
        if (focusable) {
            if (focused) {
                node.addAction(2);
            } else {
                node.addAction(1);
            }
        }
        if (this.mAccessibilityFocusId == virtualViewId) {
            node.setAccessibilityFocused(true);
            node.addAction(128);
        } else {
            node.setAccessibilityFocused(false);
            node.addAction(64);
        }
        if (clickable) {
            node.addAction(16);
        }
    }

    @CalledByNative
    private void setAccessibilityNodeInfoClassName(AccessibilityNodeInfo node, String className) {
        node.setClassName((CharSequence)className);
    }

    @CalledByNative
    private void setAccessibilityNodeInfoContentDescription(AccessibilityNodeInfo node, String contentDescription, boolean annotateAsLink) {
        if (annotateAsLink) {
            SpannableString spannable = new SpannableString((CharSequence)contentDescription);
            spannable.setSpan((Object)new URLSpan(""), 0, spannable.length(), 0);
            node.setContentDescription((CharSequence)spannable);
        } else {
            node.setContentDescription((CharSequence)contentDescription);
        }
    }

    @CalledByNative
    private void setAccessibilityNodeInfoLocation(AccessibilityNodeInfo node, int absoluteLeft, int absoluteTop, int parentRelativeLeft, int parentRelativeTop, int width, int height, boolean isRootNode) {
        Rect boundsInParent = new Rect(parentRelativeLeft, parentRelativeTop, parentRelativeLeft + width, parentRelativeTop + height);
        if (isRootNode) {
            boundsInParent.offset(0, (int)this.mRenderCoordinates.getContentOffsetYPix());
        }
        node.setBoundsInParent(boundsInParent);
        Rect rect = new Rect(absoluteLeft, absoluteTop, absoluteLeft + width, absoluteTop + height);
        rect.offset(-((int)this.mRenderCoordinates.getScrollX()), -((int)this.mRenderCoordinates.getScrollY()));
        rect.left = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.left);
        rect.top = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.top);
        rect.bottom = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.bottom);
        rect.right = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.right);
        rect.offset(0, (int)this.mRenderCoordinates.getContentOffsetYPix());
        int[] viewLocation = new int[2];
        this.mView.getLocationOnScreen(viewLocation);
        rect.offset(viewLocation[0], viewLocation[1]);
        node.setBoundsInScreen(rect);
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoKitKatAttributes(AccessibilityNodeInfo node, boolean canOpenPopup, boolean contentInvalid, boolean dismissable, boolean multiLine, int inputType, int liveRegion) {
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoCollectionInfo(AccessibilityNodeInfo node, int rowCount, int columnCount, boolean hierarchical) {
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoCollectionItemInfo(AccessibilityNodeInfo node, int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoRangeInfo(AccessibilityNodeInfo node, int rangeType, float min, float max, float current) {
    }

    @CalledByNative
    private void setAccessibilityEventBooleanAttributes(AccessibilityEvent event, boolean checked, boolean enabled, boolean password, boolean scrollable) {
        event.setChecked(checked);
        event.setEnabled(enabled);
        event.setPassword(password);
        event.setScrollable(scrollable);
    }

    @CalledByNative
    private void setAccessibilityEventClassName(AccessibilityEvent event, String className) {
        event.setClassName((CharSequence)className);
    }

    @CalledByNative
    private void setAccessibilityEventListAttributes(AccessibilityEvent event, int currentItemIndex, int itemCount) {
        event.setCurrentItemIndex(currentItemIndex);
        event.setItemCount(itemCount);
    }

    @CalledByNative
    private void setAccessibilityEventScrollAttributes(AccessibilityEvent event, int scrollX, int scrollY, int maxScrollX, int maxScrollY) {
        event.setScrollX(scrollX);
        event.setScrollY(scrollY);
        event.setMaxScrollX(maxScrollX);
        event.setMaxScrollY(maxScrollY);
    }

    @CalledByNative
    private void setAccessibilityEventTextChangedAttrs(AccessibilityEvent event, int fromIndex, int addedCount, int removedCount, String beforeText, String text) {
        event.setFromIndex(fromIndex);
        event.setAddedCount(addedCount);
        event.setRemovedCount(removedCount);
        event.setBeforeText((CharSequence)beforeText);
        event.getText().add(text);
    }

    @CalledByNative
    private void setAccessibilityEventSelectionAttrs(AccessibilityEvent event, int fromIndex, int addedCount, int itemCount, String text) {
        event.setFromIndex(fromIndex);
        event.setAddedCount(addedCount);
        event.setItemCount(itemCount);
        event.getText().add(text);
    }

    @CalledByNative
    protected void setAccessibilityEventKitKatAttributes(AccessibilityEvent event, boolean canOpenPopup, boolean contentInvalid, boolean dismissable, boolean multiLine, int inputType, int liveRegion) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putBoolean("AccessibilityNodeInfo.canOpenPopup", canOpenPopup);
        bundle.putBoolean("AccessibilityNodeInfo.contentInvalid", contentInvalid);
        bundle.putBoolean("AccessibilityNodeInfo.dismissable", dismissable);
        bundle.putBoolean("AccessibilityNodeInfo.multiLine", multiLine);
        bundle.putInt("AccessibilityNodeInfo.inputType", inputType);
        bundle.putInt("AccessibilityNodeInfo.liveRegion", liveRegion);
    }

    @CalledByNative
    protected void setAccessibilityEventCollectionInfo(AccessibilityEvent event, int rowCount, int columnCount, boolean hierarchical) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putInt("AccessibilityNodeInfo.CollectionInfo.rowCount", rowCount);
        bundle.putInt("AccessibilityNodeInfo.CollectionInfo.columnCount", columnCount);
        bundle.putBoolean("AccessibilityNodeInfo.CollectionInfo.hierarchical", hierarchical);
    }

    @CalledByNative
    protected void setAccessibilityEventCollectionItemInfo(AccessibilityEvent event, int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.rowIndex", rowIndex);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.rowSpan", rowSpan);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.columnIndex", columnIndex);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.columnSpan", columnSpan);
        bundle.putBoolean("AccessibilityNodeInfo.CollectionItemInfo.heading", heading);
    }

    @CalledByNative
    protected void setAccessibilityEventRangeInfo(AccessibilityEvent event, int rangeType, float min, float max, float current) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putInt("AccessibilityNodeInfo.RangeInfo.type", rangeType);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.min", min);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.max", max);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.current", current);
    }

    private native int nativeGetRootId(long var1);

    private native boolean nativeIsNodeValid(long var1, int var3);

    private native void nativeHitTest(long var1, int var3, int var4);

    private native boolean nativePopulateAccessibilityNodeInfo(long var1, AccessibilityNodeInfo var3, int var4);

    private native boolean nativePopulateAccessibilityEvent(long var1, AccessibilityEvent var3, int var4, int var5);

    private native void nativeClick(long var1, int var3);

    private native void nativeFocus(long var1, int var3);

    private native void nativeBlur(long var1);

    private native void nativeScrollToMakeNodeVisible(long var1, int var3);

    private native int nativeFindElementType(long var1, int var3, String var4, boolean var5);
}

