/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content_public.browser.WebContents;

@JNINamespace(value="content")
public abstract class WebContentsObserverAndroid {
    private long mNativeWebContentsObserverAndroid;

    public WebContentsObserverAndroid(ContentViewCore contentViewCore) {
        this(contentViewCore.getWebContents());
    }

    public WebContentsObserverAndroid(WebContents webContents) {
        ThreadUtils.assertOnUiThread();
        this.mNativeWebContentsObserverAndroid = this.nativeInit(webContents);
    }

    @CalledByNative
    public void renderProcessGone(boolean wasOomProtected) {
    }

    @CalledByNative
    public void didStartLoading(String url) {
    }

    @CalledByNative
    public void didStopLoading(String url) {
    }

    @CalledByNative
    public void didFailLoad(boolean isProvisionalLoad, boolean isMainFrame, int errorCode, String description, String failingUrl) {
    }

    @CalledByNative
    public void didNavigateMainFrame(String url, String baseUrl, boolean isNavigationToDifferentPage, boolean isFragmentNavigation) {
    }

    @CalledByNative
    public void didFirstVisuallyNonEmptyPaint() {
    }

    @CalledByNative
    public void didNavigateAnyFrame(String url, String baseUrl, boolean isReload) {
    }

    @CalledByNative
    public void didStartProvisionalLoadForFrame(long frameId, long parentFrameId, boolean isMainFrame, String validatedUrl, boolean isErrorPage, boolean isIframeSrcdoc) {
    }

    @CalledByNative
    public void didCommitProvisionalLoadForFrame(long frameId, boolean isMainFrame, String url, int transitionType) {
    }

    @CalledByNative
    public void didFinishLoad(long frameId, String validatedUrl, boolean isMainFrame) {
    }

    @CalledByNative
    public void documentLoadedInFrame(long frameId) {
    }

    @CalledByNative
    public void navigationEntryCommitted() {
    }

    @CalledByNative
    public void didAttachInterstitialPage() {
    }

    @CalledByNative
    public void didDetachInterstitialPage() {
    }

    @CalledByNative
    public void didChangeThemeColor(int color2) {
    }

    @CalledByNative
    public void detachFromWebContents() {
        if (this.mNativeWebContentsObserverAndroid != 0L) {
            this.nativeDestroy(this.mNativeWebContentsObserverAndroid);
            this.mNativeWebContentsObserverAndroid = 0L;
        }
    }

    private native long nativeInit(WebContents var1);

    private native void nativeDestroy(long var1);
}

