/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.ClipboardManager;
import android.content.Context;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import org.chromium.content.R;

public class SelectActionModeCallback
implements ActionMode.Callback {
    private final Context mContext;
    private final ActionHandler mActionHandler;
    private final boolean mIncognito;
    private boolean mEditable;
    private boolean mIsPasswordType;

    protected SelectActionModeCallback(Context context, ActionHandler actionHandler, boolean incognito) {
        this.mContext = context;
        this.mActionHandler = actionHandler;
        this.mIncognito = incognito;
    }

    protected Context getContext() {
        return this.mContext;
    }

    public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
        mode.setTitle(null);
        mode.setSubtitle(null);
        this.mEditable = this.mActionHandler.isSelectionEditable();
        this.mIsPasswordType = this.mActionHandler.isSelectionPassword();
        this.createActionMenu(mode, menu2);
        return true;
    }

    public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
        boolean isEditableNow = this.mActionHandler.isSelectionEditable();
        boolean isPasswordNow = this.mActionHandler.isSelectionPassword();
        if (this.mEditable != isEditableNow || this.mIsPasswordType != isPasswordNow) {
            this.mEditable = isEditableNow;
            this.mIsPasswordType = isPasswordNow;
            menu2.clear();
            this.createActionMenu(mode, menu2);
            return true;
        }
        return false;
    }

    private void createActionMenu(ActionMode mode, Menu menu2) {
        mode.getMenuInflater().inflate(R.menu.select_action_menu, menu2);
        if (!this.mEditable || !this.canPaste()) {
            menu2.removeItem(R.id.select_action_menu_paste);
        }
        if (!this.mEditable) {
            menu2.removeItem(R.id.select_action_menu_cut);
        }
        if (this.mEditable || !this.mActionHandler.isShareAvailable()) {
            menu2.removeItem(R.id.select_action_menu_share);
        }
        if (this.mEditable || this.mIncognito || !this.mActionHandler.isWebSearchAvailable()) {
            menu2.removeItem(R.id.select_action_menu_web_search);
        }
        if (this.mIsPasswordType) {
            menu2.removeItem(R.id.select_action_menu_copy);
            menu2.removeItem(R.id.select_action_menu_cut);
        }
    }

    public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.select_action_menu_select_all) {
            this.mActionHandler.selectAll();
        } else if (id2 == R.id.select_action_menu_cut) {
            this.mActionHandler.cut();
        } else if (id2 == R.id.select_action_menu_copy) {
            this.mActionHandler.copy();
            mode.finish();
        } else if (id2 == R.id.select_action_menu_paste) {
            this.mActionHandler.paste();
        } else if (id2 == R.id.select_action_menu_share) {
            this.mActionHandler.share();
            mode.finish();
        } else if (id2 == R.id.select_action_menu_web_search) {
            this.mActionHandler.search();
            mode.finish();
        } else {
            return false;
        }
        return true;
    }

    public void onDestroyActionMode(ActionMode mode) {
        this.mActionHandler.onDestroyActionMode();
    }

    private boolean canPaste() {
        ClipboardManager clipMgr = (ClipboardManager)this.getContext().getSystemService("clipboard");
        return clipMgr.hasPrimaryClip();
    }

    public static interface ActionHandler {
        public void selectAll();

        public void copy();

        public void cut();

        public void paste();

        public void share();

        public void search();

        public boolean isSelectionEditable();

        public void onDestroyActionMode();

        public boolean isShareAvailable();

        public boolean isWebSearchAvailable();

        public boolean isSelectionPassword();
    }
}

