/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="content")
class ScreenOrientationProvider {
    private static final String TAG = "ScreenOrientationProvider";

    private int getOrientationFromWebScreenOrientations(byte orientations) {
        switch (orientations) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 8;
            }
            case 7: {
                return 7;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 10;
            }
        }
        Log.w((String)TAG, (String)"Trying to lock to unsupported orientation!");
        return -1;
    }

    @VisibleForTesting
    @CalledByNative
    static ScreenOrientationProvider create() {
        return new ScreenOrientationProvider();
    }

    @CalledByNative
    void lockOrientation(byte orientations) {
        Activity activity = ApplicationStatus.getLastTrackedFocusedActivity();
        if (activity == null) {
            return;
        }
        int orientation = this.getOrientationFromWebScreenOrientations(orientations);
        if (orientation == -1) {
            return;
        }
        activity.setRequestedOrientation(orientation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    void unlockOrientation() {
        Activity activity = ApplicationStatus.getLastTrackedFocusedActivity();
        if (activity == null) {
            return;
        }
        int defaultOrientation = -1;
        try {
            ActivityInfo info = activity.getPackageManager().getActivityInfo(activity.getComponentName(), 128);
            defaultOrientation = info.screenOrientation;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        finally {
            activity.setRequestedOrientation(defaultOrientation);
        }
    }

    private ScreenOrientationProvider() {
    }
}

