/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.chromium.base.PathUtils;
import org.chromium.ui.base.LocalizationUtils;

public class ResourceExtractor {
    private static final String LOGTAG = "ResourceExtractor";
    private static final String LAST_LANGUAGE = "Last language";
    private static final String PAK_FILENAMES = "Pak filenames";
    private static final String ICU_DATA_FILENAME = "icudtl.dat";
    private static String[] sMandatoryPaks = null;
    private static ResourceIntercepter sIntercepter = null;
    private static boolean sExtractImplicitLocalePak = true;
    private final Context mContext;
    private ExtractTask mExtractTask;
    private final File mAppDataDir;
    private final File mOutputDir;
    private static ResourceExtractor sInstance;

    public static ResourceExtractor get(Context context) {
        if (sInstance == null) {
            sInstance = new ResourceExtractor(context);
        }
        return sInstance;
    }

    public static void setMandatoryPaksToExtract(String ... mandatoryPaks) {
        assert (sInstance == null || ResourceExtractor.sInstance.mExtractTask == null) : "Must be called before startExtractingResources is called";
        sMandatoryPaks = mandatoryPaks;
    }

    public static void setResourceIntercepter(ResourceIntercepter intercepter) {
        assert (sInstance == null || ResourceExtractor.sInstance.mExtractTask == null) : "Must be called before startExtractingResources is called";
        sIntercepter = intercepter;
    }

    public static void setExtractImplicitLocaleForTesting(boolean extract) {
        assert (sInstance == null || ResourceExtractor.sInstance.mExtractTask == null) : "Must be called before startExtractingResources is called";
        sExtractImplicitLocalePak = extract;
    }

    private ResourceExtractor(Context context) {
        this.mContext = context;
        this.mAppDataDir = ResourceExtractor.getAppDataDirFromContext(this.mContext);
        this.mOutputDir = ResourceExtractor.getOutputDirFromContext(this.mContext);
    }

    public void waitForCompletion() {
        if (ResourceExtractor.shouldSkipPakExtraction()) {
            return;
        }
        assert (this.mExtractTask != null);
        try {
            this.mExtractTask.get();
            sIntercepter = null;
            sInstance = null;
        }
        catch (CancellationException e) {
            ResourceExtractor.deleteFiles(this.mContext);
        }
        catch (ExecutionException e2) {
            ResourceExtractor.deleteFiles(this.mContext);
        }
        catch (InterruptedException e3) {
            ResourceExtractor.deleteFiles(this.mContext);
        }
    }

    public void startExtractingResources() {
        if (this.mExtractTask != null) {
            return;
        }
        if (ResourceExtractor.shouldSkipPakExtraction()) {
            return;
        }
        this.mExtractTask = new ExtractTask();
        this.mExtractTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public static File getAppDataDirFromContext(Context context) {
        return new File(PathUtils.getDataDirectory(context.getApplicationContext()));
    }

    public static File getOutputDirFromContext(Context context) {
        return new File(ResourceExtractor.getAppDataDirFromContext(context), "paks");
    }

    public static void deleteFiles(Context context) {
        File dir;
        File icudata = new File(ResourceExtractor.getAppDataDirFromContext(context), ICU_DATA_FILENAME);
        if (icudata.exists() && !icudata.delete()) {
            Log.e((String)LOGTAG, (String)("Unable to remove the icudata " + icudata.getName()));
        }
        if ((dir = ResourceExtractor.getOutputDirFromContext(context)).exists()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (file.delete()) continue;
                Log.e((String)LOGTAG, (String)("Unable to remove existing resource " + file.getName()));
            }
        }
    }

    private static boolean shouldSkipPakExtraction() {
        assert (sMandatoryPaks != null);
        return sMandatoryPaks.length == 1 && "".equals(sMandatoryPaks[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExtractTask
    extends AsyncTask<Void, Void, Void> {
        private static final int BUFFER_SIZE = 16384;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... unused) {
            if (!ResourceExtractor.this.mOutputDir.exists() && !ResourceExtractor.this.mOutputDir.mkdirs()) {
                Log.e((String)ResourceExtractor.LOGTAG, (String)"Unable to create pak resources directory!");
                return null;
            }
            String timestampFile = this.checkPakTimestamp();
            if (timestampFile != null) {
                ResourceExtractor.deleteFiles(ResourceExtractor.this.mContext);
            }
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ResourceExtractor.this.mContext.getApplicationContext());
            HashSet filenames = (HashSet)prefs.getStringSet(ResourceExtractor.PAK_FILENAMES, new HashSet());
            String currentLocale = LocalizationUtils.getDefaultLocale();
            String currentLanguage = currentLocale.split("-", 2)[0];
            if (prefs.getString(ResourceExtractor.LAST_LANGUAGE, "").equals(currentLanguage) && filenames.size() >= sMandatoryPaks.length) {
                boolean filesPresent = true;
                for (String file : filenames) {
                    if (new File(ResourceExtractor.this.mOutputDir, file).exists()) continue;
                    filesPresent = false;
                    break;
                }
                if (filesPresent) {
                    return null;
                }
            } else {
                prefs.edit().putString(ResourceExtractor.LAST_LANGUAGE, currentLanguage).apply();
            }
            StringBuilder p = new StringBuilder();
            for (String mandatoryPak : sMandatoryPaks) {
                if (p.length() > 0) {
                    p.append('|');
                }
                p.append("\\Q" + mandatoryPak + "\\E");
            }
            if (sExtractImplicitLocalePak) {
                if (p.length() > 0) {
                    p.append('|');
                }
                p.append(currentLanguage);
                p.append("(-\\w+)?\\.pak");
            }
            Pattern paksToInstall = Pattern.compile(p.toString());
            AssetManager manager = ResourceExtractor.this.mContext.getResources().getAssets();
            try {
                Set<String> filesIncludingInterceptableFiles;
                byte[] buffer = null;
                String[] files = manager.list("");
                if (sIntercepter != null && (filesIncludingInterceptableFiles = sIntercepter.getInterceptableResourceList()) != null && !filesIncludingInterceptableFiles.isEmpty()) {
                    for (String file : files) {
                        filesIncludingInterceptableFiles.add(file);
                    }
                    files = new String[filesIncludingInterceptableFiles.size()];
                    filesIncludingInterceptableFiles.toArray(files);
                }
                for (String file : files) {
                    boolean isICUData;
                    File output;
                    if (!paksToInstall.matcher(file).matches() || (output = new File((isICUData = file.equals(ResourceExtractor.ICU_DATA_FILENAME)) ? ResourceExtractor.this.mAppDataDir : ResourceExtractor.this.mOutputDir, file)).exists()) continue;
                    InputStream is = null;
                    FileOutputStream os = null;
                    try {
                        if (sIntercepter != null) {
                            is = sIntercepter.interceptLoadingForResource(file);
                        }
                        if (is == null) {
                            is = manager.open(file);
                        }
                        os = new FileOutputStream(output);
                        Log.i((String)ResourceExtractor.LOGTAG, (String)("Extracting resource " + file));
                        if (buffer == null) {
                            buffer = new byte[16384];
                        }
                        int count = 0;
                        while ((count = is.read(buffer, 0, 16384)) != -1) {
                            ((OutputStream)os).write(buffer, 0, count);
                        }
                        os.flush();
                        if (output.length() == 0L) {
                            throw new IOException(file + " extracted with 0 length!");
                        }
                        if (!isICUData) {
                            filenames.add(file);
                            continue;
                        }
                        output.setReadable(true, false);
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        finally {
                            if (os != null) {
                                ((OutputStream)os).close();
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                Log.w((String)ResourceExtractor.LOGTAG, (String)("Exception unpacking required pak resources: " + e.getMessage()));
                ResourceExtractor.deleteFiles(ResourceExtractor.this.mContext);
                return null;
            }
            if (timestampFile != null) {
                try {
                    new File(ResourceExtractor.this.mOutputDir, timestampFile).createNewFile();
                }
                catch (IOException e) {
                    Log.w((String)ResourceExtractor.LOGTAG, (String)"Failed to write resource pak timestamp!");
                }
            }
            prefs.edit().remove(ResourceExtractor.PAK_FILENAMES).apply();
            prefs.edit().putStringSet(ResourceExtractor.PAK_FILENAMES, (Set)filenames).apply();
            return null;
        }

        private String checkPakTimestamp() {
            String TIMESTAMP_PREFIX = "pak_timestamp-";
            PackageManager pm = ResourceExtractor.this.mContext.getPackageManager();
            PackageInfo pi = null;
            try {
                pi = pm.getPackageInfo(ResourceExtractor.this.mContext.getPackageName(), 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                return "pak_timestamp-";
            }
            if (pi == null) {
                return "pak_timestamp-";
            }
            String expectedTimestamp = "pak_timestamp-" + pi.versionCode + "-" + pi.lastUpdateTime;
            String[] timestamps = ResourceExtractor.this.mOutputDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("pak_timestamp-");
                }
            });
            if (timestamps.length != 1) {
                return expectedTimestamp;
            }
            if (!expectedTimestamp.equals(timestamps[0])) {
                return expectedTimestamp;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResourceIntercepter {
        public Set<String> getInterceptableResourceList();

        public InputStream interceptLoadingForResource(String var1);
    }
}

