/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import org.chromium.content.R;

class PopupZoomer
extends View {
    private static final String LOGTAG = "PopupZoomer";
    private static final int ZOOM_BOUNDS_MARGIN = 25;
    private static final long ANIMATION_DURATION = 300L;
    private OnTapListener mOnTapListener = null;
    private OnVisibilityChangedListener mOnVisibilityChangedListener = null;
    private static Drawable sOverlayDrawable;
    private static Rect sOverlayPadding;
    private static float sOverlayCornerRadius;
    private final Interpolator mShowInterpolator = new OvershootInterpolator();
    private final Interpolator mHideInterpolator = new ReverseInterpolator(this.mShowInterpolator);
    private boolean mAnimating = false;
    private boolean mShowing = false;
    private long mAnimationStartTime = 0L;
    private long mTimeLeft = 0L;
    private boolean mNeedsToInitDimensions;
    private RectF mViewClipRect;
    private Rect mTargetBounds;
    private Bitmap mZoomedBitmap;
    private float mShiftX = 0.0f;
    private float mShiftY = 0.0f;
    private float mScale = 1.0f;
    private RectF mClipRect;
    private float mLeftExtrusion;
    private float mTopExtrusion;
    private float mRightExtrusion;
    private float mBottomExtrusion;
    private final PointF mTouch = new PointF();
    private float mPopupScrollX;
    private float mPopupScrollY;
    private float mMinScrollX;
    private float mMaxScrollX;
    private float mMinScrollY;
    private float mMaxScrollY;
    private GestureDetector mGestureDetector;

    private static float getOverlayCornerRadius(Context context) {
        if (sOverlayCornerRadius == 0.0f) {
            try {
                sOverlayCornerRadius = context.getResources().getDimension(R.dimen.link_preview_overlay_radius);
            }
            catch (Resources.NotFoundException e) {
                Log.w((String)LOGTAG, (String)"No corner radius resource for PopupZoomer overlay found.");
                sOverlayCornerRadius = 1.0f;
            }
        }
        return sOverlayCornerRadius;
    }

    private static Drawable getOverlayDrawable(Context context) {
        if (sOverlayDrawable == null) {
            try {
                sOverlayDrawable = context.getResources().getDrawable(R.drawable.ondemand_overlay);
            }
            catch (Resources.NotFoundException e) {
                Log.w((String)LOGTAG, (String)"No drawable resource for PopupZoomer overlay found.");
                sOverlayDrawable = new ColorDrawable();
            }
            sOverlayPadding = new Rect();
            sOverlayDrawable.getPadding(sOverlayPadding);
        }
        return sOverlayDrawable;
    }

    private static float constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    private static int constrain(int amount, int low, int high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    public PopupZoomer(Context context) {
        super(context);
        this.setVisibility(4);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        GestureDetector.SimpleOnGestureListener listener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (PopupZoomer.this.mAnimating) {
                    return true;
                }
                if (PopupZoomer.this.isTouchOutsideArea(e1.getX(), e1.getY())) {
                    PopupZoomer.this.hide(true);
                } else {
                    PopupZoomer.this.scroll(distanceX, distanceY);
                }
                return true;
            }

            public boolean onSingleTapUp(MotionEvent e) {
                return this.handleTapOrPress(e, false);
            }

            public void onLongPress(MotionEvent e) {
                this.handleTapOrPress(e, true);
            }

            private boolean handleTapOrPress(MotionEvent e, boolean isLongPress) {
                float y;
                if (PopupZoomer.this.mAnimating) {
                    return true;
                }
                float x = e.getX();
                if (PopupZoomer.this.isTouchOutsideArea(x, y = e.getY())) {
                    PopupZoomer.this.hide(true);
                } else if (PopupZoomer.this.mOnTapListener != null) {
                    PointF converted = PopupZoomer.this.convertTouchPoint(x, y);
                    MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)e);
                    event.setLocation(converted.x, converted.y);
                    if (isLongPress) {
                        PopupZoomer.this.mOnTapListener.onLongPress(PopupZoomer.this, event);
                    } else {
                        PopupZoomer.this.mOnTapListener.onSingleTap(PopupZoomer.this, event);
                    }
                    PopupZoomer.this.hide(true);
                }
                return true;
            }
        };
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)listener);
    }

    public void setOnTapListener(OnTapListener listener) {
        this.mOnTapListener = listener;
    }

    public void setOnVisibilityChangedListener(OnVisibilityChangedListener listener) {
        this.mOnVisibilityChangedListener = listener;
    }

    public void setBitmap(Bitmap bitmap) {
        if (this.mZoomedBitmap != null) {
            this.mZoomedBitmap.recycle();
            this.mZoomedBitmap = null;
        }
        this.mZoomedBitmap = bitmap;
        Canvas canvas = new Canvas(this.mZoomedBitmap);
        Path path = new Path();
        RectF canvasRect = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        float overlayCornerRadius = PopupZoomer.getOverlayCornerRadius(this.getContext());
        path.addRoundRect(canvasRect, overlayCornerRadius, overlayCornerRadius, Path.Direction.CCW);
        canvas.clipPath(path, Region.Op.XOR);
        Paint clearPaint = new Paint();
        clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        clearPaint.setColor(0);
        canvas.drawPaint(clearPaint);
    }

    private void scroll(float x, float y) {
        this.mPopupScrollX = PopupZoomer.constrain(this.mPopupScrollX - x, this.mMinScrollX, this.mMaxScrollX);
        this.mPopupScrollY = PopupZoomer.constrain(this.mPopupScrollY - y, this.mMinScrollY, this.mMaxScrollY);
        this.invalidate();
    }

    private void startAnimation(boolean show) {
        this.mAnimating = true;
        this.mShowing = show;
        this.mTimeLeft = 0L;
        if (show) {
            this.setVisibility(0);
            this.mNeedsToInitDimensions = true;
            if (this.mOnVisibilityChangedListener != null) {
                this.mOnVisibilityChangedListener.onPopupZoomerShown(this);
            }
        } else {
            long endTime = this.mAnimationStartTime + 300L;
            this.mTimeLeft = endTime - SystemClock.uptimeMillis();
            if (this.mTimeLeft < 0L) {
                this.mTimeLeft = 0L;
            }
        }
        this.mAnimationStartTime = SystemClock.uptimeMillis();
        this.invalidate();
    }

    private void hideImmediately() {
        this.mAnimating = false;
        this.mShowing = false;
        this.mTimeLeft = 0L;
        if (this.mOnVisibilityChangedListener != null) {
            this.mOnVisibilityChangedListener.onPopupZoomerHidden(this);
        }
        this.setVisibility(4);
        this.mZoomedBitmap.recycle();
        this.mZoomedBitmap = null;
    }

    public boolean isShowing() {
        return this.mShowing || this.mAnimating;
    }

    public void setLastTouch(float x, float y) {
        this.mTouch.x = x;
        this.mTouch.y = y;
    }

    private void setTargetBounds(Rect rect) {
        this.mTargetBounds = rect;
    }

    private void initDimensions() {
        if (this.mTargetBounds == null || this.mTouch == null) {
            return;
        }
        this.mScale = (float)this.mZoomedBitmap.getWidth() / (float)this.mTargetBounds.width();
        float l = this.mTouch.x - this.mScale * (this.mTouch.x - (float)this.mTargetBounds.left);
        float t = this.mTouch.y - this.mScale * (this.mTouch.y - (float)this.mTargetBounds.top);
        float r = l + (float)this.mZoomedBitmap.getWidth();
        float b = t + (float)this.mZoomedBitmap.getHeight();
        this.mClipRect = new RectF(l, t, r, b);
        int width = this.getWidth();
        int height = this.getHeight();
        this.mViewClipRect = new RectF(25.0f, 25.0f, (float)(width - 25), (float)(height - 25));
        this.mShiftX = 0.0f;
        this.mShiftY = 0.0f;
        if (this.mClipRect.left < 25.0f) {
            this.mShiftX = 25.0f - this.mClipRect.left;
            this.mClipRect.left += this.mShiftX;
            this.mClipRect.right += this.mShiftX;
        } else if (this.mClipRect.right > (float)(width - 25)) {
            this.mShiftX = (float)(width - 25) - this.mClipRect.right;
            this.mClipRect.right += this.mShiftX;
            this.mClipRect.left += this.mShiftX;
        }
        if (this.mClipRect.top < 25.0f) {
            this.mShiftY = 25.0f - this.mClipRect.top;
            this.mClipRect.top += this.mShiftY;
            this.mClipRect.bottom += this.mShiftY;
        } else if (this.mClipRect.bottom > (float)(height - 25)) {
            this.mShiftY = (float)(height - 25) - this.mClipRect.bottom;
            this.mClipRect.bottom += this.mShiftY;
            this.mClipRect.top += this.mShiftY;
        }
        this.mMaxScrollY = 0.0f;
        this.mMinScrollY = 0.0f;
        this.mMaxScrollX = 0.0f;
        this.mMinScrollX = 0.0f;
        if (this.mViewClipRect.right + this.mShiftX < this.mClipRect.right) {
            this.mMinScrollX = this.mViewClipRect.right - this.mClipRect.right;
        }
        if (this.mViewClipRect.left + this.mShiftX > this.mClipRect.left) {
            this.mMaxScrollX = this.mViewClipRect.left - this.mClipRect.left;
        }
        if (this.mViewClipRect.top + this.mShiftY > this.mClipRect.top) {
            this.mMaxScrollY = this.mViewClipRect.top - this.mClipRect.top;
        }
        if (this.mViewClipRect.bottom + this.mShiftY < this.mClipRect.bottom) {
            this.mMinScrollY = this.mViewClipRect.bottom - this.mClipRect.bottom;
        }
        this.mClipRect.intersect(this.mViewClipRect);
        this.mLeftExtrusion = this.mTouch.x - this.mClipRect.left;
        this.mRightExtrusion = this.mClipRect.right - this.mTouch.x;
        this.mTopExtrusion = this.mTouch.y - this.mClipRect.top;
        this.mBottomExtrusion = this.mClipRect.bottom - this.mTouch.y;
        float percentX = (this.mTouch.x - (float)this.mTargetBounds.centerX()) / ((float)this.mTargetBounds.width() / 2.0f) + 0.5f;
        float percentY = (this.mTouch.y - (float)this.mTargetBounds.centerY()) / ((float)this.mTargetBounds.height() / 2.0f) + 0.5f;
        float scrollWidth = this.mMaxScrollX - this.mMinScrollX;
        float scrollHeight = this.mMaxScrollY - this.mMinScrollY;
        this.mPopupScrollX = scrollWidth * percentX * -1.0f;
        this.mPopupScrollY = scrollHeight * percentY * -1.0f;
        this.mPopupScrollX = PopupZoomer.constrain(this.mPopupScrollX, this.mMinScrollX, this.mMaxScrollX);
        this.mPopupScrollY = PopupZoomer.constrain(this.mPopupScrollY, this.mMinScrollY, this.mMaxScrollY);
    }

    protected boolean acceptZeroSizeView() {
        return false;
    }

    protected void onDraw(Canvas canvas) {
        if (!this.isShowing() || this.mZoomedBitmap == null) {
            return;
        }
        if (!(this.acceptZeroSizeView() || this.getWidth() != 0 && this.getHeight() != 0)) {
            return;
        }
        if (this.mNeedsToInitDimensions) {
            this.mNeedsToInitDimensions = false;
            this.initDimensions();
        }
        canvas.save();
        float time = (float)(SystemClock.uptimeMillis() - this.mAnimationStartTime + this.mTimeLeft) / 300.0f;
        time = PopupZoomer.constrain(time, 0.0f, 1.0f);
        if (time >= 1.0f) {
            this.mAnimating = false;
            if (!this.isShowing()) {
                this.hideImmediately();
                return;
            }
        } else {
            this.invalidate();
        }
        float fractionAnimation = this.mShowing ? this.mShowInterpolator.getInterpolation(time) : this.mHideInterpolator.getInterpolation(time);
        canvas.drawARGB((int)(80.0f * fractionAnimation), 0, 0, 0);
        canvas.save();
        float scale = fractionAnimation * (this.mScale - 1.0f) / this.mScale + 1.0f / this.mScale;
        float unshiftX = -this.mShiftX * (1.0f - fractionAnimation) / this.mScale;
        float unshiftY = -this.mShiftY * (1.0f - fractionAnimation) / this.mScale;
        RectF rect = new RectF();
        rect.left = this.mTouch.x - this.mLeftExtrusion * scale + unshiftX;
        rect.top = this.mTouch.y - this.mTopExtrusion * scale + unshiftY;
        rect.right = this.mTouch.x + this.mRightExtrusion * scale + unshiftX;
        rect.bottom = this.mTouch.y + this.mBottomExtrusion * scale + unshiftY;
        canvas.clipRect(rect);
        canvas.scale(scale, scale, rect.left, rect.top);
        canvas.translate(this.mPopupScrollX, this.mPopupScrollY);
        canvas.drawBitmap(this.mZoomedBitmap, rect.left, rect.top, null);
        canvas.restore();
        Drawable overlayNineTile = PopupZoomer.getOverlayDrawable(this.getContext());
        overlayNineTile.setBounds((int)rect.left - PopupZoomer.sOverlayPadding.left, (int)rect.top - PopupZoomer.sOverlayPadding.top, (int)rect.right + PopupZoomer.sOverlayPadding.right, (int)rect.bottom + PopupZoomer.sOverlayPadding.bottom);
        int alpha = PopupZoomer.constrain((int)(fractionAnimation * 255.0f), 0, 255);
        overlayNineTile.setAlpha(alpha);
        overlayNineTile.draw(canvas);
        canvas.restore();
    }

    public void show(Rect rect) {
        if (this.mShowing || this.mZoomedBitmap == null) {
            return;
        }
        this.setTargetBounds(rect);
        this.startAnimation(true);
    }

    public void hide(boolean animation) {
        if (!this.mShowing) {
            return;
        }
        if (animation) {
            this.startAnimation(false);
        } else {
            this.hideImmediately();
        }
    }

    private PointF convertTouchPoint(float x, float y) {
        x -= this.mShiftX;
        y -= this.mShiftY;
        x = this.mTouch.x + (x - this.mTouch.x - this.mPopupScrollX) / this.mScale;
        y = this.mTouch.y + (y - this.mTouch.y - this.mPopupScrollY) / this.mScale;
        return new PointF(x, y);
    }

    private boolean isTouchOutsideArea(float x, float y) {
        return !this.mClipRect.contains(x, y);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        return true;
    }

    private static class ReverseInterpolator
    implements Interpolator {
        private final Interpolator mInterpolator;

        public ReverseInterpolator(Interpolator i) {
            this.mInterpolator = i;
        }

        public float getInterpolation(float input) {
            input = 1.0f - input;
            if (this.mInterpolator == null) {
                return input;
            }
            return this.mInterpolator.getInterpolation(input);
        }
    }

    public static interface OnVisibilityChangedListener {
        public void onPopupZoomerShown(PopupZoomer var1);

        public void onPopupZoomerHidden(PopupZoomer var1);
    }

    public static interface OnTapListener {
        public boolean onSingleTap(View var1, MotionEvent var2);

        public boolean onLongPress(View var1, MotionEvent var2);
    }
}

