/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.PathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
class MediaResourceGetter {
    private static final String TAG = "MediaResourceGetter";
    private final MediaMetadata EMPTY_METADATA = new MediaMetadata(0, 0, 0, false);
    private final MediaMetadataRetriever mRetriever = new MediaMetadataRetriever();

    MediaResourceGetter() {
    }

    @CalledByNative
    private static MediaMetadata extractMediaMetadata(Context context, String url, String cookies, String userAgent) {
        return new MediaResourceGetter().extract(context, url, cookies, userAgent);
    }

    @CalledByNative
    private static MediaMetadata extractMediaMetadataFromFd(int fd, long offset, long length) {
        return new MediaResourceGetter().extract(fd, offset, length);
    }

    @VisibleForTesting
    MediaMetadata extract(int fd, long offset, long length) {
        if (!MediaResourceGetter.androidDeviceOk(Build.MODEL, Build.VERSION.SDK_INT)) {
            return this.EMPTY_METADATA;
        }
        this.configure(fd, offset, length);
        return this.doExtractMetadata();
    }

    @VisibleForTesting
    MediaMetadata extract(Context context, String url, String cookies, String userAgent) {
        if (!MediaResourceGetter.androidDeviceOk(Build.MODEL, Build.VERSION.SDK_INT)) {
            return this.EMPTY_METADATA;
        }
        if (!this.configure(context, url, cookies, userAgent)) {
            Log.e((String)TAG, (String)"Unable to configure metadata extractor");
            return this.EMPTY_METADATA;
        }
        return this.doExtractMetadata();
    }

    private MediaMetadata doExtractMetadata() {
        try {
            String durationString = this.extractMetadata(9);
            if (durationString == null) {
                Log.w((String)TAG, (String)"missing duration metadata");
                return this.EMPTY_METADATA;
            }
            int durationMillis = 0;
            try {
                durationMillis = Integer.parseInt(durationString);
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)("non-numeric duration: " + durationString));
                return this.EMPTY_METADATA;
            }
            int width = 0;
            int height = 0;
            boolean hasVideo = "yes".equals(this.extractMetadata(17));
            Log.d((String)TAG, (String)(hasVideo ? "resource has video" : "resource doesn't have video"));
            if (hasVideo) {
                String widthString = this.extractMetadata(18);
                if (widthString == null) {
                    Log.w((String)TAG, (String)"missing video width metadata");
                    return this.EMPTY_METADATA;
                }
                try {
                    width = Integer.parseInt(widthString);
                }
                catch (NumberFormatException e) {
                    Log.w((String)TAG, (String)("non-numeric width: " + widthString));
                    return this.EMPTY_METADATA;
                }
                String heightString = this.extractMetadata(19);
                if (heightString == null) {
                    Log.w((String)TAG, (String)"missing video height metadata");
                    return this.EMPTY_METADATA;
                }
                try {
                    height = Integer.parseInt(heightString);
                }
                catch (NumberFormatException e) {
                    Log.w((String)TAG, (String)("non-numeric height: " + heightString));
                    return this.EMPTY_METADATA;
                }
            }
            MediaMetadata result = new MediaMetadata(durationMillis, width, height, true);
            Log.d((String)TAG, (String)("extracted valid metadata: " + result.toString()));
            return result;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Unable to extract medata", (Throwable)e);
            return this.EMPTY_METADATA;
        }
    }

    @VisibleForTesting
    boolean configure(Context context, String url, String cookies, String userAgent) {
        URI uri;
        try {
            uri = URI.create(url);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Cannot parse uri.", (Throwable)e);
            return false;
        }
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equals("file") || scheme.equals("app")) {
            File file = this.uriToFile(uri.getPath());
            if (!file.exists()) {
                Log.e((String)TAG, (String)"File does not exist.");
                return false;
            }
            if (!this.filePathAcceptable(file)) {
                Log.e((String)TAG, (String)"Refusing to read from unsafe file location.");
                return false;
            }
            try {
                this.configure(file.getAbsolutePath());
                return true;
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Error configuring data source", (Throwable)e);
                return false;
            }
        }
        String host = uri.getHost();
        if (!this.isLoopbackAddress(host) && !this.isNetworkReliable(context)) {
            Log.w((String)TAG, (String)"non-file URI can't be read due to unsuitable network conditions");
            return false;
        }
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)cookies)) {
            headersMap.put("Cookie", cookies);
        }
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            headersMap.put("User-Agent", userAgent);
        }
        try {
            this.configure(url, headersMap);
            return true;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Error configuring data source", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    boolean isNetworkReliable(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") != 0) {
            Log.w((String)TAG, (String)"permission denied to access network state");
            return false;
        }
        Integer networkType = this.getNetworkType(context);
        if (networkType == null) {
            return false;
        }
        switch (networkType) {
            case 1: 
            case 9: {
                Log.d((String)TAG, (String)"ethernet/wifi connection detected");
                return true;
            }
        }
        Log.d((String)TAG, (String)"no ethernet/wifi connection detected");
        return false;
    }

    private boolean isLoopbackAddress(String host) {
        return host != null && (host.equalsIgnoreCase("localhost") || host.equals("127.0.0.1") || host.equals("[::1]"));
    }

    @VisibleForTesting
    boolean filePathAcceptable(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"canonicalization of file path failed");
            return false;
        }
        List<String> acceptablePaths = this.canonicalize(this.getRawAcceptableDirectories());
        acceptablePaths.add(this.getExternalStorageDirectory());
        Log.d((String)TAG, (String)("canonicalized file path: " + path));
        for (String acceptablePath : acceptablePaths) {
            if (!path.startsWith(acceptablePath)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static boolean androidDeviceOk(String model, int sdkVersion) {
        return !"GT-I9100".contentEquals(model) || sdkVersion >= 16;
    }

    @VisibleForTesting
    File uriToFile(String path) {
        return new File(path);
    }

    @VisibleForTesting
    Integer getNetworkType(Context context) {
        ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (mConnectivityManager == null) {
            Log.w((String)TAG, (String)"no connectivity manager available");
            return null;
        }
        NetworkInfo info = mConnectivityManager.getActiveNetworkInfo();
        if (info == null) {
            Log.d((String)TAG, (String)"no active network");
            return null;
        }
        return info.getType();
    }

    private List<String> getRawAcceptableDirectories() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("/mnt/sdcard/");
        result.add("/sdcard/");
        return result;
    }

    private List<String> canonicalize(List<String> paths) {
        ArrayList<String> result = new ArrayList<String>(paths.size());
        try {
            for (String path : paths) {
                result.add(new File(path).getCanonicalPath());
            }
            return result;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"canonicalization of file path failed");
            return result;
        }
    }

    @VisibleForTesting
    String getExternalStorageDirectory() {
        return PathUtils.getExternalStorageDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void configure(int fd, long offset, long length) {
        ParcelFileDescriptor parcelFd = ParcelFileDescriptor.adoptFd((int)fd);
        try {
            this.mRetriever.setDataSource(parcelFd.getFileDescriptor(), offset, length);
        }
        finally {
            try {
                parcelFd.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Failed to close file descriptor: " + e));
            }
        }
    }

    @VisibleForTesting
    void configure(String url, Map<String, String> headers) {
        this.mRetriever.setDataSource(url, headers);
    }

    @VisibleForTesting
    void configure(String path) {
        this.mRetriever.setDataSource(path);
    }

    @VisibleForTesting
    String extractMetadata(int key) {
        return this.mRetriever.extractMetadata(key);
    }

    @VisibleForTesting
    static class MediaMetadata {
        private final int mDurationInMilliseconds;
        private final int mWidth;
        private final int mHeight;
        private final boolean mSuccess;

        MediaMetadata(int durationInMilliseconds, int width, int height, boolean success) {
            this.mDurationInMilliseconds = durationInMilliseconds;
            this.mWidth = width;
            this.mHeight = height;
            this.mSuccess = success;
        }

        @CalledByNative(value="MediaMetadata")
        int getDurationInMilliseconds() {
            return this.mDurationInMilliseconds;
        }

        @CalledByNative(value="MediaMetadata")
        int getWidth() {
            return this.mWidth;
        }

        @CalledByNative(value="MediaMetadata")
        int getHeight() {
            return this.mHeight;
        }

        @CalledByNative(value="MediaMetadata")
        boolean isSuccess() {
            return this.mSuccess;
        }

        public String toString() {
            return "MediaMetadata[durationInMilliseconds=" + this.mDurationInMilliseconds + ", width=" + this.mWidth + ", height=" + this.mHeight + ", success=" + this.mSuccess + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mDurationInMilliseconds;
            result = 31 * result + this.mHeight;
            result = 31 * result + (this.mSuccess ? 1231 : 1237);
            result = 31 * result + this.mWidth;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MediaMetadata other = (MediaMetadata)obj;
            if (this.mDurationInMilliseconds != other.mDurationInMilliseconds) {
                return false;
            }
            if (this.mHeight != other.mHeight) {
                return false;
            }
            if (this.mSuccess != other.mSuccess) {
                return false;
            }
            return this.mWidth == other.mWidth;
        }
    }
}

