/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.ContentViewDownloadDelegate;
import org.chromium.content.browser.DownloadInfo;

@JNINamespace(value="content")
public class DownloadController {
    private static final String LOGTAG = "DownloadController";
    private static DownloadController sInstance;
    private static DownloadNotificationService sDownloadNotificationService;

    @CalledByNative
    public static DownloadController getInstance() {
        if (sInstance == null) {
            sInstance = new DownloadController();
        }
        return sInstance;
    }

    private DownloadController() {
        this.nativeInit();
    }

    private static ContentViewDownloadDelegate downloadDelegateFromView(ContentViewCore view) {
        return view.getDownloadDelegate();
    }

    public static void setDownloadNotificationService(DownloadNotificationService service) {
        sDownloadNotificationService = service;
    }

    @CalledByNative
    public void newHttpGetDownload(ContentViewCore view, String url, String userAgent, String contentDisposition, String mimeType, String cookie, String referer, String filename, long contentLength) {
        ContentViewDownloadDelegate downloadDelegate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelegate != null) {
            DownloadInfo downloadInfo = new DownloadInfo.Builder().setUrl(url).setUserAgent(userAgent).setContentDisposition(contentDisposition).setMimeType(mimeType).setCookie(cookie).setReferer(referer).setFileName(filename).setContentLength(contentLength).setIsGETRequest(true).build();
            downloadDelegate.requestHttpGetDownload(downloadInfo);
        }
    }

    @CalledByNative
    public void onDownloadStarted(ContentViewCore view, String filename, String mimeType) {
        ContentViewDownloadDelegate downloadDelegate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelegate != null) {
            downloadDelegate.onDownloadStarted(filename, mimeType);
        }
    }

    @CalledByNative
    public void onDownloadCompleted(Context context, String url, String mimeType, String filename, String path, long contentLength, boolean successful, int downloadId) {
        if (sDownloadNotificationService != null) {
            DownloadInfo downloadInfo = new DownloadInfo.Builder().setUrl(url).setMimeType(mimeType).setFileName(filename).setFilePath(path).setContentLength(contentLength).setIsSuccessful(successful).setDescription(filename).setDownloadId(downloadId).setHasDownloadId(true).build();
            sDownloadNotificationService.onDownloadCompleted(downloadInfo);
        }
    }

    @CalledByNative
    public void onDownloadUpdated(Context context, String url, String mimeType, String filename, String path, long contentLength, boolean successful, int downloadId, int percentCompleted, long timeRemainingInMs) {
        if (sDownloadNotificationService != null) {
            DownloadInfo downloadInfo = new DownloadInfo.Builder().setUrl(url).setMimeType(mimeType).setFileName(filename).setFilePath(path).setContentLength(contentLength).setIsSuccessful(successful).setDescription(filename).setDownloadId(downloadId).setHasDownloadId(true).setPercentCompleted(percentCompleted).setTimeRemainingInMillis(timeRemainingInMs).build();
            sDownloadNotificationService.onDownloadUpdated(downloadInfo);
        }
    }

    @CalledByNative
    public void onDangerousDownload(ContentViewCore view, String filename, int downloadId) {
        ContentViewDownloadDelegate downloadDelegate = DownloadController.downloadDelegateFromView(view);
        if (downloadDelegate != null) {
            downloadDelegate.onDangerousDownload(filename, downloadId);
        }
    }

    private native void nativeInit();

    public static interface DownloadNotificationService {
        public void onDownloadCompleted(DownloadInfo var1);

        public void onDownloadUpdated(DownloadInfo var1);
    }
}

