/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.chromium.base.CalledByNative;
import org.chromium.base.CollectionUtil;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
class DeviceSensors
implements SensorEventListener {
    private static final String TAG = "DeviceMotionAndOrientation";
    private Thread mThread;
    private Handler mHandler;
    private final Context mAppContext;
    private final Object mHandlerLock = new Object();
    private long mNativePtr;
    private final Object mNativePtrLock = new Object();
    private float[] mTruncatedRotationVector;
    private SensorManagerProxy mSensorManagerProxy;
    private static DeviceSensors sSingleton;
    private static Object sSingletonLock;
    static final int DEVICE_ORIENTATION = 0;
    static final int DEVICE_MOTION = 1;
    static final Set<Integer> DEVICE_ORIENTATION_SENSORS;
    static final Set<Integer> DEVICE_MOTION_SENSORS;
    @VisibleForTesting
    final Set<Integer> mActiveSensors = new HashSet<Integer>();
    boolean mDeviceMotionIsActive = false;
    boolean mDeviceOrientationIsActive = false;

    protected DeviceSensors(Context context) {
        this.mAppContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public boolean start(long nativePtr, int eventType, int rateInMilliseconds) {
        boolean success = false;
        Object object = this.mNativePtrLock;
        synchronized (object) {
            switch (eventType) {
                case 0: {
                    success = this.registerSensors(DEVICE_ORIENTATION_SENSORS, rateInMilliseconds, true);
                    break;
                }
                case 1: {
                    success = this.registerSensors(DEVICE_MOTION_SENSORS, rateInMilliseconds, false);
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("Unknown event type: " + eventType));
                    return false;
                }
            }
            if (success) {
                this.mNativePtr = nativePtr;
                this.setEventTypeActive(eventType, true);
            }
            return success;
        }
    }

    @CalledByNative
    public int getNumberActiveDeviceMotionSensors() {
        HashSet<Integer> deviceMotionSensors = new HashSet<Integer>(DEVICE_MOTION_SENSORS);
        deviceMotionSensors.removeAll(this.mActiveSensors);
        return DEVICE_MOTION_SENSORS.size() - deviceMotionSensors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void stop(int eventType) {
        HashSet<Integer> sensorsToRemainActive = new HashSet<Integer>();
        Object object = this.mNativePtrLock;
        synchronized (object) {
            switch (eventType) {
                case 0: {
                    if (!this.mDeviceMotionIsActive) break;
                    sensorsToRemainActive.addAll(DEVICE_MOTION_SENSORS);
                    break;
                }
                case 1: {
                    if (!this.mDeviceOrientationIsActive) break;
                    sensorsToRemainActive.addAll(DEVICE_ORIENTATION_SENSORS);
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("Unknown event type: " + eventType));
                    return;
                }
            }
            HashSet<Integer> sensorsToDeactivate = new HashSet<Integer>(this.mActiveSensors);
            sensorsToDeactivate.removeAll(sensorsToRemainActive);
            this.unregisterSensors(sensorsToDeactivate);
            this.setEventTypeActive(eventType, false);
            if (this.mActiveSensors.isEmpty()) {
                this.mNativePtr = 0L;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        this.sensorChanged(event.sensor.getType(), event.values);
    }

    @VisibleForTesting
    void sensorChanged(int type, float[] values) {
        switch (type) {
            case 1: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotAccelerationIncludingGravity(values[0], values[1], values[2]);
                break;
            }
            case 10: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotAcceleration(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotRotationRate(values[0], values[1], values[2]);
                break;
            }
            case 11: {
                if (!this.mDeviceOrientationIsActive) break;
                if (values.length > 4) {
                    if (this.mTruncatedRotationVector == null) {
                        this.mTruncatedRotationVector = new float[4];
                    }
                    System.arraycopy(values, 0, this.mTruncatedRotationVector, 0, 4);
                    this.getOrientationFromRotationVector(this.mTruncatedRotationVector);
                    break;
                }
                this.getOrientationFromRotationVector(values);
                break;
            }
            default: {
                return;
            }
        }
    }

    @VisibleForTesting
    public static double[] computeDeviceOrientationFromRotationMatrix(float[] R2, double[] values) {
        if (R2.length != 9) {
            return values;
        }
        if (R2[8] > 0.0f) {
            values[0] = Math.atan2(-R2[1], R2[4]);
            values[1] = Math.asin(R2[7]);
            values[2] = Math.atan2(-R2[6], R2[8]);
        } else if (R2[8] < 0.0f) {
            values[0] = Math.atan2(R2[1], -R2[4]);
            values[1] = -Math.asin(R2[7]);
            values[1] = values[1] + (values[1] >= 0.0 ? -Math.PI : Math.PI);
            values[2] = Math.atan2(R2[6], -R2[8]);
        } else if (R2[6] > 0.0f) {
            values[0] = Math.atan2(-R2[1], R2[4]);
            values[1] = Math.asin(R2[7]);
            values[2] = -1.5707963267948966;
        } else if (R2[6] < 0.0f) {
            values[0] = Math.atan2(R2[1], -R2[4]);
            values[1] = -Math.asin(R2[7]);
            values[1] = values[1] + (values[1] >= 0.0 ? -Math.PI : Math.PI);
            values[2] = -1.5707963267948966;
        } else {
            values[0] = Math.atan2(R2[3], R2[0]);
            values[1] = R2[7] > 0.0f ? 1.5707963267948966 : -1.5707963267948966;
            values[2] = 0.0;
        }
        if (values[0] < 0.0) {
            values[0] = values[0] + Math.PI * 2;
        }
        return values;
    }

    private void getOrientationFromRotationVector(float[] rotationVector) {
        float[] deviceRotationMatrix = new float[9];
        SensorManager.getRotationMatrixFromVector((float[])deviceRotationMatrix, (float[])rotationVector);
        double[] rotationAngles = new double[3];
        DeviceSensors.computeDeviceOrientationFromRotationMatrix(deviceRotationMatrix, rotationAngles);
        this.gotOrientation(Math.toDegrees(rotationAngles[0]), Math.toDegrees(rotationAngles[1]), Math.toDegrees(rotationAngles[2]));
    }

    private SensorManagerProxy getSensorManagerProxy() {
        if (this.mSensorManagerProxy != null) {
            return this.mSensorManagerProxy;
        }
        SensorManager sensorManager = ThreadUtils.runOnUiThreadBlockingNoException(new Callable<SensorManager>(){

            @Override
            public SensorManager call() {
                return (SensorManager)DeviceSensors.this.mAppContext.getSystemService("sensor");
            }
        });
        if (sensorManager != null) {
            this.mSensorManagerProxy = new SensorManagerProxyImpl(sensorManager);
        }
        return this.mSensorManagerProxy;
    }

    @VisibleForTesting
    void setSensorManagerProxy(SensorManagerProxy sensorManagerProxy) {
        this.mSensorManagerProxy = sensorManagerProxy;
    }

    private void setEventTypeActive(int eventType, boolean value) {
        switch (eventType) {
            case 0: {
                this.mDeviceOrientationIsActive = value;
                return;
            }
            case 1: {
                this.mDeviceMotionIsActive = value;
                return;
            }
        }
    }

    private boolean registerSensors(Set<Integer> sensorTypes, int rateInMilliseconds, boolean failOnMissingSensor) {
        HashSet<Integer> sensorsToActivate = new HashSet<Integer>(sensorTypes);
        sensorsToActivate.removeAll(this.mActiveSensors);
        boolean success = false;
        for (Integer sensorType : sensorsToActivate) {
            boolean result = this.registerForSensorType(sensorType, rateInMilliseconds);
            if (!result && failOnMissingSensor) {
                this.unregisterSensors(sensorsToActivate);
                return false;
            }
            if (!result) continue;
            this.mActiveSensors.add(sensorType);
            success = true;
        }
        return success;
    }

    private void unregisterSensors(Iterable<Integer> sensorTypes) {
        for (Integer sensorType : sensorTypes) {
            if (!this.mActiveSensors.contains(sensorType)) continue;
            this.getSensorManagerProxy().unregisterListener(this, sensorType);
            this.mActiveSensors.remove(sensorType);
        }
    }

    private boolean registerForSensorType(int type, int rateInMilliseconds) {
        SensorManagerProxy sensorManager = this.getSensorManagerProxy();
        if (sensorManager == null) {
            return false;
        }
        int rateInMicroseconds = 1000 * rateInMilliseconds;
        return sensorManager.registerListener(this, type, rateInMicroseconds, this.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotOrientation(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotOrientation(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotAcceleration(double x, double y, double z) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotAcceleration(this.mNativePtr, x, y, z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotAccelerationIncludingGravity(double x, double y, double z) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotAccelerationIncludingGravity(this.mNativePtr, x, y, z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotRotationRate(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotRotationRate(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getHandler() {
        Object object = this.mHandlerLock;
        synchronized (object) {
            if (this.mHandler == null) {
                HandlerThread thread = new HandlerThread(TAG);
                thread.start();
                this.mHandler = new Handler(thread.getLooper());
            }
            return this.mHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    static DeviceSensors getInstance(Context appContext) {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new DeviceSensors(appContext);
            }
            return sSingleton;
        }
    }

    private native void nativeGotOrientation(long var1, double var3, double var5, double var7);

    private native void nativeGotAcceleration(long var1, double var3, double var5, double var7);

    private native void nativeGotAccelerationIncludingGravity(long var1, double var3, double var5, double var7);

    private native void nativeGotRotationRate(long var1, double var3, double var5, double var7);

    static {
        sSingletonLock = new Object();
        DEVICE_ORIENTATION_SENSORS = CollectionUtil.newHashSet(11);
        DEVICE_MOTION_SENSORS = CollectionUtil.newHashSet(1, 10, 4);
    }

    static class SensorManagerProxyImpl
    implements SensorManagerProxy {
        private final SensorManager mSensorManager;

        SensorManagerProxyImpl(SensorManager sensorManager) {
            this.mSensorManager = sensorManager;
        }

        public boolean registerListener(SensorEventListener listener, int sensorType, int rate, Handler handler) {
            List sensors = this.mSensorManager.getSensorList(sensorType);
            if (sensors.isEmpty()) {
                return false;
            }
            return this.mSensorManager.registerListener(listener, (Sensor)sensors.get(0), rate, handler);
        }

        public void unregisterListener(SensorEventListener listener, int sensorType) {
            List sensors = this.mSensorManager.getSensorList(sensorType);
            if (!sensors.isEmpty()) {
                this.mSensorManager.unregisterListener(listener, (Sensor)sensors.get(0));
            }
        }
    }

    static interface SensorManagerProxy {
        public boolean registerListener(SensorEventListener var1, int var2, int var3, Handler var4);

        public void unregisterListener(SensorEventListener var1, int var2);
    }
}

