/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.FeatureInfo;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Log;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import com.google.common.annotations.VisibleForTesting;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.CalledByNative;
import org.chromium.base.CommandLine;
import org.chromium.base.JNINamespace;
import org.chromium.base.ObserverList;
import org.chromium.base.TraceEvent;
import org.chromium.content.R;
import org.chromium.content.browser.ContentSettings;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.ContentViewClient;
import org.chromium.content.browser.ContentViewDownloadDelegate;
import org.chromium.content.browser.DeviceUtils;
import org.chromium.content.browser.InterstitialPageDelegateAndroid;
import org.chromium.content.browser.JavascriptInterface;
import org.chromium.content.browser.LoadUrlParams;
import org.chromium.content.browser.NavigationClient;
import org.chromium.content.browser.NavigationEntry;
import org.chromium.content.browser.NavigationHistory;
import org.chromium.content.browser.PopupZoomer;
import org.chromium.content.browser.PositionObserver;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.ScreenOrientationListener;
import org.chromium.content.browser.SelectActionModeCallback;
import org.chromium.content.browser.TouchEventSynthesizer;
import org.chromium.content.browser.ViewPositionObserver;
import org.chromium.content.browser.WebContentsObserverAndroid;
import org.chromium.content.browser.accessibility.AccessibilityInjector;
import org.chromium.content.browser.accessibility.BrowserAccessibilityManager;
import org.chromium.content.browser.input.AdapterInputConnection;
import org.chromium.content.browser.input.GamepadList;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.InputMethodManagerWrapper;
import org.chromium.content.browser.input.InsertionHandleController;
import org.chromium.content.browser.input.SelectPopup;
import org.chromium.content.browser.input.SelectPopupDialog;
import org.chromium.content.browser.input.SelectPopupDropdown;
import org.chromium.content.browser.input.SelectPopupItem;
import org.chromium.content.browser.input.SelectionHandleController;
import org.chromium.content_public.browser.GestureStateListener;
import org.chromium.content_public.browser.WebContents;
import org.chromium.ui.base.ViewAndroid;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.chromium.ui.base.WindowAndroid;
import org.chromium.ui.gfx.DeviceDisplayInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
public class ContentViewCore
implements NavigationClient,
AccessibilityManager.AccessibilityStateChangeListener,
ScreenOrientationListener.ScreenOrientationObserver {
    private static final String TAG = "ContentViewCore";
    private static final float ZOOM_CONTROLS_EPSILON = 0.007f;
    private static final int IS_LONG_PRESS = 1;
    private static final int IS_LONG_TAP = 2;
    private static final int TEXT_HANDLE_FADE_IN_DELAY = 300;
    private static final int SPEN_ACTION_DOWN = 211;
    private static final int SPEN_ACTION_UP = 212;
    private static final int SPEN_ACTION_MOVE = 213;
    private static final int SPEN_ACTION_CANCEL = 214;
    private static Boolean sIsSPenSupported;
    private final Map<String, Object> mJavaScriptInterfaces = new HashMap<String, Object>();
    private final HashSet<Object> mRetainedJavaScriptObjects = new HashSet();
    private final Context mContext;
    private ViewGroup mContainerView;
    private InternalAccessDelegate mContainerViewInternals;
    private WebContents mWebContents;
    private WebContentsObserverAndroid mWebContentsObserver;
    private ContentViewClient mContentViewClient;
    private ContentSettings mContentSettings;
    private long mNativeContentViewCore = 0L;
    private final ObserverList<GestureStateListener> mGestureStateListeners;
    private final ObserverList.RewindableIterator<GestureStateListener> mGestureStateListenersIterator;
    private ZoomControlsDelegate mZoomControlsDelegate;
    private PopupZoomer mPopupZoomer;
    private SelectPopup mSelectPopup;
    private Runnable mFakeMouseMoveRunnable = null;
    private ImeAdapter mImeAdapter;
    private ImeAdapter.AdapterInputConnectionFactory mAdapterInputConnectionFactory;
    private AdapterInputConnection mInputConnection;
    private InputMethodManagerWrapper mInputMethodManagerWrapper;
    private SelectionHandleController mSelectionHandleController;
    private InsertionHandleController mInsertionHandleController;
    private Runnable mDeferredHandleFadeInRunnable;
    private PositionObserver mPositionObserver;
    private PositionObserver.Listener mPositionListener;
    private int mViewportWidthPix;
    private int mViewportHeightPix;
    private int mPhysicalBackingWidthPix;
    private int mPhysicalBackingHeightPix;
    private int mOverdrawBottomHeightPix;
    private int mViewportSizeOffsetWidthPix;
    private int mViewportSizeOffsetHeightPix;
    private final RenderCoordinates mRenderCoordinates;
    private final RenderCoordinates.NormalizedPoint mStartHandlePoint;
    private final RenderCoordinates.NormalizedPoint mEndHandlePoint;
    private final RenderCoordinates.NormalizedPoint mInsertionHandlePoint;
    private boolean mHasSelection;
    private String mLastSelectedText;
    private boolean mSelectionEditable;
    private ActionMode mActionMode;
    private boolean mUnselectAllOnActionModeDismiss;
    private ContentViewDownloadDelegate mDownloadDelegate;
    private AccessibilityInjector mAccessibilityInjector;
    private boolean mNativeAccessibilityAllowed;
    private boolean mNativeAccessibilityEnabled;
    private BrowserAccessibilityManager mBrowserAccessibilityManager;
    private final AccessibilityManager mAccessibilityManager;
    private boolean mTouchExplorationEnabled;
    private ContentObserver mAccessibilityScriptInjectionObserver;
    private final Rect mFocusPreOSKViewportRect = new Rect();
    private int mLastTapX;
    private int mLastTapY;
    private boolean mTouchScrollInProgress;
    private int mPotentiallyActiveFlingCount;
    private ViewAndroid mViewAndroid;
    private SmartClipDataListener mSmartClipDataListener = null;
    private final Editable mEditable;
    public static final int INVALID_RENDER_PROCESS_PID = 0;
    private float mCurrentTouchOffsetX;
    private float mCurrentTouchOffsetY;
    private int mSmartClipOffsetX;
    private int mSmartClipOffsetY;

    public ContentViewCore(Context context) {
        this.mContext = context;
        this.mAdapterInputConnectionFactory = new ImeAdapter.AdapterInputConnectionFactory();
        this.mInputMethodManagerWrapper = new InputMethodManagerWrapper(this.mContext);
        this.mRenderCoordinates = new RenderCoordinates();
        float deviceScaleFactor = this.getContext().getResources().getDisplayMetrics().density;
        String forceScaleFactor = CommandLine.getInstance().getSwitchValue("force-device-scale-factor");
        if (forceScaleFactor != null) {
            deviceScaleFactor = Float.valueOf(forceScaleFactor).floatValue();
        }
        this.mRenderCoordinates.setDeviceScaleFactor(deviceScaleFactor);
        this.mStartHandlePoint = this.mRenderCoordinates.createNormalizedPoint();
        this.mEndHandlePoint = this.mRenderCoordinates.createNormalizedPoint();
        this.mInsertionHandlePoint = this.mRenderCoordinates.createNormalizedPoint();
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.mGestureStateListeners = new ObserverList();
        this.mGestureStateListenersIterator = this.mGestureStateListeners.rewindableIterator();
        this.mEditable = Editable.Factory.getInstance().newEditable((CharSequence)"");
        Selection.setSelection((Spannable)this.mEditable, (int)0);
    }

    @CalledByNative
    public Context getContext() {
        return this.mContext;
    }

    public ViewGroup getContainerView() {
        return this.mContainerView;
    }

    public WebContents getWebContents() {
        return this.mWebContents;
    }

    public void setViewportSizeOffset(int offsetXPix, int offsetYPix) {
        if (offsetXPix != this.mViewportSizeOffsetWidthPix || offsetYPix != this.mViewportSizeOffsetHeightPix) {
            this.mViewportSizeOffsetWidthPix = offsetXPix;
            this.mViewportSizeOffsetHeightPix = offsetYPix;
            if (this.mNativeContentViewCore != 0L) {
                this.nativeWasResized(this.mNativeContentViewCore);
            }
        }
    }

    @VisibleForTesting
    public ViewAndroidDelegate getViewAndroidDelegate() {
        return new ViewAndroidDelegate(){
            private final ViewGroup mContainerViewAtCreation;
            {
                this.mContainerViewAtCreation = ContentViewCore.this.mContainerView;
            }

            public View acquireAnchorView() {
                View anchorView = new View(ContentViewCore.this.mContext);
                this.mContainerViewAtCreation.addView(anchorView);
                return anchorView;
            }

            public void setAnchorViewPosition(View view, float x, float y, float width, float height) {
                assert (view.getParent() == this.mContainerViewAtCreation);
                float scale = (float)DeviceDisplayInfo.create(ContentViewCore.this.mContext).getDIPScale();
                int leftMargin = Math.round(x * scale);
                int topMargin = Math.round(ContentViewCore.this.mRenderCoordinates.getContentOffsetYPix() + y * scale);
                int scaledWidth = Math.round(width * scale);
                if (this.mContainerViewAtCreation instanceof FrameLayout) {
                    int startMargin = ApiCompatibilityUtils.isLayoutRtl((View)this.mContainerViewAtCreation) ? this.mContainerViewAtCreation.getMeasuredWidth() - Math.round((width + x) * scale) : leftMargin;
                    if (scaledWidth + startMargin > this.mContainerViewAtCreation.getWidth()) {
                        scaledWidth = this.mContainerViewAtCreation.getWidth() - startMargin;
                    }
                    FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(scaledWidth, Math.round(height * scale));
                    ApiCompatibilityUtils.setMarginStart((ViewGroup.MarginLayoutParams)lp, startMargin);
                    lp.topMargin = topMargin;
                    view.setLayoutParams((ViewGroup.LayoutParams)lp);
                } else if (this.mContainerViewAtCreation instanceof AbsoluteLayout) {
                    AbsoluteLayout.LayoutParams lp = new AbsoluteLayout.LayoutParams(scaledWidth, (int)(height * scale), leftMargin += ContentViewCore.this.mRenderCoordinates.getScrollXPixInt(), topMargin += ContentViewCore.this.mRenderCoordinates.getScrollYPixInt());
                    view.setLayoutParams((ViewGroup.LayoutParams)lp);
                } else {
                    Log.e((String)ContentViewCore.TAG, (String)("Unknown layout " + this.mContainerViewAtCreation.getClass().getName()));
                }
            }

            public void releaseAnchorView(View anchorView) {
                this.mContainerViewAtCreation.removeView(anchorView);
            }
        };
    }

    @VisibleForTesting
    public void setImeAdapterForTest(ImeAdapter imeAdapter) {
        this.mImeAdapter = imeAdapter;
    }

    @VisibleForTesting
    public ImeAdapter getImeAdapterForTest() {
        return this.mImeAdapter;
    }

    @VisibleForTesting
    public void setAdapterInputConnectionFactory(ImeAdapter.AdapterInputConnectionFactory factory) {
        this.mAdapterInputConnectionFactory = factory;
    }

    @VisibleForTesting
    public void setInputMethodManagerWrapperForTest(InputMethodManagerWrapper immw) {
        this.mInputMethodManagerWrapper = immw;
    }

    @VisibleForTesting
    public AdapterInputConnection getInputConnectionForTest() {
        return this.mInputConnection;
    }

    private ImeAdapter createImeAdapter(Context context) {
        return new ImeAdapter(this.mInputMethodManagerWrapper, new ImeAdapter.ImeAdapterDelegate(){

            public void onImeEvent(boolean isFinish) {
                ContentViewCore.this.getContentViewClient().onImeEvent();
                if (!isFinish) {
                    ContentViewCore.this.hideHandles();
                }
            }

            public void onDismissInput() {
                ContentViewCore.this.getContentViewClient().onImeStateChangeRequested(false);
            }

            public View getAttachedView() {
                return ContentViewCore.this.mContainerView;
            }

            public ResultReceiver getNewShowKeyboardReceiver() {
                return new ResultReceiver(new Handler()){

                    public void onReceiveResult(int resultCode, Bundle resultData) {
                        ContentViewCore.this.getContentViewClient().onImeStateChangeRequested(resultCode == 2 || resultCode == 0);
                        if (resultCode == 2) {
                            ContentViewCore.this.getContainerView().getWindowVisibleDisplayFrame(ContentViewCore.this.mFocusPreOSKViewportRect);
                        } else if (ContentViewCore.this.hasFocus() && resultCode == 0) {
                            ContentViewCore.this.scrollFocusedEditableNodeIntoView();
                        }
                    }
                };
            }
        });
    }

    public void initialize(ViewGroup containerView, InternalAccessDelegate internalDispatcher, long nativeWebContents, WindowAndroid windowAndroid) {
        this.setContainerView(containerView);
        this.mPositionListener = new PositionObserver.Listener(){

            public void onPositionChanged(int x, int y) {
                if (ContentViewCore.this.isSelectionHandleShowing() || ContentViewCore.this.isInsertionHandleShowing()) {
                    ContentViewCore.this.temporarilyHideTextHandles();
                }
            }
        };
        long windowNativePointer = windowAndroid != null ? windowAndroid.getNativePointer() : 0L;
        long viewAndroidNativePointer = 0L;
        if (windowNativePointer != 0L) {
            this.mViewAndroid = new ViewAndroid(windowAndroid, this.getViewAndroidDelegate());
            viewAndroidNativePointer = this.mViewAndroid.getNativePointer();
        }
        this.mZoomControlsDelegate = new ZoomControlsDelegate(){

            public void invokeZoomPicker() {
            }

            public void dismissZoomPicker() {
            }

            public void updateZoomControls() {
            }
        };
        this.mNativeContentViewCore = this.nativeInit(nativeWebContents, viewAndroidNativePointer, windowNativePointer, this.mRetainedJavaScriptObjects);
        this.mWebContents = this.nativeGetWebContentsAndroid(this.mNativeContentViewCore);
        this.mContentSettings = new ContentSettings(this, this.mNativeContentViewCore);
        this.setContainerViewInternals(internalDispatcher);
        this.mRenderCoordinates.reset();
        this.initPopupZoomer(this.mContext);
        this.mImeAdapter = this.createImeAdapter(this.mContext);
        this.mAccessibilityInjector = AccessibilityInjector.newInstance(this);
        this.mWebContentsObserver = new WebContentsObserverAndroid(this){

            public void didNavigateMainFrame(String url, String baseUrl, boolean isNavigationToDifferentPage, boolean isFragmentNavigation) {
                if (!isNavigationToDifferentPage) {
                    return;
                }
                ContentViewCore.this.hidePopups();
                ContentViewCore.this.resetScrollInProgress();
                ContentViewCore.this.resetGestureDetection();
            }

            public void renderProcessGone(boolean wasOomProtected) {
                ContentViewCore.this.hidePopups();
                ContentViewCore.this.resetScrollInProgress();
            }
        };
    }

    public void setContainerView(ViewGroup containerView) {
        TraceEvent.begin();
        if (this.mContainerView != null) {
            this.mPositionObserver.removeListener(this.mPositionListener);
            this.mSelectionHandleController = null;
            this.mInsertionHandleController = null;
            this.mInputConnection = null;
        }
        this.mContainerView = containerView;
        this.mPositionObserver = new ViewPositionObserver((View)this.mContainerView);
        String contentDescription = "Web View";
        if (R.string.accessibility_content_view == 0) {
            Log.w((String)TAG, (String)"Setting contentDescription to 'Web View' as no value was specified.");
        } else {
            contentDescription = this.mContext.getResources().getString(R.string.accessibility_content_view);
        }
        this.mContainerView.setContentDescription((CharSequence)contentDescription);
        this.mContainerView.setWillNotDraw(false);
        this.mContainerView.setClickable(true);
        TraceEvent.end();
    }

    @CalledByNative
    void onNativeContentViewCoreDestroyed(long nativeContentViewCore) {
        assert (nativeContentViewCore == this.mNativeContentViewCore);
        this.mNativeContentViewCore = 0L;
    }

    public void setContainerViewInternals(InternalAccessDelegate internalDispatcher) {
        this.mContainerViewInternals = internalDispatcher;
    }

    private void initPopupZoomer(Context context) {
        this.mPopupZoomer = new PopupZoomer(context);
        this.mPopupZoomer.setOnVisibilityChangedListener(new PopupZoomer.OnVisibilityChangedListener(){
            private final ViewGroup mContainerViewAtCreation;
            {
                this.mContainerViewAtCreation = ContentViewCore.this.mContainerView;
            }

            public void onPopupZoomerShown(final PopupZoomer zoomer) {
                this.mContainerViewAtCreation.post(new Runnable(){

                    public void run() {
                        if (mContainerViewAtCreation.indexOfChild((View)zoomer) == -1) {
                            mContainerViewAtCreation.addView((View)zoomer);
                        } else assert (false) : "PopupZoomer should never be shown without being hidden";
                    }
                });
            }

            public void onPopupZoomerHidden(final PopupZoomer zoomer) {
                this.mContainerViewAtCreation.post(new Runnable(){

                    public void run() {
                        if (mContainerViewAtCreation.indexOfChild((View)zoomer) != -1) {
                            mContainerViewAtCreation.removeView((View)zoomer);
                            mContainerViewAtCreation.invalidate();
                        } else assert (false) : "PopupZoomer should never be hidden without being shown";
                    }
                });
            }
        });
        PopupZoomer.OnTapListener listener = new PopupZoomer.OnTapListener(){
            private final ViewGroup mContainerViewAtCreation;
            {
                this.mContainerViewAtCreation = ContentViewCore.this.mContainerView;
            }

            public boolean onSingleTap(View v, MotionEvent e) {
                this.mContainerViewAtCreation.requestFocus();
                if (ContentViewCore.this.mNativeContentViewCore != 0L) {
                    ContentViewCore.this.nativeSingleTap(ContentViewCore.this.mNativeContentViewCore, e.getEventTime(), e.getX(), e.getY());
                }
                return true;
            }

            public boolean onLongPress(View v, MotionEvent e) {
                if (ContentViewCore.this.mNativeContentViewCore != 0L) {
                    ContentViewCore.this.nativeLongPress(ContentViewCore.this.mNativeContentViewCore, e.getEventTime(), e.getX(), e.getY());
                }
                return true;
            }
        };
        this.mPopupZoomer.setOnTapListener(listener);
    }

    public void destroy() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeOnJavaContentViewCoreDestroyed(this.mNativeContentViewCore);
        }
        this.mWebContents = null;
        if (this.mViewAndroid != null) {
            this.mViewAndroid.destroy();
        }
        this.mNativeContentViewCore = 0L;
        this.mContentSettings = null;
        this.mJavaScriptInterfaces.clear();
        this.mRetainedJavaScriptObjects.clear();
        this.unregisterAccessibilityContentObserver();
        this.mGestureStateListeners.clear();
        ScreenOrientationListener.getInstance().removeObserver(this);
    }

    private void unregisterAccessibilityContentObserver() {
        if (this.mAccessibilityScriptInjectionObserver == null) {
            return;
        }
        this.getContext().getContentResolver().unregisterContentObserver(this.mAccessibilityScriptInjectionObserver);
        this.mAccessibilityScriptInjectionObserver = null;
    }

    public boolean isAlive() {
        return this.mNativeContentViewCore != 0L;
    }

    @CalledByNative
    public long getNativeContentViewCore() {
        return this.mNativeContentViewCore;
    }

    public void setContentViewClient(ContentViewClient client) {
        if (client == null) {
            throw new IllegalArgumentException("The client can't be null.");
        }
        this.mContentViewClient = client;
    }

    @VisibleForTesting
    public ContentViewClient getContentViewClient() {
        if (this.mContentViewClient == null) {
            this.mContentViewClient = new ContentViewClient();
        }
        return this.mContentViewClient;
    }

    public int getBackgroundColor() {
        if (this.mNativeContentViewCore != 0L) {
            return this.nativeGetBackgroundColor(this.mNativeContentViewCore);
        }
        return -1;
    }

    @CalledByNative
    private void onBackgroundColorChanged(int color2) {
        this.getContentViewClient().onBackgroundColorChanged(color2);
    }

    public void loadUrl(LoadUrlParams params) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeLoadUrl(this.mNativeContentViewCore, params.mUrl, params.mLoadUrlType, params.mTransitionType, params.getReferrer() != null ? params.getReferrer().getUrl() : null, params.getReferrer() != null ? params.getReferrer().getPolicy() : 0, params.mUaOverrideOption, params.getExtraHeadersString(), params.mPostData, params.mBaseUrlForDataUrl, params.mVirtualUrlForDataUrl, params.mCanLoadLocalResources, params.mIsRendererInitiated);
    }

    public void stopLoading() {
        if (this.mWebContents != null) {
            this.mWebContents.stop();
        }
    }

    public String getUrl() {
        if (this.mNativeContentViewCore != 0L) {
            return this.nativeGetURL(this.mNativeContentViewCore);
        }
        return null;
    }

    public String getTitle() {
        return this.mWebContents == null ? null : this.mWebContents.getTitle();
    }

    @VisibleForTesting
    public void showInterstitialPage(String url, InterstitialPageDelegateAndroid delegate) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeShowInterstitialPage(this.mNativeContentViewCore, url, delegate.getNative());
    }

    public boolean isShowingInterstitialPage() {
        return this.mNativeContentViewCore == 0L ? false : this.nativeIsShowingInterstitialPage(this.mNativeContentViewCore);
    }

    @CalledByNative
    public int getViewportWidthPix() {
        return this.mViewportWidthPix;
    }

    @CalledByNative
    public int getViewportHeightPix() {
        return this.mViewportHeightPix;
    }

    @CalledByNative
    public int getPhysicalBackingWidthPix() {
        return this.mPhysicalBackingWidthPix;
    }

    @CalledByNative
    public int getPhysicalBackingHeightPix() {
        return this.mPhysicalBackingHeightPix;
    }

    @CalledByNative
    public int getOverdrawBottomHeightPix() {
        return this.mOverdrawBottomHeightPix;
    }

    @CalledByNative
    public int getViewportSizeOffsetWidthPix() {
        return this.mViewportSizeOffsetWidthPix;
    }

    @CalledByNative
    public int getViewportSizeOffsetHeightPix() {
        return this.mViewportSizeOffsetHeightPix;
    }

    public float getContentHeightCss() {
        return this.mRenderCoordinates.getContentHeightCss();
    }

    public float getContentWidthCss() {
        return this.mRenderCoordinates.getContentWidthCss();
    }

    public boolean canGoBack() {
        return this.mWebContents != null && this.mWebContents.getNavigationController().canGoBack();
    }

    public boolean canGoForward() {
        return this.mWebContents != null && this.mWebContents.getNavigationController().canGoForward();
    }

    public boolean canGoToOffset(int offset) {
        return this.mWebContents != null && this.mWebContents.getNavigationController().canGoToOffset(offset);
    }

    public void goToOffset(int offset) {
        if (this.mWebContents != null) {
            this.mWebContents.getNavigationController().goToOffset(offset);
        }
    }

    @Override
    public void goToNavigationIndex(int index) {
        if (this.mWebContents != null) {
            this.mWebContents.getNavigationController().goToNavigationIndex(index);
        }
    }

    public void goBack() {
        if (this.mWebContents != null) {
            this.mWebContents.getNavigationController().goBack();
        }
    }

    public void goForward() {
        if (this.mWebContents != null) {
            this.mWebContents.getNavigationController().goForward();
        }
    }

    public void loadIfNecessary() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeLoadIfNecessary(this.mNativeContentViewCore);
        }
    }

    public void requestRestoreLoad() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeRequestRestoreLoad(this.mNativeContentViewCore);
        }
    }

    public void reload(boolean checkForRepost) {
        this.mAccessibilityInjector.addOrRemoveAccessibilityApisIfNecessary();
        if (this.mNativeContentViewCore != 0L) {
            this.nativeReload(this.mNativeContentViewCore, checkForRepost);
        }
    }

    public void reloadIgnoringCache(boolean checkForRepost) {
        this.mAccessibilityInjector.addOrRemoveAccessibilityApisIfNecessary();
        if (this.mNativeContentViewCore != 0L) {
            this.nativeReloadIgnoringCache(this.mNativeContentViewCore, checkForRepost);
        }
    }

    public void cancelPendingReload() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeCancelPendingReload(this.mNativeContentViewCore);
        }
    }

    public void continuePendingReload() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeContinuePendingReload(this.mNativeContentViewCore);
        }
    }

    public void clearHistory() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeClearHistory(this.mNativeContentViewCore);
        }
    }

    public String getSelectedText() {
        return this.mHasSelection ? this.mLastSelectedText : "";
    }

    public boolean isSelectionEditable() {
        return this.mHasSelection ? this.mSelectionEditable : false;
    }

    public static boolean isSPenSupported(Context context) {
        if (sIsSPenSupported == null) {
            sIsSPenSupported = ContentViewCore.detectSPenSupport(context);
        }
        return sIsSPenSupported;
    }

    private static boolean detectSPenSupport(Context context) {
        FeatureInfo[] infos;
        if (!"SAMSUNG".equalsIgnoreCase(Build.MANUFACTURER)) {
            return false;
        }
        for (FeatureInfo info : infos = context.getPackageManager().getSystemAvailableFeatures()) {
            if (!"com.sec.feature.spen_usp".equalsIgnoreCase(info.name)) continue;
            return true;
        }
        return false;
    }

    public static int convertSPenEventAction(int eventActionMasked) {
        switch (eventActionMasked) {
            case 211: {
                return 0;
            }
            case 212: {
                return 1;
            }
            case 213: {
                return 2;
            }
            case 214: {
                return 3;
            }
        }
        return eventActionMasked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouchEvent(MotionEvent event) {
        TraceEvent.begin("onTouchEvent");
        try {
            this.cancelRequestToScrollFocusedEditableNodeIntoView();
            int eventAction = event.getActionMasked();
            if (ContentViewCore.isSPenSupported(this.mContext)) {
                eventAction = ContentViewCore.convertSPenEventAction(eventAction);
            }
            if (eventAction != 0 && eventAction != 1 && eventAction != 3 && eventAction != 2 && eventAction != 5 && eventAction != 6) {
                boolean bl = false;
                return bl;
            }
            if (this.mNativeContentViewCore == 0L) {
                boolean bl = false;
                return bl;
            }
            MotionEvent offset = null;
            if (this.mCurrentTouchOffsetX != 0.0f || this.mCurrentTouchOffsetY != 0.0f) {
                event = offset = this.createOffsetMotionEvent(event);
            }
            int pointerCount = event.getPointerCount();
            boolean consumed = this.nativeOnTouchEvent(this.mNativeContentViewCore, event, event.getEventTime(), eventAction, pointerCount, event.getHistorySize(), event.getActionIndex(), event.getX(), event.getY(), pointerCount > 1 ? event.getX(1) : 0.0f, pointerCount > 1 ? event.getY(1) : 0.0f, event.getPointerId(0), pointerCount > 1 ? event.getPointerId(1) : -1, event.getTouchMajor(), pointerCount > 1 ? event.getTouchMajor(1) : 0.0f, event.getRawX(), event.getRawY(), event.getToolType(0), pointerCount > 1 ? event.getToolType(1) : 0, event.getButtonState());
            if (offset != null) {
                offset.recycle();
            }
            boolean bl = consumed;
            return bl;
        }
        finally {
            TraceEvent.end("onTouchEvent");
        }
    }

    public void setIgnoreRemainingTouchEvents() {
        this.resetGestureDetection();
    }

    public boolean isScrollInProgress() {
        return this.mTouchScrollInProgress || this.mPotentiallyActiveFlingCount > 0;
    }

    @CalledByNative
    private void onFlingStartEventConsumed(int vx, int vy) {
        this.mTouchScrollInProgress = false;
        ++this.mPotentiallyActiveFlingCount;
        this.temporarilyHideTextHandles();
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            ((GestureStateListener)this.mGestureStateListenersIterator.next()).onFlingStartGesture(vx, vy, this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
        }
    }

    @CalledByNative
    private void onFlingStartEventHadNoConsumer(int vx, int vy) {
        this.mTouchScrollInProgress = false;
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            ((GestureStateListener)this.mGestureStateListenersIterator.next()).onUnhandledFlingStartEvent(vx, vy);
        }
    }

    @CalledByNative
    private void onFlingCancelEventAck() {
        this.updateGestureStateListener(10);
    }

    @CalledByNative
    private void onScrollBeginEventAck() {
        this.mTouchScrollInProgress = true;
        this.temporarilyHideTextHandles();
        this.mZoomControlsDelegate.invokeZoomPicker();
        this.updateGestureStateListener(6);
    }

    @CalledByNative
    private void onScrollUpdateGestureConsumed() {
        this.mZoomControlsDelegate.invokeZoomPicker();
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            ((GestureStateListener)this.mGestureStateListenersIterator.next()).onScrollUpdateGestureConsumed();
        }
    }

    @CalledByNative
    private void onScrollEndEventAck() {
        if (!this.mTouchScrollInProgress) {
            return;
        }
        this.mTouchScrollInProgress = false;
        this.updateGestureStateListener(8);
    }

    @CalledByNative
    private void onPinchBeginEventAck() {
        this.temporarilyHideTextHandles();
        this.updateGestureStateListener(12);
    }

    @CalledByNative
    private void onPinchEndEventAck() {
        this.updateGestureStateListener(14);
    }

    @CalledByNative
    private void onSingleTapEventAck(boolean consumed, int x, int y) {
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            ((GestureStateListener)this.mGestureStateListenersIterator.next()).onSingleTap(consumed, x, y);
        }
    }

    @CalledByNative
    private void onDoubleTapEventAck() {
        this.temporarilyHideTextHandles();
    }

    @CalledByNative
    private boolean filterTapOrPressEvent(int type, int x, int y) {
        if (type == 5 && this.offerLongPressToEmbedder()) {
            return true;
        }
        this.updateForTapOrPress(type, x, y);
        return false;
    }

    @VisibleForTesting
    public void sendDoubleTapForTest(long timeMs, int x, int y) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeDoubleTap(this.mNativeContentViewCore, timeMs, x, y);
    }

    @VisibleForTesting
    public void flingForTest(long timeMs, int x, int y, int velocityX, int velocityY) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeFlingCancel(this.mNativeContentViewCore, timeMs);
        this.nativeScrollBegin(this.mNativeContentViewCore, timeMs, x, y, velocityX, velocityY);
        this.nativeFlingStart(this.mNativeContentViewCore, timeMs, x, y, velocityX, velocityY);
    }

    public void cancelFling(long timeMs) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeFlingCancel(this.mNativeContentViewCore, timeMs);
    }

    public void addGestureStateListener(GestureStateListener listener) {
        this.mGestureStateListeners.addObserver(listener);
    }

    public void removeGestureStateListener(GestureStateListener listener) {
        this.mGestureStateListeners.removeObserver(listener);
    }

    void updateGestureStateListener(int gestureType) {
        this.mGestureStateListenersIterator.rewind();
        while (this.mGestureStateListenersIterator.hasNext()) {
            GestureStateListener listener = (GestureStateListener)this.mGestureStateListenersIterator.next();
            switch (gestureType) {
                case 12: {
                    listener.onPinchStarted();
                    break;
                }
                case 14: {
                    listener.onPinchEnded();
                    break;
                }
                case 11: {
                    listener.onFlingEndGesture(this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
                    break;
                }
                case 10: {
                    listener.onFlingCancelGesture();
                    break;
                }
                case 6: {
                    listener.onScrollStarted(this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
                    break;
                }
                case 8: {
                    listener.onScrollEnded(this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
                    break;
                }
            }
        }
    }

    void addStyleSheetByURL(String url) {
        this.nativeAddStyleSheetByURL(this.mNativeContentViewCore, url);
    }

    public void evaluateJavaScript(String script, JavaScriptCallback callback) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeEvaluateJavaScript(this.mNativeContentViewCore, script, callback, false);
    }

    public void evaluateJavaScriptEvenIfNotYetNavigated(String script) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeEvaluateJavaScript(this.mNativeContentViewCore, script, null, true);
    }

    public void onShow() {
        assert (this.mNativeContentViewCore != 0L);
        this.nativeOnShow(this.mNativeContentViewCore);
        this.setAccessibilityState(this.mAccessibilityManager.isEnabled());
    }

    public int getCurrentRenderProcessId() {
        return this.nativeGetCurrentRenderProcessId(this.mNativeContentViewCore);
    }

    public void onHide() {
        assert (this.mNativeContentViewCore != 0L);
        this.hidePopups();
        this.setInjectedAccessibility(false);
        this.nativeOnHide(this.mNativeContentViewCore);
    }

    public ContentSettings getContentSettings() {
        return this.mContentSettings;
    }

    private void hidePopups() {
        this.hideSelectPopup();
        this.hideHandles();
        this.hideSelectActionBar();
    }

    public void hideSelectActionBar() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            this.mActionMode = null;
        }
    }

    public boolean isSelectActionBarShowing() {
        return this.mActionMode != null;
    }

    private void resetGestureDetection() {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeResetGestureDetection(this.mNativeContentViewCore);
    }

    public void onAttachedToWindow() {
        this.setAccessibilityState(this.mAccessibilityManager.isEnabled());
        ScreenOrientationListener.getInstance().addObserver(this, this.mContext);
        GamepadList.onAttachedToWindow(this.mContext);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void onDetachedFromWindow() {
        this.setInjectedAccessibility(false);
        this.hidePopups();
        this.mZoomControlsDelegate.dismissZoomPicker();
        this.unregisterAccessibilityContentObserver();
        ScreenOrientationListener.getInstance().removeObserver(this);
        GamepadList.onDetachedFromWindow();
    }

    public void onVisibilityChanged(View changedView, int visibility) {
        if (visibility != 0) {
            this.mZoomControlsDelegate.dismissZoomPicker();
        }
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (!this.mImeAdapter.hasTextInputType()) {
            outAttrs.imeOptions = 0x2000000;
        }
        this.mInputConnection = this.mAdapterInputConnectionFactory.get((View)this.mContainerView, this.mImeAdapter, this.mEditable, outAttrs);
        return this.mInputConnection;
    }

    @VisibleForTesting
    public AdapterInputConnection getAdapterInputConnectionForTest() {
        return this.mInputConnection;
    }

    @VisibleForTesting
    public Editable getEditableForTest() {
        return this.mEditable;
    }

    public boolean onCheckIsTextEditor() {
        return this.mImeAdapter.hasTextInputType();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        TraceEvent.begin();
        if (newConfig.keyboard != 1) {
            if (this.mNativeContentViewCore != 0L) {
                this.mImeAdapter.attach(this.nativeGetNativeImeAdapter(this.mNativeContentViewCore), ImeAdapter.getTextInputTypeNone());
            }
            this.mInputMethodManagerWrapper.restartInput((View)this.mContainerView);
        }
        this.mContainerViewInternals.super_onConfigurationChanged(newConfig);
        this.mContainerView.requestLayout();
        TraceEvent.end();
    }

    public void onSizeChanged(int wPix, int hPix, int owPix, int ohPix) {
        if (this.getViewportWidthPix() == wPix && this.getViewportHeightPix() == hPix) {
            return;
        }
        this.mViewportWidthPix = wPix;
        this.mViewportHeightPix = hPix;
        if (this.mNativeContentViewCore != 0L) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
        this.updateAfterSizeChanged();
    }

    public void onPhysicalBackingSizeChanged(int wPix, int hPix) {
        if (this.mPhysicalBackingWidthPix == wPix && this.mPhysicalBackingHeightPix == hPix) {
            return;
        }
        this.mPhysicalBackingWidthPix = wPix;
        this.mPhysicalBackingHeightPix = hPix;
        if (this.mNativeContentViewCore != 0L) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
    }

    public void onOverdrawBottomHeightChanged(int overdrawHeightPix) {
        if (this.mOverdrawBottomHeightPix == overdrawHeightPix) {
            return;
        }
        this.mOverdrawBottomHeightPix = overdrawHeightPix;
        if (this.mNativeContentViewCore != 0L) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
    }

    private void updateAfterSizeChanged() {
        this.mPopupZoomer.hide(false);
        if (!this.mFocusPreOSKViewportRect.isEmpty()) {
            Rect rect = new Rect();
            this.getContainerView().getWindowVisibleDisplayFrame(rect);
            if (!rect.equals((Object)this.mFocusPreOSKViewportRect)) {
                if (rect.width() == this.mFocusPreOSKViewportRect.width()) {
                    this.scrollFocusedEditableNodeIntoView();
                }
                this.cancelRequestToScrollFocusedEditableNodeIntoView();
            }
        }
    }

    private void cancelRequestToScrollFocusedEditableNodeIntoView() {
        this.mFocusPreOSKViewportRect.setEmpty();
    }

    private void scrollFocusedEditableNodeIntoView() {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeScrollFocusedEditableNodeIntoView(this.mNativeContentViewCore);
    }

    public void selectWordAroundCaret() {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSelectWordAroundCaret(this.mNativeContentViewCore);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (!hasWindowFocus) {
            this.resetGestureDetection();
        }
    }

    public void onFocusChanged(boolean gainFocus) {
        if (!gainFocus) {
            this.hideImeIfNeeded();
            this.cancelRequestToScrollFocusedEditableNodeIntoView();
        }
        if (this.mNativeContentViewCore != 0L) {
            this.nativeSetFocus(this.mNativeContentViewCore, gainFocus);
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mPopupZoomer.isShowing() && keyCode == 4) {
            this.mPopupZoomer.hide(true);
            return true;
        }
        return this.mContainerViewInternals.super_onKeyUp(keyCode, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        try {
            TraceEvent.begin();
            boolean bl = this.mContainerViewInternals.super_dispatchKeyEventPreIme(event);
            return bl;
        }
        finally {
            TraceEvent.end();
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (GamepadList.dispatchKeyEvent(event)) {
            return true;
        }
        if (this.getContentViewClient().shouldOverrideKeyEvent(event)) {
            return this.mContainerViewInternals.super_dispatchKeyEvent(event);
        }
        if (this.mImeAdapter.dispatchKeyEvent(event)) {
            return true;
        }
        return this.mContainerViewInternals.super_dispatchKeyEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onHoverEvent(MotionEvent event) {
        TraceEvent.begin("onHoverEvent");
        MotionEvent offset = this.createOffsetMotionEvent(event);
        try {
            if (this.mBrowserAccessibilityManager != null) {
                boolean bl = this.mBrowserAccessibilityManager.onHoverEvent(offset);
                return bl;
            }
            if (this.mTouchExplorationEnabled && offset.getAction() == 10) {
                boolean bl = true;
                return bl;
            }
            this.mContainerView.removeCallbacks(this.mFakeMouseMoveRunnable);
            if (this.mNativeContentViewCore != 0L) {
                this.nativeSendMouseMoveEvent(this.mNativeContentViewCore, offset.getEventTime(), offset.getX(), offset.getY());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            offset.recycle();
            TraceEvent.end("onHoverEvent");
        }
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (GamepadList.onGenericMotionEvent(event)) {
            return true;
        }
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    if (this.mNativeContentViewCore == 0L) {
                        return false;
                    }
                    this.nativeSendMouseWheelEvent(this.mNativeContentViewCore, event.getEventTime(), event.getX(), event.getY(), event.getAxisValue(9));
                    this.mContainerView.removeCallbacks(this.mFakeMouseMoveRunnable);
                    final MotionEvent eventFakeMouseMove = MotionEvent.obtain((MotionEvent)event);
                    this.mFakeMouseMoveRunnable = new Runnable(){

                        public void run() {
                            ContentViewCore.this.onHoverEvent(eventFakeMouseMove);
                            eventFakeMouseMove.recycle();
                        }
                    };
                    this.mContainerView.postDelayed(this.mFakeMouseMoveRunnable, 250L);
                    return true;
                }
            }
        }
        return this.mContainerViewInternals.super_onGenericMotionEvent(event);
    }

    public void setCurrentMotionEventOffsets(float dx, float dy) {
        this.mCurrentTouchOffsetX = dx;
        this.mCurrentTouchOffsetY = dy;
    }

    private MotionEvent createOffsetMotionEvent(MotionEvent src) {
        MotionEvent dst = MotionEvent.obtain((MotionEvent)src);
        dst.offsetLocation(this.mCurrentTouchOffsetX, this.mCurrentTouchOffsetY);
        return dst;
    }

    public void scrollBy(int xPix, int yPix) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeScrollBy(this.mNativeContentViewCore, SystemClock.uptimeMillis(), 0.0f, 0.0f, xPix, yPix);
        }
    }

    public void scrollTo(int xPix, int yPix) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        float xCurrentPix = this.mRenderCoordinates.getScrollXPix();
        float yCurrentPix = this.mRenderCoordinates.getScrollYPix();
        float dxPix = (float)xPix - xCurrentPix;
        float dyPix = (float)yPix - yCurrentPix;
        if (dxPix != 0.0f || dyPix != 0.0f) {
            long time = SystemClock.uptimeMillis();
            this.nativeScrollBegin(this.mNativeContentViewCore, time, xCurrentPix, yCurrentPix, -dxPix, -dyPix);
            this.nativeScrollBy(this.mNativeContentViewCore, time, xCurrentPix, yCurrentPix, dxPix, dyPix);
            this.nativeScrollEnd(this.mNativeContentViewCore, time);
        }
    }

    public int getNativeScrollXForTest() {
        return this.mRenderCoordinates.getScrollXPixInt();
    }

    public int getNativeScrollYForTest() {
        return this.mRenderCoordinates.getScrollYPixInt();
    }

    public int computeHorizontalScrollExtent() {
        return this.mRenderCoordinates.getLastFrameViewportWidthPixInt();
    }

    public int computeHorizontalScrollOffset() {
        return this.mRenderCoordinates.getScrollXPixInt();
    }

    public int computeHorizontalScrollRange() {
        return this.mRenderCoordinates.getContentWidthPixInt();
    }

    public int computeVerticalScrollExtent() {
        return this.mRenderCoordinates.getLastFrameViewportHeightPixInt();
    }

    public int computeVerticalScrollOffset() {
        return this.mRenderCoordinates.getScrollYPixInt();
    }

    public int computeVerticalScrollRange() {
        return this.mRenderCoordinates.getContentHeightPixInt();
    }

    public boolean awakenScrollBars(int startDelay, boolean invalidate) {
        if (this.mContainerView.getScrollBarStyle() == 0) {
            return false;
        }
        return this.mContainerViewInternals.super_awakenScrollBars(startDelay, invalidate);
    }

    private void updateForTapOrPress(int type, float xPix, float yPix) {
        if (type != 3 && type != 2 && type != 5 && type != 16) {
            return;
        }
        if (this.mContainerView.isFocusable() && this.mContainerView.isFocusableInTouchMode() && !this.mContainerView.isFocused()) {
            this.mContainerView.requestFocus();
        }
        if (!this.mPopupZoomer.isShowing()) {
            this.mPopupZoomer.setLastTouch(xPix, yPix);
        }
        this.mLastTapX = (int)xPix;
        this.mLastTapY = (int)yPix;
        if (type == 5 || type == 16) {
            this.getInsertionHandleController().allowAutomaticShowing();
            this.getSelectionHandleController().allowAutomaticShowing();
        } else if (this.mSelectionEditable) {
            this.getInsertionHandleController().allowAutomaticShowing();
        }
    }

    public int getLastTapX() {
        return this.mLastTapX;
    }

    public int getLastTapY() {
        return this.mLastTapY;
    }

    public void setZoomControlsDelegate(ZoomControlsDelegate zoomControlsDelegate) {
        this.mZoomControlsDelegate = zoomControlsDelegate;
    }

    public void updateMultiTouchZoomSupport(boolean supportsMultiTouchZoom) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSetMultiTouchZoomSupportEnabled(this.mNativeContentViewCore, supportsMultiTouchZoom);
    }

    public void updateDoubleTapSupport(boolean supportsDoubleTap) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSetDoubleTapSupportEnabled(this.mNativeContentViewCore, supportsDoubleTap);
    }

    public void selectPopupMenuItems(int[] indices) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeSelectPopupMenuItems(this.mNativeContentViewCore, indices);
        }
        this.mSelectPopup = null;
    }

    @VisibleForTesting
    void sendOrientationChangeEvent(int orientation) {
        if (this.mNativeContentViewCore == 0L) {
            return;
        }
        this.nativeSendOrientationChangeEvent(this.mNativeContentViewCore, orientation);
    }

    public void setDownloadDelegate(ContentViewDownloadDelegate delegate) {
        this.mDownloadDelegate = delegate;
    }

    ContentViewDownloadDelegate getDownloadDelegate() {
        return this.mDownloadDelegate;
    }

    private SelectionHandleController getSelectionHandleController() {
        if (this.mSelectionHandleController == null) {
            this.mSelectionHandleController = new SelectionHandleController((View)this.getContainerView(), this.mPositionObserver){

                public void selectBetweenCoordinates(int x1, int y1, int x2, int y2) {
                    if (ContentViewCore.this.mNativeContentViewCore != 0L && (x1 != x2 || y1 != y2)) {
                        ContentViewCore.this.nativeSelectBetweenCoordinates(ContentViewCore.this.mNativeContentViewCore, x1, (float)y1 - ContentViewCore.this.mRenderCoordinates.getContentOffsetYPix(), x2, (float)y2 - ContentViewCore.this.mRenderCoordinates.getContentOffsetYPix());
                    }
                }

                public void showHandles(int startDir, int endDir) {
                    boolean wasShowing = this.isShowing();
                    super.showHandles(startDir, endDir);
                    if (!wasShowing || ContentViewCore.this.mActionMode == null) {
                        ContentViewCore.this.showSelectActionBar();
                    }
                }
            };
            this.mSelectionHandleController.hideAndDisallowAutomaticShowing();
        }
        return this.mSelectionHandleController;
    }

    private InsertionHandleController getInsertionHandleController() {
        if (this.mInsertionHandleController == null) {
            this.mInsertionHandleController = new InsertionHandleController((View)this.getContainerView(), this.mPositionObserver){
                private static final int AVERAGE_LINE_HEIGHT = 14;

                public void setCursorPosition(int x, int y) {
                    if (ContentViewCore.this.mNativeContentViewCore != 0L) {
                        ContentViewCore.this.nativeMoveCaret(ContentViewCore.this.mNativeContentViewCore, x, (float)y - ContentViewCore.this.mRenderCoordinates.getContentOffsetYPix());
                    }
                }

                public void paste() {
                    ContentViewCore.this.mImeAdapter.paste();
                    ContentViewCore.this.hideHandles();
                }

                public int getLineHeight() {
                    return (int)Math.ceil(ContentViewCore.this.mRenderCoordinates.fromLocalCssToPix(14.0f));
                }

                public void showHandle() {
                    super.showHandle();
                }
            };
            this.mInsertionHandleController.hideAndDisallowAutomaticShowing();
        }
        return this.mInsertionHandleController;
    }

    @VisibleForTesting
    public InsertionHandleController getInsertionHandleControllerForTest() {
        return this.mInsertionHandleController;
    }

    @VisibleForTesting
    public SelectionHandleController getSelectionHandleControllerForTest() {
        return this.mSelectionHandleController;
    }

    private void updateHandleScreenPositions() {
        if (this.isSelectionHandleShowing()) {
            this.mSelectionHandleController.setStartHandlePosition(this.mStartHandlePoint.getXPix(), this.mStartHandlePoint.getYPix());
            this.mSelectionHandleController.setEndHandlePosition(this.mEndHandlePoint.getXPix(), this.mEndHandlePoint.getYPix());
        }
        if (this.isInsertionHandleShowing()) {
            this.mInsertionHandleController.setHandlePosition(this.mInsertionHandlePoint.getXPix(), this.mInsertionHandlePoint.getYPix());
        }
    }

    private void hideHandles() {
        if (this.mSelectionHandleController != null) {
            this.mSelectionHandleController.hideAndDisallowAutomaticShowing();
        }
        if (this.mInsertionHandleController != null) {
            this.mInsertionHandleController.hideAndDisallowAutomaticShowing();
        }
        this.mPositionObserver.removeListener(this.mPositionListener);
    }

    private void showSelectActionBar() {
        if (this.mActionMode != null) {
            this.mActionMode.invalidate();
            return;
        }
        SelectActionModeCallback.ActionHandler actionHandler = new SelectActionModeCallback.ActionHandler(){

            public void selectAll() {
                ContentViewCore.this.mImeAdapter.selectAll();
            }

            public void cut() {
                ContentViewCore.this.mImeAdapter.cut();
            }

            public void copy() {
                ContentViewCore.this.mImeAdapter.copy();
            }

            public void paste() {
                ContentViewCore.this.mImeAdapter.paste();
            }

            public void share() {
                String query = ContentViewCore.this.getSelectedText();
                if (TextUtils.isEmpty((CharSequence)query)) {
                    return;
                }
                Intent send = new Intent("android.intent.action.SEND");
                send.setType("text/plain");
                send.putExtra("android.intent.extra.TEXT", query);
                try {
                    Intent i = Intent.createChooser((Intent)send, (CharSequence)ContentViewCore.this.getContext().getString(R.string.actionbar_share));
                    i.setFlags(0x10000000);
                    ContentViewCore.this.getContext().startActivity(i);
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }

            public void search() {
                String query = ContentViewCore.this.getSelectedText();
                if (TextUtils.isEmpty((CharSequence)query)) {
                    return;
                }
                if (ContentViewCore.this.getContentViewClient().doesPerformWebSearch()) {
                    ContentViewCore.this.getContentViewClient().performWebSearch(query);
                    return;
                }
                Intent i = new Intent("android.intent.action.WEB_SEARCH");
                i.putExtra("new_search", true);
                i.putExtra("query", query);
                i.putExtra("com.android.browser.application_id", ContentViewCore.this.getContext().getPackageName());
                if (!(ContentViewCore.this.getContext() instanceof Activity)) {
                    i.addFlags(0x10000000);
                }
                try {
                    ContentViewCore.this.getContext().startActivity(i);
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }

            public boolean isSelectionPassword() {
                return ContentViewCore.this.mImeAdapter.isSelectionPassword();
            }

            public boolean isSelectionEditable() {
                return ContentViewCore.this.mSelectionEditable;
            }

            public void onDestroyActionMode() {
                ContentViewCore.this.mActionMode = null;
                if (ContentViewCore.this.mUnselectAllOnActionModeDismiss) {
                    ContentViewCore.this.mImeAdapter.unselect();
                }
                ContentViewCore.this.getContentViewClient().onContextualActionBarHidden();
            }

            public boolean isShareAvailable() {
                Intent intent = new Intent("android.intent.action.SEND");
                intent.setType("text/plain");
                return ContentViewCore.this.getContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
            }

            public boolean isWebSearchAvailable() {
                if (ContentViewCore.this.getContentViewClient().doesPerformWebSearch()) {
                    return true;
                }
                Intent intent = new Intent("android.intent.action.WEB_SEARCH");
                intent.putExtra("new_search", true);
                return ContentViewCore.this.getContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
            }
        };
        this.mActionMode = null;
        if (this.mContainerView.getParent() != null) {
            this.mActionMode = this.mContainerView.startActionMode(this.getContentViewClient().getSelectActionModeCallback(this.getContext(), actionHandler, this.nativeIsIncognito(this.mNativeContentViewCore)));
        }
        this.mUnselectAllOnActionModeDismiss = true;
        if (this.mActionMode == null) {
            this.mImeAdapter.unselect();
        } else {
            this.getContentViewClient().onContextualActionBarShown();
        }
    }

    public boolean getUseDesktopUserAgent() {
        if (this.mNativeContentViewCore != 0L) {
            return this.nativeGetUseDesktopUserAgent(this.mNativeContentViewCore);
        }
        return false;
    }

    public void setUseDesktopUserAgent(boolean override, boolean reloadOnChange) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeSetUseDesktopUserAgent(this.mNativeContentViewCore, override, reloadOnChange);
        }
    }

    public void clearSslPreferences() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeClearSslPreferences(this.mNativeContentViewCore);
        }
    }

    private boolean isSelectionHandleShowing() {
        return this.mSelectionHandleController != null && this.mSelectionHandleController.isShowing();
    }

    private boolean isInsertionHandleShowing() {
        return this.mInsertionHandleController != null && this.mInsertionHandleController.isShowing();
    }

    private void temporarilyHideTextHandles() {
        if (this.isSelectionHandleShowing() && !this.mSelectionHandleController.isDragging()) {
            this.mSelectionHandleController.setHandleVisibility(4);
        }
        if (this.isInsertionHandleShowing() && !this.mInsertionHandleController.isDragging()) {
            this.mInsertionHandleController.setHandleVisibility(4);
        }
        this.scheduleTextHandleFadeIn();
    }

    private boolean allowTextHandleFadeIn() {
        if (this.mTouchScrollInProgress) {
            return false;
        }
        return !this.mPopupZoomer.isShowing();
    }

    private void scheduleTextHandleFadeIn() {
        if (!this.isInsertionHandleShowing() && !this.isSelectionHandleShowing()) {
            return;
        }
        if (this.mDeferredHandleFadeInRunnable == null) {
            this.mDeferredHandleFadeInRunnable = new Runnable(){

                public void run() {
                    if (!ContentViewCore.this.allowTextHandleFadeIn()) {
                        ContentViewCore.this.scheduleTextHandleFadeIn();
                    } else {
                        if (ContentViewCore.this.isSelectionHandleShowing()) {
                            ContentViewCore.this.mSelectionHandleController.beginHandleFadeIn();
                        }
                        if (ContentViewCore.this.isInsertionHandleShowing()) {
                            ContentViewCore.this.mInsertionHandleController.beginHandleFadeIn();
                        }
                    }
                }
            };
        }
        this.mContainerView.removeCallbacks(this.mDeferredHandleFadeInRunnable);
        this.mContainerView.postDelayed(this.mDeferredHandleFadeInRunnable, 300L);
    }

    public void showImeIfNeeded() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeShowImeIfNeeded(this.mNativeContentViewCore);
        }
    }

    public void hideImeIfNeeded() {
        if (this.mInputMethodManagerWrapper.isActive((View)this.mContainerView)) {
            this.mInputMethodManagerWrapper.hideSoftInputFromWindow(this.mContainerView.getWindowToken(), 0, null);
        }
        this.getContentViewClient().onImeStateChangeRequested(false);
    }

    @CalledByNative
    private void updateFrameInfo(float scrollOffsetX, float scrollOffsetY, float pageScaleFactor, float minPageScaleFactor, float maxPageScaleFactor, float contentWidth, float contentHeight, float viewportWidth, float viewportHeight, float controlsOffsetYCss, float contentOffsetYCss, float overdrawBottomHeightCss) {
        TraceEvent.instant("ContentViewCore:updateFrameInfo");
        float deviceScale = this.mRenderCoordinates.getDeviceScaleFactor();
        contentWidth = Math.max(contentWidth, (float)this.mViewportWidthPix / (deviceScale * pageScaleFactor));
        contentHeight = Math.max(contentHeight, (float)this.mViewportHeightPix / (deviceScale * pageScaleFactor));
        float contentOffsetYPix = this.mRenderCoordinates.fromDipToPix(contentOffsetYCss);
        boolean contentSizeChanged = contentWidth != this.mRenderCoordinates.getContentWidthCss() || contentHeight != this.mRenderCoordinates.getContentHeightCss();
        boolean scaleLimitsChanged = minPageScaleFactor != this.mRenderCoordinates.getMinPageScaleFactor() || maxPageScaleFactor != this.mRenderCoordinates.getMaxPageScaleFactor();
        boolean pageScaleChanged = pageScaleFactor != this.mRenderCoordinates.getPageScaleFactor();
        boolean scrollChanged = pageScaleChanged || scrollOffsetX != this.mRenderCoordinates.getScrollX() || scrollOffsetY != this.mRenderCoordinates.getScrollY();
        boolean contentOffsetChanged = contentOffsetYPix != this.mRenderCoordinates.getContentOffsetYPix();
        boolean needHidePopupZoomer = contentSizeChanged || scrollChanged;
        boolean needUpdateZoomControls = scaleLimitsChanged || scrollChanged;
        boolean needTemporarilyHideHandles = scrollChanged;
        if (needHidePopupZoomer) {
            this.mPopupZoomer.hide(true);
        }
        if (scrollChanged) {
            this.mContainerViewInternals.onScrollChanged((int)this.mRenderCoordinates.fromLocalCssToPix(scrollOffsetX), (int)this.mRenderCoordinates.fromLocalCssToPix(scrollOffsetY), (int)this.mRenderCoordinates.getScrollXPix(), (int)this.mRenderCoordinates.getScrollYPix());
        }
        this.mRenderCoordinates.updateFrameInfo(scrollOffsetX, scrollOffsetY, contentWidth, contentHeight, viewportWidth, viewportHeight, pageScaleFactor, minPageScaleFactor, maxPageScaleFactor, contentOffsetYPix);
        if (scrollChanged || contentOffsetChanged) {
            this.mGestureStateListenersIterator.rewind();
            while (this.mGestureStateListenersIterator.hasNext()) {
                ((GestureStateListener)this.mGestureStateListenersIterator.next()).onScrollOffsetOrExtentChanged(this.computeVerticalScrollOffset(), this.computeVerticalScrollExtent());
            }
        }
        if (needTemporarilyHideHandles) {
            this.temporarilyHideTextHandles();
        }
        if (needUpdateZoomControls) {
            this.mZoomControlsDelegate.updateZoomControls();
        }
        if (contentOffsetChanged) {
            this.updateHandleScreenPositions();
        }
        float controlsOffsetPix = controlsOffsetYCss * deviceScale;
        float overdrawBottomHeightPix = overdrawBottomHeightCss * deviceScale;
        this.getContentViewClient().onOffsetsForFullscreenChanged(controlsOffsetPix, contentOffsetYPix, overdrawBottomHeightPix);
        if (this.mBrowserAccessibilityManager != null) {
            this.mBrowserAccessibilityManager.notifyFrameInfoInitialized();
        }
    }

    @CalledByNative
    private void updateImeAdapter(long nativeImeAdapterAndroid, int textInputType, String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd, boolean showImeIfNeeded, boolean isNonImeChange) {
        TraceEvent.begin();
        this.mSelectionEditable = textInputType != ImeAdapter.getTextInputTypeNone();
        this.mImeAdapter.updateKeyboardVisibility(nativeImeAdapterAndroid, textInputType, showImeIfNeeded);
        if (this.mInputConnection != null) {
            this.mInputConnection.updateState(text, selectionStart, selectionEnd, compositionStart, compositionEnd, isNonImeChange);
        }
        if (this.mActionMode != null) {
            this.mActionMode.invalidate();
        }
        TraceEvent.end();
    }

    @CalledByNative
    private void setTitle(String title) {
        this.getContentViewClient().onUpdateTitle(title);
    }

    @CalledByNative
    private void showSelectPopup(Rect bounds, String[] items, int[] enabled, boolean multiple, int[] selectedIndices) {
        if (this.mContainerView.getParent() == null || this.mContainerView.getVisibility() != 0) {
            this.selectPopupMenuItems(null);
            return;
        }
        assert (items.length == enabled.length);
        ArrayList<SelectPopupItem> popupItems = new ArrayList<SelectPopupItem>();
        for (int i = 0; i < items.length; ++i) {
            popupItems.add(new SelectPopupItem(items[i], enabled[i]));
        }
        this.hidePopups();
        this.mSelectPopup = DeviceUtils.isTablet(this.mContext) && !multiple ? new SelectPopupDropdown(this, popupItems, bounds, selectedIndices) : new SelectPopupDialog(this, popupItems, multiple, selectedIndices);
        this.mSelectPopup.show();
    }

    @CalledByNative
    private void hideSelectPopup() {
        if (this.mSelectPopup != null) {
            this.mSelectPopup.hide();
        }
    }

    public SelectPopup getSelectPopupForTest() {
        return this.mSelectPopup;
    }

    @CalledByNative
    private void showDisambiguationPopup(Rect targetRect, Bitmap zoomedBitmap) {
        this.mPopupZoomer.setBitmap(zoomedBitmap);
        this.mPopupZoomer.show(targetRect);
        this.temporarilyHideTextHandles();
    }

    @CalledByNative
    private TouchEventSynthesizer createTouchEventSynthesizer() {
        return new TouchEventSynthesizer(this);
    }

    @CalledByNative
    private void onSelectionChanged(String text) {
        this.mLastSelectedText = text;
        this.getContentViewClient().onSelectionChanged(text);
    }

    @CalledByNative
    private void showSelectionHandlesAutomatically() {
        this.getSelectionHandleController().allowAutomaticShowing();
    }

    @CalledByNative
    private void onSelectionBoundsChanged(Rect anchorRectDip, int anchorDir, Rect focusRectDip, int focusDir, boolean isAnchorFirst) {
        int x1 = anchorRectDip.left;
        int y1 = anchorRectDip.bottom;
        int x2 = focusRectDip.left;
        int y2 = focusRectDip.bottom;
        if (x1 != x2 || y1 != y2 || this.mSelectionHandleController != null && this.mSelectionHandleController.isDragging()) {
            if (this.mInsertionHandleController != null) {
                this.mInsertionHandleController.hide();
            }
            if (isAnchorFirst) {
                this.mStartHandlePoint.setLocalDip(x1, y1);
                this.mEndHandlePoint.setLocalDip(x2, y2);
            } else {
                this.mStartHandlePoint.setLocalDip(x2, y2);
                this.mEndHandlePoint.setLocalDip(x1, y1);
            }
            boolean wereSelectionHandlesShowing = this.getSelectionHandleController().isShowing();
            this.getSelectionHandleController().onSelectionChanged(anchorDir, focusDir);
            this.updateHandleScreenPositions();
            this.mHasSelection = true;
            if (!wereSelectionHandlesShowing && this.getSelectionHandleController().isShowing()) {
                this.mContainerView.performHapticFeedback(0);
            }
        } else {
            this.mUnselectAllOnActionModeDismiss = false;
            this.hideSelectActionBar();
            if (x1 != 0 && y1 != 0 && this.mSelectionEditable) {
                if (this.mSelectionHandleController != null) {
                    this.mSelectionHandleController.hide();
                }
                this.mInsertionHandlePoint.setLocalDip(x1, y1);
                this.getInsertionHandleController().onCursorPositionChanged();
                this.updateHandleScreenPositions();
                if (this.mInputMethodManagerWrapper.isWatchingCursor((View)this.mContainerView)) {
                    int xPix = (int)this.mInsertionHandlePoint.getXPix();
                    int yPix = (int)this.mInsertionHandlePoint.getYPix();
                    this.mInputMethodManagerWrapper.updateCursor((View)this.mContainerView, xPix, yPix, xPix, yPix);
                }
            } else {
                if (this.mSelectionHandleController != null) {
                    this.mSelectionHandleController.hideAndDisallowAutomaticShowing();
                }
                if (this.mInsertionHandleController != null) {
                    this.mInsertionHandleController.hideAndDisallowAutomaticShowing();
                }
            }
            this.mHasSelection = false;
        }
        if (this.isSelectionHandleShowing() || this.isInsertionHandleShowing()) {
            this.mPositionObserver.addListener(this.mPositionListener);
        }
    }

    @CalledByNative
    private static void onEvaluateJavaScriptResult(String jsonResult, JavaScriptCallback callback) {
        callback.handleJavaScriptResult(jsonResult);
    }

    @CalledByNative
    private void showPastePopup(int xDip, int yDip) {
        this.mInsertionHandlePoint.setLocalDip(xDip, yDip);
        this.getInsertionHandleController().showHandle();
        this.updateHandleScreenPositions();
        this.getInsertionHandleController().showHandleWithPastePopup();
    }

    @CalledByNative
    private void onRenderProcessChange() {
        this.attachImeAdapter();
    }

    public void attachImeAdapter() {
        if (this.mImeAdapter != null && this.mNativeContentViewCore != 0L) {
            this.mImeAdapter.attach(this.nativeGetNativeImeAdapter(this.mNativeContentViewCore));
        }
    }

    @CalledByNative
    public boolean hasFocus() {
        return this.mContainerView.hasFocus();
    }

    public boolean canZoomIn() {
        float zoomInExtent = this.mRenderCoordinates.getMaxPageScaleFactor() - this.mRenderCoordinates.getPageScaleFactor();
        return zoomInExtent > 0.007f;
    }

    public boolean canZoomOut() {
        float zoomOutExtent = this.mRenderCoordinates.getPageScaleFactor() - this.mRenderCoordinates.getMinPageScaleFactor();
        return zoomOutExtent > 0.007f;
    }

    public boolean zoomIn() {
        if (!this.canZoomIn()) {
            return false;
        }
        return this.pinchByDelta(1.25f);
    }

    public boolean zoomOut() {
        if (!this.canZoomOut()) {
            return false;
        }
        return this.pinchByDelta(0.8f);
    }

    public boolean zoomReset() {
        if (!this.canZoomOut()) {
            return false;
        }
        return this.pinchByDelta(this.mRenderCoordinates.getMinPageScaleFactor() / this.mRenderCoordinates.getPageScaleFactor());
    }

    public boolean pinchByDelta(float delta) {
        if (this.mNativeContentViewCore == 0L) {
            return false;
        }
        long timeMs = SystemClock.uptimeMillis();
        int xPix = this.getViewportWidthPix() / 2;
        int yPix = this.getViewportHeightPix() / 2;
        this.nativePinchBegin(this.mNativeContentViewCore, timeMs, xPix, yPix);
        this.nativePinchBy(this.mNativeContentViewCore, timeMs, xPix, yPix, delta);
        this.nativePinchEnd(this.mNativeContentViewCore, timeMs);
        return true;
    }

    public void invokeZoomPicker() {
        this.mZoomControlsDelegate.invokeZoomPicker();
    }

    public void setAllowJavascriptInterfacesInspection(boolean allow) {
        this.nativeSetAllowJavascriptInterfacesInspection(this.mNativeContentViewCore, allow);
    }

    public void addJavascriptInterface(Object object, String name) {
        this.addPossiblyUnsafeJavascriptInterface(object, name, JavascriptInterface.class);
    }

    public void addPossiblyUnsafeJavascriptInterface(Object object, String name, Class<? extends Annotation> requiredAnnotation) {
        if (this.mNativeContentViewCore != 0L && object != null) {
            this.mJavaScriptInterfaces.put(name, object);
            this.nativeAddJavascriptInterface(this.mNativeContentViewCore, object, name, requiredAnnotation);
        }
    }

    public void removeJavascriptInterface(String name) {
        this.mJavaScriptInterfaces.remove(name);
        if (this.mNativeContentViewCore != 0L) {
            this.nativeRemoveJavascriptInterface(this.mNativeContentViewCore, name);
        }
    }

    public float getScale() {
        return this.mRenderCoordinates.getPageScaleFactor();
    }

    public boolean isReady() {
        if (this.mNativeContentViewCore == 0L) {
            return false;
        }
        return this.nativeIsRenderWidgetHostViewReady(this.mNativeContentViewCore);
    }

    @CalledByNative
    private void startContentIntent(String contentUrl) {
        this.getContentViewClient().onStartContentIntent(this.getContext(), contentUrl);
    }

    public void onAccessibilityStateChanged(boolean enabled) {
        this.setAccessibilityState(enabled);
    }

    public boolean supportsAccessibilityAction(int action) {
        return this.mAccessibilityInjector.supportsAccessibilityAction(action);
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (this.mAccessibilityInjector.supportsAccessibilityAction(action)) {
            return this.mAccessibilityInjector.performAccessibilityAction(action, arguments);
        }
        return false;
    }

    public void setBrowserAccessibilityManager(BrowserAccessibilityManager manager) {
        this.mBrowserAccessibilityManager = manager;
    }

    public BrowserAccessibilityManager getBrowserAccessibilityManager() {
        return this.mBrowserAccessibilityManager;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mBrowserAccessibilityManager != null) {
            return this.mBrowserAccessibilityManager.getAccessibilityNodeProvider();
        }
        if (this.mNativeAccessibilityAllowed && !this.mNativeAccessibilityEnabled && this.mNativeContentViewCore != 0L && Build.VERSION.SDK_INT >= 16) {
            this.mNativeAccessibilityEnabled = true;
            this.nativeSetAccessibilityEnabled(this.mNativeContentViewCore, true);
        }
        return null;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        this.mAccessibilityInjector.onInitializeAccessibilityNodeInfo(info);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName((CharSequence)this.getClass().getName());
        event.setScrollX(this.mRenderCoordinates.getScrollXPixInt());
        event.setScrollY(this.mRenderCoordinates.getScrollYPixInt());
        int maxScrollXPix = Math.max(0, this.mRenderCoordinates.getMaxHorizontalScrollPixInt());
        int maxScrollYPix = Math.max(0, this.mRenderCoordinates.getMaxVerticalScrollPixInt());
        event.setScrollable(maxScrollXPix > 0 || maxScrollYPix > 0);
        int SDK_VERSION_REQUIRED_TO_SET_SCROLL = 15;
        if (Build.VERSION.SDK_INT >= 15) {
            event.setMaxScrollX(maxScrollXPix);
            event.setMaxScrollY(maxScrollYPix);
        }
    }

    public boolean isDeviceAccessibilityScriptInjectionEnabled() {
        try {
            if (Build.VERSION.SDK_INT >= 16 && !CommandLine.getInstance().hasSwitch("enable-accessibility-script-injection")) {
                return false;
            }
            if (!this.mContentSettings.getJavaScriptEnabled()) {
                return false;
            }
            int result = this.getContext().checkCallingOrSelfPermission("android.permission.INTERNET");
            if (result != 0) {
                return false;
            }
            Field field = Settings.Secure.class.getField("ACCESSIBILITY_SCRIPT_INJECTION");
            field.setAccessible(true);
            String accessibilityScriptInjection = (String)field.get(null);
            ContentResolver contentResolver = this.getContext().getContentResolver();
            if (this.mAccessibilityScriptInjectionObserver == null) {
                ContentObserver contentObserver = new ContentObserver(new Handler()){

                    public void onChange(boolean selfChange, Uri uri) {
                        ContentViewCore.this.setAccessibilityState(ContentViewCore.this.mAccessibilityManager.isEnabled());
                    }
                };
                contentResolver.registerContentObserver(Settings.Secure.getUriFor((String)accessibilityScriptInjection), false, contentObserver);
                this.mAccessibilityScriptInjectionObserver = contentObserver;
            }
            return Settings.Secure.getInt((ContentResolver)contentResolver, (String)accessibilityScriptInjection, (int)0) == 1;
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    public boolean isInjectingAccessibilityScript() {
        return this.mAccessibilityInjector.accessibilityIsAvailable();
    }

    public boolean isTouchExplorationEnabled() {
        return this.mTouchExplorationEnabled;
    }

    public void setAccessibilityState(boolean state) {
        if (!state) {
            this.setInjectedAccessibility(false);
            this.mNativeAccessibilityAllowed = false;
            this.mTouchExplorationEnabled = false;
        } else {
            boolean useScriptInjection = this.isDeviceAccessibilityScriptInjectionEnabled();
            this.setInjectedAccessibility(useScriptInjection);
            this.mNativeAccessibilityAllowed = !useScriptInjection;
            this.mTouchExplorationEnabled = this.mAccessibilityManager.isTouchExplorationEnabled();
        }
    }

    public void setInjectedAccessibility(boolean enabled) {
        this.mAccessibilityInjector.addOrRemoveAccessibilityApisIfNecessary();
        this.mAccessibilityInjector.setScriptEnabled(enabled);
    }

    public void stopCurrentAccessibilityNotifications() {
        this.mAccessibilityInjector.onPageLostFocus();
    }

    public void exitFullscreen() {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeExitFullscreen(this.mNativeContentViewCore);
        }
    }

    public void updateTopControlsState(boolean enableHiding, boolean enableShowing, boolean animate) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeUpdateTopControlsState(this.mNativeContentViewCore, enableHiding, enableShowing, animate);
        }
    }

    @CalledByNative
    private void addToNavigationHistory(Object history, int index, String url, String virtualUrl, String originalUrl, String title, Bitmap favicon) {
        NavigationEntry entry = new NavigationEntry(index, url, virtualUrl, originalUrl, title, favicon);
        ((NavigationHistory)history).addEntry(entry);
    }

    public NavigationHistory getNavigationHistory() {
        NavigationHistory history = new NavigationHistory();
        if (this.mNativeContentViewCore != 0L) {
            int currentIndex = this.nativeGetNavigationHistory(this.mNativeContentViewCore, history);
            history.setCurrentEntryIndex(currentIndex);
        }
        return history;
    }

    @Override
    public NavigationHistory getDirectedNavigationHistory(boolean isForward, int itemLimit) {
        NavigationHistory history = new NavigationHistory();
        if (this.mNativeContentViewCore != 0L) {
            this.nativeGetDirectedNavigationHistory(this.mNativeContentViewCore, history, isForward, itemLimit);
        }
        return history;
    }

    public String getOriginalUrlForActiveNavigationEntry() {
        if (this.mNativeContentViewCore != 0L) {
            return this.nativeGetOriginalUrlForActiveNavigationEntry(this.mNativeContentViewCore);
        }
        return "";
    }

    public RenderCoordinates getRenderCoordinates() {
        return this.mRenderCoordinates;
    }

    @CalledByNative
    private static Rect createRect(int x, int y, int right, int bottom) {
        return new Rect(x, y, right, bottom);
    }

    public void extractSmartClipData(int x, int y, int width, int height) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeExtractSmartClipData(this.mNativeContentViewCore, x += this.mSmartClipOffsetX, y += this.mSmartClipOffsetY, width, height);
        }
    }

    public void setSmartClipOffsets(int offsetX, int offsetY) {
        this.mSmartClipOffsetX = offsetX;
        this.mSmartClipOffsetY = offsetY;
    }

    @CalledByNative
    private void onSmartClipDataExtracted(String text, String html, Rect clipRect) {
        if (this.mSmartClipDataListener != null) {
            this.mSmartClipDataListener.onSmartClipDataExtracted(text, html, clipRect);
        }
    }

    public void setSmartClipDataListener(SmartClipDataListener listener) {
        this.mSmartClipDataListener = listener;
    }

    public void setBackgroundOpaque(boolean opaque) {
        if (this.mNativeContentViewCore != 0L) {
            this.nativeSetBackgroundOpaque(this.mNativeContentViewCore, opaque);
        }
    }

    private boolean offerLongPressToEmbedder() {
        return this.mContainerView.performLongClick();
    }

    private void resetScrollInProgress() {
        if (!this.isScrollInProgress()) {
            return;
        }
        boolean touchScrollInProgress = this.mTouchScrollInProgress;
        int potentiallyActiveFlingCount = this.mPotentiallyActiveFlingCount;
        this.mTouchScrollInProgress = false;
        this.mPotentiallyActiveFlingCount = 0;
        if (touchScrollInProgress) {
            this.updateGestureStateListener(8);
        }
        if (potentiallyActiveFlingCount > 0) {
            this.updateGestureStateListener(11);
        }
    }

    private native long nativeInit(long var1, long var3, long var5, HashSet<Object> var7);

    @CalledByNative
    private ContentVideoViewClient getContentVideoViewClient() {
        return this.getContentViewClient().getContentVideoViewClient();
    }

    @CalledByNative
    private boolean shouldBlockMediaRequest(String url) {
        return this.getContentViewClient().shouldBlockMediaRequest(url);
    }

    @CalledByNative
    private void onNativeFlingStopped() {
        this.mTouchScrollInProgress = false;
        if (this.mPotentiallyActiveFlingCount <= 0) {
            return;
        }
        --this.mPotentiallyActiveFlingCount;
        this.updateGestureStateListener(11);
    }

    @Override
    public void onScreenOrientationChanged(int orientation) {
        this.sendOrientationChangeEvent(orientation);
    }

    private native WebContents nativeGetWebContentsAndroid(long var1);

    private native void nativeOnJavaContentViewCoreDestroyed(long var1);

    private native void nativeLoadUrl(long var1, String var3, int var4, int var5, String var6, int var7, int var8, String var9, byte[] var10, String var11, String var12, boolean var13, boolean var14);

    private native String nativeGetURL(long var1);

    private native void nativeShowInterstitialPage(long var1, String var3, long var4);

    private native boolean nativeIsShowingInterstitialPage(long var1);

    private native boolean nativeIsIncognito(long var1);

    private native void nativeSetFocus(long var1, boolean var3);

    private native void nativeSendOrientationChangeEvent(long var1, int var3);

    private native boolean nativeOnTouchEvent(long var1, MotionEvent var3, long var4, int var6, int var7, int var8, int var9, float var10, float var11, float var12, float var13, int var14, int var15, float var16, float var17, float var18, float var19, int var20, int var21, int var22);

    private native int nativeSendMouseMoveEvent(long var1, long var3, float var5, float var6);

    private native int nativeSendMouseWheelEvent(long var1, long var3, float var5, float var6, float var7);

    private native void nativeScrollBegin(long var1, long var3, float var5, float var6, float var7, float var8);

    private native void nativeScrollEnd(long var1, long var3);

    private native void nativeScrollBy(long var1, long var3, float var5, float var6, float var7, float var8);

    private native void nativeFlingStart(long var1, long var3, float var5, float var6, float var7, float var8);

    private native void nativeFlingCancel(long var1, long var3);

    private native void nativeSingleTap(long var1, long var3, float var5, float var6);

    private native void nativeDoubleTap(long var1, long var3, float var5, float var6);

    private native void nativeLongPress(long var1, long var3, float var5, float var6);

    private native void nativePinchBegin(long var1, long var3, float var5, float var6);

    private native void nativePinchEnd(long var1, long var3);

    private native void nativePinchBy(long var1, long var3, float var5, float var6, float var7);

    private native void nativeSelectBetweenCoordinates(long var1, float var3, float var4, float var5, float var6);

    private native void nativeMoveCaret(long var1, float var3, float var4);

    private native void nativeResetGestureDetection(long var1);

    private native void nativeSetDoubleTapSupportEnabled(long var1, boolean var3);

    private native void nativeSetMultiTouchZoomSupportEnabled(long var1, boolean var3);

    private native void nativeLoadIfNecessary(long var1);

    private native void nativeRequestRestoreLoad(long var1);

    private native void nativeReload(long var1, boolean var3);

    private native void nativeReloadIgnoringCache(long var1, boolean var3);

    private native void nativeCancelPendingReload(long var1);

    private native void nativeContinuePendingReload(long var1);

    private native void nativeSelectPopupMenuItems(long var1, int[] var3);

    private native void nativeScrollFocusedEditableNodeIntoView(long var1);

    private native void nativeSelectWordAroundCaret(long var1);

    private native void nativeClearHistory(long var1);

    private native void nativeAddStyleSheetByURL(long var1, String var3);

    private native void nativeEvaluateJavaScript(long var1, String var3, JavaScriptCallback var4, boolean var5);

    private native long nativeGetNativeImeAdapter(long var1);

    private native int nativeGetCurrentRenderProcessId(long var1);

    private native int nativeGetBackgroundColor(long var1);

    private native void nativeOnShow(long var1);

    private native void nativeOnHide(long var1);

    private native void nativeSetUseDesktopUserAgent(long var1, boolean var3, boolean var4);

    private native boolean nativeGetUseDesktopUserAgent(long var1);

    private native void nativeClearSslPreferences(long var1);

    private native void nativeSetAllowJavascriptInterfacesInspection(long var1, boolean var3);

    private native void nativeAddJavascriptInterface(long var1, Object var3, String var4, Class var5);

    private native void nativeRemoveJavascriptInterface(long var1, String var3);

    private native int nativeGetNavigationHistory(long var1, Object var3);

    private native void nativeGetDirectedNavigationHistory(long var1, Object var3, boolean var4, int var5);

    private native String nativeGetOriginalUrlForActiveNavigationEntry(long var1);

    private native void nativeWasResized(long var1);

    private native boolean nativeIsRenderWidgetHostViewReady(long var1);

    private native void nativeExitFullscreen(long var1);

    private native void nativeUpdateTopControlsState(long var1, boolean var3, boolean var4, boolean var5);

    private native void nativeShowImeIfNeeded(long var1);

    private native void nativeSetAccessibilityEnabled(long var1, boolean var3);

    private native void nativeExtractSmartClipData(long var1, int var3, int var4, int var5, int var6);

    private native void nativeSetBackgroundOpaque(long var1, boolean var3);

    public static interface JavaScriptCallback {
        public void handleJavaScriptResult(String var1);
    }

    public static interface SmartClipDataListener {
        public void onSmartClipDataExtracted(String var1, String var2, Rect var3);
    }

    public static interface ZoomControlsDelegate {
        public void invokeZoomPicker();

        public void dismissZoomPicker();

        public void updateZoomControls();
    }

    public static interface InternalAccessDelegate {
        public boolean drawChild(Canvas var1, View var2, long var3);

        public boolean super_onKeyUp(int var1, KeyEvent var2);

        public boolean super_dispatchKeyEventPreIme(KeyEvent var1);

        public boolean super_dispatchKeyEvent(KeyEvent var1);

        public boolean super_onGenericMotionEvent(MotionEvent var1);

        public void super_onConfigurationChanged(Configuration var1);

        public void onScrollChanged(int var1, int var2, int var3, int var4);

        public boolean awakenScrollBars();

        public boolean super_awakenScrollBars(int var1, boolean var2);
    }
}

