/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.MediaController;
import org.chromium.content.browser.ContentVideoView;
import org.chromium.content.browser.ContentVideoViewClient;

public class ContentVideoViewLegacy
extends ContentVideoView {
    private FullScreenMediaController mMediaController;
    private boolean mCanPause;
    private boolean mCanSeekBackward;
    private boolean mCanSeekForward;
    private int mCurrentBufferPercentage;
    private MediaControlsVisibilityListener mListener;

    ContentVideoViewLegacy(Context context, long nativeContentVideoView, ContentVideoViewClient client) {
        super(context, nativeContentVideoView, client);
        this.setBackgroundColor(-16777216);
        this.mCurrentBufferPercentage = 0;
    }

    protected void showContentVideoView() {
        SurfaceView surfaceView = this.getSurfaceView();
        surfaceView.setZOrderOnTop(true);
        surfaceView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                boolean isKeyCodeSupported;
                boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 164 && keyCode != 5 && keyCode != 82 && keyCode != 84 && keyCode != 6;
                if (ContentVideoViewLegacy.this.isInPlaybackState() && isKeyCodeSupported && ContentVideoViewLegacy.this.mMediaController != null) {
                    if (keyCode == 79 || keyCode == 85) {
                        if (ContentVideoViewLegacy.this.isPlaying()) {
                            ContentVideoViewLegacy.this.pause();
                            ContentVideoViewLegacy.this.mMediaController.show();
                        } else {
                            ContentVideoViewLegacy.this.start();
                            ContentVideoViewLegacy.this.mMediaController.hide();
                        }
                        return true;
                    }
                    if (keyCode == 126) {
                        if (!ContentVideoViewLegacy.this.isPlaying()) {
                            ContentVideoViewLegacy.this.start();
                            ContentVideoViewLegacy.this.mMediaController.hide();
                        }
                        return true;
                    }
                    if (keyCode == 86 || keyCode == 127) {
                        if (ContentVideoViewLegacy.this.isPlaying()) {
                            ContentVideoViewLegacy.this.pause();
                            ContentVideoViewLegacy.this.mMediaController.show();
                        }
                        return true;
                    }
                    ContentVideoViewLegacy.this.toggleMediaControlsVisiblity();
                } else {
                    if (keyCode == 4 && event.getAction() == 1) {
                        ContentVideoViewLegacy.this.exitFullscreen(false);
                        return true;
                    }
                    if (keyCode == 82 || keyCode == 84) {
                        return true;
                    }
                }
                return false;
            }
        });
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (ContentVideoViewLegacy.this.isInPlaybackState() && ContentVideoViewLegacy.this.mMediaController != null && event.getAction() == 0) {
                    ContentVideoViewLegacy.this.toggleMediaControlsVisiblity();
                }
                return true;
            }
        });
        surfaceView.setFocusable(true);
        surfaceView.setFocusableInTouchMode(true);
        surfaceView.requestFocus();
        super.showContentVideoView();
    }

    public void onMediaPlayerError(int errorType) {
        super.onMediaPlayerError(errorType);
        if (errorType == 3) {
            return;
        }
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
    }

    protected void onBufferingUpdate(int percent) {
        super.onBufferingUpdate(percent);
        this.mCurrentBufferPercentage = percent;
    }

    protected void onUpdateMediaMetadata(int videoWidth, int videoHeight, int duration, boolean canPause, boolean canSeekBack, boolean canSeekForward) {
        super.onUpdateMediaMetadata(videoWidth, videoHeight, duration, canPause, canSeekBack, canSeekForward);
        this.mCanPause = canPause;
        this.mCanSeekBackward = canSeekBack;
        this.mCanSeekForward = canSeekForward;
        if (this.mMediaController == null) {
            return;
        }
        this.mMediaController.setEnabled(true);
        if (this.isPlaying()) {
            this.mMediaController.show();
        } else {
            this.mMediaController.show(0);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        super.surfaceChanged(holder, format, width, height);
        SurfaceView surfaceView = this.getSurfaceView();
        surfaceView.setFocusable(true);
        surfaceView.setFocusableInTouchMode(true);
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.mMediaController.show();
        }
    }

    protected void openVideo() {
        super.openVideo();
        this.mCurrentBufferPercentage = 0;
        if (this.mMediaController != null) {
            return;
        }
        this.mMediaController = new FullScreenMediaController(this.getContext(), (View)this, this.mListener);
        this.mMediaController.setMediaPlayer(new MediaController.MediaPlayerControl(){

            public boolean canPause() {
                return ContentVideoViewLegacy.this.mCanPause;
            }

            public boolean canSeekBackward() {
                return ContentVideoViewLegacy.this.mCanSeekBackward;
            }

            public boolean canSeekForward() {
                return ContentVideoViewLegacy.this.mCanSeekForward;
            }

            public int getAudioSessionId() {
                return 0;
            }

            public int getBufferPercentage() {
                return ContentVideoViewLegacy.this.mCurrentBufferPercentage;
            }

            public int getCurrentPosition() {
                return ContentVideoViewLegacy.this.getCurrentPosition();
            }

            public int getDuration() {
                return ContentVideoViewLegacy.this.getDuration();
            }

            public boolean isPlaying() {
                return ContentVideoViewLegacy.this.isPlaying();
            }

            public void pause() {
                ContentVideoViewLegacy.this.pause();
            }

            public void seekTo(int pos) {
                ContentVideoViewLegacy.this.seekTo(pos);
            }

            public void start() {
                ContentVideoViewLegacy.this.start();
            }
        });
        this.mMediaController.setAnchorView((View)this.getSurfaceView());
        this.mMediaController.setEnabled(false);
    }

    protected void onCompletion() {
        super.onCompletion();
        if (this.mMediaController != null) {
            this.mMediaController.hide();
        }
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    protected void destroyContentVideoView(boolean nativeViewDestroyed) {
        if (this.mMediaController != null) {
            this.mMediaController.setEnabled(false);
            this.mMediaController.hide();
            this.mMediaController = null;
        }
        super.destroyContentVideoView(nativeViewDestroyed);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return true;
    }

    public void setListener(MediaControlsVisibilityListener listener) {
        this.mListener = listener;
    }

    private static class FullScreenMediaController
    extends MediaController {
        final View mVideoView;
        final MediaControlsVisibilityListener mListener;

        public FullScreenMediaController(Context context, View video, MediaControlsVisibilityListener listener) {
            super(context);
            this.mVideoView = video;
            this.mListener = listener;
        }

        public void show() {
            super.show();
            if (this.mListener != null) {
                this.mListener.onMediaControlsVisibilityChanged(true);
            }
            if (this.mVideoView != null) {
                this.mVideoView.setSystemUiVisibility(0);
            }
        }

        public void hide() {
            if (this.mVideoView != null) {
                this.mVideoView.setSystemUiVisibility(1);
            }
            if (this.mListener != null) {
                this.mListener.onMediaControlsVisibilityChanged(false);
            }
            super.hide();
        }
    }

    public static interface MediaControlsVisibilityListener {
        public void onMediaControlsVisibilityChanged(boolean var1);
    }
}

