/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.R;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.ContentVideoViewLegacy;
import org.chromium.ui.base.ViewAndroid;
import org.chromium.ui.base.ViewAndroidDelegate;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="content")
public class ContentVideoView
extends FrameLayout
implements SurfaceHolder.Callback,
ViewAndroidDelegate {
    private static final String TAG = "ContentVideoView";
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 2;
    public static final int MEDIA_ERROR_INVALID_CODE = 3;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PLAYING = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_PLAYBACK_COMPLETED = 3;
    private SurfaceHolder mSurfaceHolder;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mDuration;
    private long mNativeContentVideoView;
    private int mCurrentState = 0;
    private String mPlaybackErrorText;
    private String mUnknownErrorText;
    private String mErrorButton;
    private String mErrorTitle;
    private String mVideoLoadingText;
    private VideoSurfaceView mVideoSurfaceView;
    private View mProgressView;
    private ViewAndroid mViewAndroid;
    private final ContentVideoViewClient mClient;
    private final Runnable mExitFullscreenRunnable = new Runnable(){

        public void run() {
            ContentVideoView.this.exitFullscreen(true);
        }
    };

    protected ContentVideoView(Context context, long nativeContentVideoView, ContentVideoViewClient client) {
        super(context);
        this.mNativeContentVideoView = nativeContentVideoView;
        this.mViewAndroid = new ViewAndroid(new WindowAndroid(context.getApplicationContext()), this);
        this.mClient = client;
        this.initResources(context);
        this.mVideoSurfaceView = new VideoSurfaceView(context);
        this.showContentVideoView();
        this.setVisibility(0);
    }

    protected ContentVideoViewClient getContentVideoViewClient() {
        return this.mClient;
    }

    private void initResources(Context context) {
        if (this.mPlaybackErrorText != null) {
            return;
        }
        this.mPlaybackErrorText = context.getString(R.string.media_player_error_text_invalid_progressive_playback);
        this.mUnknownErrorText = context.getString(R.string.media_player_error_text_unknown);
        this.mErrorButton = context.getString(R.string.media_player_error_button);
        this.mErrorTitle = context.getString(R.string.media_player_error_title);
        this.mVideoLoadingText = context.getString(R.string.media_player_loading_video);
    }

    protected void showContentVideoView() {
        this.mVideoSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.addView((View)this.mVideoSurfaceView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.mProgressView = this.mClient.getVideoLoadingProgressView();
        if (this.mProgressView == null) {
            this.mProgressView = new ProgressView(this.getContext(), this.mVideoLoadingText);
        }
        this.addView(this.mProgressView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
    }

    protected SurfaceView getSurfaceView() {
        return this.mVideoSurfaceView;
    }

    @CalledByNative
    public void onMediaPlayerError(int errorType) {
        Log.d((String)TAG, (String)("OnMediaPlayerError: " + errorType));
        if (this.mCurrentState == -1 || this.mCurrentState == 3) {
            return;
        }
        if (errorType == 3) {
            return;
        }
        this.mCurrentState = -1;
        if (this.getWindowToken() != null) {
            String message = errorType == 2 ? this.mPlaybackErrorText : this.mUnknownErrorText;
            try {
                new AlertDialog.Builder(this.getContext()).setTitle((CharSequence)this.mErrorTitle).setMessage((CharSequence)message).setPositiveButton((CharSequence)this.mErrorButton, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        ContentVideoView.this.onCompletion();
                    }
                }).setCancelable(false).show();
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)("Cannot show the alert dialog, error message: " + message), (Throwable)e);
            }
        }
    }

    @CalledByNative
    private void onVideoSizeChanged(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        this.mVideoSurfaceView.getHolder().setFixedSize(this.mVideoWidth, this.mVideoHeight);
    }

    @CalledByNative
    protected void onBufferingUpdate(int percent) {
    }

    @CalledByNative
    private void onPlaybackComplete() {
        this.onCompletion();
    }

    @CalledByNative
    protected void onUpdateMediaMetadata(int videoWidth, int videoHeight, int duration, boolean canPause, boolean canSeekBack, boolean canSeekForward) {
        this.mDuration = duration;
        this.mProgressView.setVisibility(8);
        this.mCurrentState = this.isPlaying() ? 1 : 2;
        this.onVideoSizeChanged(videoWidth, videoHeight);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        this.openVideo();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mNativeContentVideoView != 0L) {
            this.nativeSetSurface(this.mNativeContentVideoView, null);
        }
        this.mSurfaceHolder = null;
        this.post(this.mExitFullscreenRunnable);
    }

    @CalledByNative
    protected void openVideo() {
        if (this.mSurfaceHolder != null) {
            this.mCurrentState = 0;
            if (this.mNativeContentVideoView != 0L) {
                this.nativeRequestMediaMetadata(this.mNativeContentVideoView);
                this.nativeSetSurface(this.mNativeContentVideoView, this.mSurfaceHolder.getSurface());
            }
        }
    }

    protected void onCompletion() {
        this.mCurrentState = 3;
    }

    protected boolean isInPlaybackState() {
        return this.mCurrentState != -1 && this.mCurrentState != 0;
    }

    protected void start() {
        if (this.isInPlaybackState()) {
            if (this.mNativeContentVideoView != 0L) {
                this.nativePlay(this.mNativeContentVideoView);
            }
            this.mCurrentState = 1;
        }
    }

    protected void pause() {
        if (this.isInPlaybackState() && this.isPlaying()) {
            if (this.mNativeContentVideoView != 0L) {
                this.nativePause(this.mNativeContentVideoView);
            }
            this.mCurrentState = 2;
        }
    }

    protected int getDuration() {
        if (this.isInPlaybackState()) {
            if (this.mDuration > 0) {
                return this.mDuration;
            }
            this.mDuration = this.mNativeContentVideoView != 0L ? this.nativeGetDurationInMilliSeconds(this.mNativeContentVideoView) : 0;
            return this.mDuration;
        }
        this.mDuration = -1;
        return this.mDuration;
    }

    protected int getCurrentPosition() {
        if (this.isInPlaybackState() && this.mNativeContentVideoView != 0L) {
            return this.nativeGetCurrentPosition(this.mNativeContentVideoView);
        }
        return 0;
    }

    protected void seekTo(int msec) {
        if (this.mNativeContentVideoView != 0L) {
            this.nativeSeekTo(this.mNativeContentVideoView, msec);
        }
    }

    public boolean isPlaying() {
        return this.mNativeContentVideoView != 0L && this.nativeIsPlaying(this.mNativeContentVideoView);
    }

    @CalledByNative
    private static ContentVideoView createContentVideoView(Context context, long nativeContentVideoView, ContentVideoViewClient client, boolean legacy) {
        ThreadUtils.assertOnUiThread();
        ContentVideoView videoView = null;
        videoView = legacy ? new ContentVideoViewLegacy(context, nativeContentVideoView, client) : new ContentVideoView(context, nativeContentVideoView, client);
        if (videoView.getContentVideoViewClient().onShowCustomView((View)videoView)) {
            return videoView;
        }
        return null;
    }

    public void removeSurfaceView() {
        this.removeView((View)this.mVideoSurfaceView);
        this.removeView(this.mProgressView);
        this.mVideoSurfaceView = null;
        this.mProgressView = null;
    }

    public void exitFullscreen(boolean relaseMediaPlayer) {
        this.destroyContentVideoView(false);
        if (this.mNativeContentVideoView != 0L) {
            this.nativeExitFullscreen(this.mNativeContentVideoView, relaseMediaPlayer);
            this.mNativeContentVideoView = 0L;
        }
    }

    @CalledByNative
    private void onExitFullscreen() {
        this.exitFullscreen(false);
    }

    @CalledByNative
    protected void destroyContentVideoView(boolean nativeViewDestroyed) {
        if (this.mVideoSurfaceView != null) {
            this.removeSurfaceView();
            this.setVisibility(8);
            this.mClient.onDestroyContentVideoView();
        }
        if (nativeViewDestroyed) {
            this.mNativeContentVideoView = 0L;
        }
    }

    public static ContentVideoView getContentVideoView() {
        return ContentVideoView.nativeGetSingletonJavaContentVideoView();
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.exitFullscreen(false);
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public View acquireAnchorView() {
        View anchorView = new View(this.getContext());
        this.addView(anchorView);
        return anchorView;
    }

    public void setAnchorViewPosition(View view, float x, float y, float width, float height) {
        Log.e((String)TAG, (String)"setAnchorViewPosition isn't implemented");
    }

    public void releaseAnchorView(View anchorView) {
        this.removeView(anchorView);
    }

    @CalledByNative
    private long getNativeViewAndroid() {
        return this.mViewAndroid.getNativePointer();
    }

    private static native ContentVideoView nativeGetSingletonJavaContentVideoView();

    private native void nativeExitFullscreen(long var1, boolean var3);

    private native int nativeGetCurrentPosition(long var1);

    private native int nativeGetDurationInMilliSeconds(long var1);

    private native void nativeRequestMediaMetadata(long var1);

    private native int nativeGetVideoWidth(long var1);

    private native int nativeGetVideoHeight(long var1);

    private native boolean nativeIsPlaying(long var1);

    private native void nativePause(long var1);

    private native void nativePlay(long var1);

    private native void nativeSeekTo(long var1, int var3);

    private native void nativeSetSurface(long var1, Surface var3);

    private static class ProgressView
    extends LinearLayout {
        private final ProgressBar mProgressBar;
        private final TextView mTextView;

        public ProgressView(Context context, String videoLoadingText) {
            super(context);
            this.setOrientation(1);
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            this.mProgressBar = new ProgressBar(context, null, 16842874);
            this.mTextView = new TextView(context);
            this.mTextView.setText((CharSequence)videoLoadingText);
            this.addView((View)this.mProgressBar);
            this.addView((View)this.mTextView);
        }
    }

    private class VideoSurfaceView
    extends SurfaceView {
        public VideoSurfaceView(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int width = 1;
            int height = 1;
            if (ContentVideoView.this.mVideoWidth > 0 && ContentVideoView.this.mVideoHeight > 0) {
                width = VideoSurfaceView.getDefaultSize((int)ContentVideoView.this.mVideoWidth, (int)widthMeasureSpec);
                height = VideoSurfaceView.getDefaultSize((int)ContentVideoView.this.mVideoHeight, (int)heightMeasureSpec);
                if (ContentVideoView.this.mVideoWidth * height > width * ContentVideoView.this.mVideoHeight) {
                    height = width * ContentVideoView.this.mVideoHeight / ContentVideoView.this.mVideoWidth;
                } else if (ContentVideoView.this.mVideoWidth * height < width * ContentVideoView.this.mVideoHeight) {
                    width = height * ContentVideoView.this.mVideoWidth / ContentVideoView.this.mVideoHeight;
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }
}

