/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.ContentViewCore;

@JNINamespace(value="content")
public class ContentSettings {
    private static final String TAG = "ContentSettings";
    private long mNativeContentSettings = 0L;
    private ContentViewCore mContentViewCore;

    ContentSettings(ContentViewCore contentViewCore, long nativeContentView) {
        ThreadUtils.assertOnUiThread();
        this.mContentViewCore = contentViewCore;
        this.mNativeContentSettings = this.nativeInit(nativeContentView);
        assert (this.mNativeContentSettings != 0L);
    }

    @CalledByNative
    private void onNativeContentSettingsDestroyed(long nativeContentSettings) {
        assert (this.mNativeContentSettings == nativeContentSettings);
        this.mNativeContentSettings = 0L;
    }

    public boolean getJavaScriptEnabled() {
        ThreadUtils.assertOnUiThread();
        return this.mNativeContentSettings != 0L ? this.nativeGetJavaScriptEnabled(this.mNativeContentSettings) : false;
    }

    private native long nativeInit(long var1);

    private native boolean nativeGetJavaScriptEnabled(long var1);
}

