/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.library_loader.Linker;
import org.chromium.content.app.ChildProcessService;
import org.chromium.content.app.ChromiumLinkerParams;
import org.chromium.content.app.PrivilegedProcessService;
import org.chromium.content.app.SandboxedProcessService;
import org.chromium.content.browser.BindingManager;
import org.chromium.content.browser.BindingManagerImpl;
import org.chromium.content.browser.ChildProcessConnection;
import org.chromium.content.browser.ChildProcessConnectionImpl;
import org.chromium.content.browser.FileDescriptorInfo;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.SurfaceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
public class ChildProcessLauncher {
    private static final String TAG = "ChildProcessLauncher";
    static final int CALLBACK_FOR_UNKNOWN_PROCESS = 0;
    static final int CALLBACK_FOR_GPU_PROCESS = 1;
    static final int CALLBACK_FOR_RENDERER_PROCESS = 2;
    private static final String SWITCH_PROCESS_TYPE = "type";
    private static final String SWITCH_PPAPI_BROKER_PROCESS = "ppapi-broker";
    private static final String SWITCH_RENDERER_PROCESS = "renderer";
    private static final String SWITCH_GPU_PROCESS = "gpu-process";
    static final int MAX_REGISTERED_SANDBOXED_SERVICES = 13;
    static final int MAX_REGISTERED_PRIVILEGED_SERVICES = 3;
    private static final ChildConnectionAllocator sSandboxedChildConnectionAllocator = new ChildConnectionAllocator(true);
    private static final ChildConnectionAllocator sPrivilegedChildConnectionAllocator = new ChildConnectionAllocator(false);
    private static boolean sConnectionAllocated = false;
    private static boolean sLinkerInitialized = false;
    private static long sLinkerLoadAddress = 0L;
    private static final int NULL_PROCESS_HANDLE = 0;
    private static Map<Integer, ChildProcessConnection> sServiceMap = new ConcurrentHashMap<Integer, ChildProcessConnection>();
    private static ChildProcessConnection sSpareSandboxedConnection = null;
    private static BindingManager sBindingManager = BindingManagerImpl.createBindingManager();
    private static Map<Integer, Surface> sViewSurfaceMap = new ConcurrentHashMap<Integer, Surface>();
    private static Map<Pair<Integer, Integer>, Surface> sSurfaceTextureSurfaceMap = new ConcurrentHashMap<Pair<Integer, Integer>, Surface>();

    public static void setChildProcessClass(Class<? extends SandboxedProcessService> sandboxedServiceClass, Class<? extends PrivilegedProcessService> privilegedServiceClass) {
        assert (!sConnectionAllocated);
        sSandboxedChildConnectionAllocator.setServiceClass(sandboxedServiceClass);
        sPrivilegedChildConnectionAllocator.setServiceClass(privilegedServiceClass);
    }

    private static ChildConnectionAllocator getConnectionAllocator(boolean inSandbox) {
        return inSandbox ? sSandboxedChildConnectionAllocator : sPrivilegedChildConnectionAllocator;
    }

    private static ChildProcessConnection allocateConnection(Context context, boolean inSandbox, ChromiumLinkerParams chromiumLinkerParams) {
        ChildProcessConnection.DeathCallback deathCallback = new ChildProcessConnection.DeathCallback(){

            public void onChildProcessDied(ChildProcessConnection connection) {
                if (connection.getPid() != 0) {
                    ChildProcessLauncher.stop(connection.getPid());
                } else {
                    ChildProcessLauncher.freeConnection(connection);
                }
            }
        };
        sConnectionAllocated = true;
        return ChildProcessLauncher.getConnectionAllocator(inSandbox).allocate(context, deathCallback, chromiumLinkerParams);
    }

    private static ChromiumLinkerParams getLinkerParamsForNewConnection() {
        if (!sLinkerInitialized) {
            if (Linker.isUsed() && (sLinkerLoadAddress = Linker.getBaseLoadAddress()) == 0L) {
                Log.i((String)TAG, (String)"Shared RELRO support disabled!");
            }
            sLinkerInitialized = true;
        }
        if (sLinkerLoadAddress == 0L) {
            return null;
        }
        boolean waitForSharedRelros = true;
        return new ChromiumLinkerParams(sLinkerLoadAddress, true, Linker.getTestRunnerClassName());
    }

    private static ChildProcessConnection allocateBoundConnection(Context context, String[] commandLine, boolean inSandbox) {
        ChromiumLinkerParams chromiumLinkerParams = ChildProcessLauncher.getLinkerParamsForNewConnection();
        ChildProcessConnection connection = ChildProcessLauncher.allocateConnection(context, inSandbox, chromiumLinkerParams);
        if (connection != null) {
            connection.start(commandLine);
        }
        return connection;
    }

    private static void freeConnection(ChildProcessConnection connection) {
        ChildProcessLauncher.getConnectionAllocator(connection.isInSandbox()).free(connection);
    }

    @VisibleForTesting
    public static void setBindingManagerForTesting(BindingManager manager) {
        sBindingManager = manager;
    }

    @CalledByNative
    private static boolean isOomProtected(int pid) {
        return sBindingManager.isOomProtected(pid);
    }

    @CalledByNative
    private static void registerViewSurface(int surfaceId, Surface surface) {
        sViewSurfaceMap.put(surfaceId, surface);
    }

    @CalledByNative
    private static void unregisterViewSurface(int surfaceId) {
        sViewSurfaceMap.remove(surfaceId);
    }

    @CalledByNative
    private static void registerSurfaceTexture(int surfaceTextureId, int childProcessId, SurfaceTexture surfaceTexture) {
        Pair key = new Pair((Object)surfaceTextureId, (Object)childProcessId);
        sSurfaceTextureSurfaceMap.put((Pair<Integer, Integer>)key, new Surface(surfaceTexture));
    }

    @CalledByNative
    private static void unregisterSurfaceTexture(int surfaceTextureId, int childProcessId) {
        Pair key = new Pair((Object)surfaceTextureId, (Object)childProcessId);
        sSurfaceTextureSurfaceMap.remove(key);
    }

    @CalledByNative
    public static void setInForeground(int pid, boolean inForeground) {
        sBindingManager.setInForeground(pid, inForeground);
    }

    public static void onSentToBackground() {
        sBindingManager.onSentToBackground();
    }

    public static void onBroughtToForeground() {
        sBindingManager.onBroughtToForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warmUp(Context context) {
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            assert (!ThreadUtils.runningOnUiThread());
            if (sSpareSandboxedConnection == null) {
                sSpareSandboxedConnection = ChildProcessLauncher.allocateBoundConnection(context, null, true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String getSwitchValue(String[] commandLine, String switchKey) {
        if (commandLine == null || switchKey == null) {
            return null;
        }
        String switchKeyPrefix = "--" + switchKey + "=";
        for (String command : commandLine) {
            if (command == null || !command.startsWith(switchKeyPrefix)) continue;
            return command.substring(switchKeyPrefix.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    static void start(Context context, String[] commandLine, int childProcessId, int[] fileIds, int[] fileFds, boolean[] fileAutoClose, long clientContext) {
        TraceEvent.begin();
        assert (fileIds.length == fileFds.length && fileFds.length == fileAutoClose.length);
        FileDescriptorInfo[] filesToBeMapped = new FileDescriptorInfo[fileFds.length];
        for (int i = 0; i < fileFds.length; ++i) {
            filesToBeMapped[i] = new FileDescriptorInfo(fileIds[i], fileFds[i], fileAutoClose[i]);
        }
        assert (clientContext != 0L);
        int callbackType = 0;
        boolean inSandbox = true;
        String processType = ChildProcessLauncher.getSwitchValue(commandLine, SWITCH_PROCESS_TYPE);
        if (SWITCH_RENDERER_PROCESS.equals(processType)) {
            callbackType = 2;
        } else if (SWITCH_GPU_PROCESS.equals(processType)) {
            callbackType = 1;
        } else if (SWITCH_PPAPI_BROKER_PROCESS.equals(processType)) {
            inSandbox = false;
        }
        ChildProcessConnection allocatedConnection = null;
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            if (inSandbox) {
                allocatedConnection = sSpareSandboxedConnection;
                sSpareSandboxedConnection = null;
            }
            // ** MonitorExit[var13_12] (shouldn't be in output)
            if (allocatedConnection == null && (allocatedConnection = ChildProcessLauncher.allocateBoundConnection(context, commandLine, inSandbox)) == null) {
                ChildProcessLauncher.nativeOnChildProcessStarted(clientContext, 0);
                Log.e((String)TAG, (String)"Allocation of new service failed.");
                TraceEvent.end();
                return;
            }
            Log.d((String)TAG, (String)("Setting up connection to process: slot=" + allocatedConnection.getServiceNumber()));
            ChildProcessLauncher.triggerConnectionSetup(allocatedConnection, commandLine, childProcessId, filesToBeMapped, callbackType, clientContext);
            TraceEvent.end();
            return;
        }
    }

    @VisibleForTesting
    static void triggerConnectionSetup(final ChildProcessConnection connection, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, int callbackType, final long clientContext) {
        ChildProcessConnection.ConnectionCallback connectionCallback = new ChildProcessConnection.ConnectionCallback(){

            public void onConnected(int pid) {
                Log.d((String)ChildProcessLauncher.TAG, (String)("on connect callback, pid=" + pid + " context=" + clientContext));
                if (pid != 0) {
                    sBindingManager.addNewConnection(pid, connection);
                    sServiceMap.put(pid, connection);
                }
                if (clientContext != 0L) {
                    ChildProcessLauncher.nativeOnChildProcessStarted(clientContext, pid);
                }
            }
        };
        connection.setupConnection(commandLine, filesToBeMapped, ChildProcessLauncher.createCallback(childProcessId, callbackType), connectionCallback, Linker.getSharedRelros());
    }

    @CalledByNative
    static void stop(int pid) {
        Log.d((String)TAG, (String)("stopping child connection: pid=" + pid));
        ChildProcessConnection connection = sServiceMap.remove(pid);
        if (connection == null) {
            ChildProcessLauncher.logPidWarning(pid, "Tried to stop non-existent connection");
            return;
        }
        sBindingManager.clearConnection(pid);
        connection.stop();
        ChildProcessLauncher.freeConnection(connection);
    }

    private static IChildProcessCallback createCallback(final int childProcessId, final int callbackType) {
        return new IChildProcessCallback.Stub(){

            public void establishSurfacePeer(int pid, Surface surface, int primaryID, int secondaryID) {
                if (callbackType != 1) {
                    Log.e((String)ChildProcessLauncher.TAG, (String)"Illegal callback for non-GPU process.");
                    return;
                }
                ChildProcessLauncher.nativeEstablishSurfacePeer(pid, surface, primaryID, secondaryID);
            }

            public SurfaceWrapper getViewSurface(int surfaceId) {
                if (callbackType != 1) {
                    Log.e((String)ChildProcessLauncher.TAG, (String)"Illegal callback for non-GPU process.");
                    return null;
                }
                Surface surface = (Surface)sViewSurfaceMap.get(surfaceId);
                if (surface == null) {
                    Log.e((String)ChildProcessLauncher.TAG, (String)"Invalid surfaceId.");
                    return null;
                }
                assert (surface.isValid());
                return new SurfaceWrapper(surface);
            }

            public SurfaceWrapper getSurfaceTextureSurface(int primaryId, int secondaryId) {
                if (callbackType != 2) {
                    Log.e((String)ChildProcessLauncher.TAG, (String)"Illegal callback for non-renderer process.");
                    return null;
                }
                if (secondaryId != childProcessId) {
                    Log.e((String)ChildProcessLauncher.TAG, (String)"Illegal secondaryId for renderer process.");
                    return null;
                }
                Pair key = new Pair((Object)primaryId, (Object)secondaryId);
                Surface surface = (Surface)sSurfaceTextureSurfaceMap.remove(key);
                if (surface == null) {
                    Log.e((String)ChildProcessLauncher.TAG, (String)"Invalid Id for surface texture.");
                    return null;
                }
                assert (surface.isValid());
                return new SurfaceWrapper(surface);
            }
        };
    }

    static void logPidWarning(int pid, String message) {
        if (pid > 0 && !ChildProcessLauncher.nativeIsSingleProcess()) {
            Log.w((String)TAG, (String)(message + ", pid=" + pid));
        }
    }

    @VisibleForTesting
    static ChildProcessConnection allocateBoundConnectionForTesting(Context context) {
        return ChildProcessLauncher.allocateBoundConnection(context, null, true);
    }

    @VisibleForTesting
    static int allocatedConnectionsCountForTesting() {
        return sSandboxedChildConnectionAllocator.allocatedConnectionsCountForTesting();
    }

    @VisibleForTesting
    static int connectedServicesCountForTesting() {
        return sServiceMap.size();
    }

    private static native void nativeOnChildProcessStarted(long var0, int var2);

    private static native void nativeEstablishSurfacePeer(int var0, Surface var1, int var2, int var3);

    private static native boolean nativeIsSingleProcess();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildConnectionAllocator {
        private final ChildProcessConnection[] mChildProcessConnections;
        private final ArrayList<Integer> mFreeConnectionIndices;
        private final Object mConnectionLock = new Object();
        private Class<? extends ChildProcessService> mChildClass;
        private final boolean mInSandbox;

        public ChildConnectionAllocator(boolean inSandbox) {
            int numChildServices = inSandbox ? 13 : 3;
            this.mChildProcessConnections = new ChildProcessConnectionImpl[numChildServices];
            this.mFreeConnectionIndices = new ArrayList(numChildServices);
            for (int i = 0; i < numChildServices; ++i) {
                this.mFreeConnectionIndices.add(i);
            }
            this.setServiceClass(inSandbox ? SandboxedProcessService.class : PrivilegedProcessService.class);
            this.mInSandbox = inSandbox;
        }

        public void setServiceClass(Class<? extends ChildProcessService> childClass) {
            this.mChildClass = childClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChildProcessConnection allocate(Context context, ChildProcessConnection.DeathCallback deathCallback, ChromiumLinkerParams chromiumLinkerParams) {
            Object object = this.mConnectionLock;
            synchronized (object) {
                if (this.mFreeConnectionIndices.isEmpty()) {
                    Log.w((String)ChildProcessLauncher.TAG, (String)"Ran out of service.");
                    return null;
                }
                int slot = this.mFreeConnectionIndices.remove(0);
                assert (this.mChildProcessConnections[slot] == null);
                this.mChildProcessConnections[slot] = new ChildProcessConnectionImpl(context, slot, this.mInSandbox, deathCallback, this.mChildClass, chromiumLinkerParams);
                return this.mChildProcessConnections[slot];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free(ChildProcessConnection connection) {
            Object object = this.mConnectionLock;
            synchronized (object) {
                int slot = connection.getServiceNumber();
                if (this.mChildProcessConnections[slot] != connection) {
                    int occupier = this.mChildProcessConnections[slot] == null ? -1 : this.mChildProcessConnections[slot].getServiceNumber();
                    Log.e((String)ChildProcessLauncher.TAG, (String)("Unable to find connection to free in slot: " + slot + " already occupied by service: " + occupier));
                    assert (false);
                } else {
                    this.mChildProcessConnections[slot] = null;
                    assert (!this.mFreeConnectionIndices.contains(slot));
                    this.mFreeConnectionIndices.add(slot);
                }
            }
        }

        @VisibleForTesting
        int allocatedConnectionsCountForTesting() {
            return this.mChildProcessConnections.length - this.mFreeConnectionIndices.size();
        }
    }
}

