/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.chromium.base.CpuFeatures;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TraceEvent;
import org.chromium.content.app.ChildProcessService;
import org.chromium.content.app.ChromiumLinkerParams;
import org.chromium.content.browser.ChildProcessConnection;
import org.chromium.content.browser.FileDescriptorInfo;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.IChildProcessService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildProcessConnectionImpl
implements ChildProcessConnection {
    private final Context mContext;
    private final int mServiceNumber;
    private final boolean mInSandbox;
    private final ChildProcessConnection.DeathCallback mDeathCallback;
    private final Class<? extends ChildProcessService> mServiceClass;
    private final Object mLock = new Object();
    private IChildProcessService mService = null;
    private boolean mServiceConnectComplete = false;
    private boolean mServiceDisconnected = false;
    private boolean mWasOomProtected = false;
    private int mPid = 0;
    private ChildServiceConnection mInitialBinding = null;
    private ChildServiceConnection mStrongBinding = null;
    private ChildServiceConnection mWaivedBinding = null;
    private int mStrongBindingCount = 0;
    private ChromiumLinkerParams mLinkerParams = null;
    private static final String TAG = "ChildProcessConnection";
    private ConnectionParams mConnectionParams;
    private ChildProcessConnection.ConnectionCallback mConnectionCallback;

    ChildProcessConnectionImpl(Context context, int number, boolean inSandbox, ChildProcessConnection.DeathCallback deathCallback, Class<? extends ChildProcessService> serviceClass, ChromiumLinkerParams chromiumLinkerParams) {
        this.mContext = context;
        this.mServiceNumber = number;
        this.mInSandbox = inSandbox;
        this.mDeathCallback = deathCallback;
        this.mServiceClass = serviceClass;
        this.mLinkerParams = chromiumLinkerParams;
        this.mInitialBinding = new ChildServiceConnection(1);
        this.mStrongBinding = new ChildServiceConnection(65);
        this.mWaivedBinding = new ChildServiceConnection(33);
    }

    @Override
    public int getServiceNumber() {
        return this.mServiceNumber;
    }

    @Override
    public boolean isInSandbox() {
        return this.mInSandbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChildProcessService getService() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPid() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String[] commandLine) {
        Object object = this.mLock;
        synchronized (object) {
            TraceEvent.begin();
            assert (!ThreadUtils.runningOnUiThread());
            assert (this.mConnectionParams == null) : "setupConnection() called before start() in ChildProcessConnectionImpl.";
            if (!this.mInitialBinding.bind(commandLine)) {
                Log.e((String)TAG, (String)"Failed to establish the service connection.");
                this.mDeathCallback.onChildProcessDied(this);
            } else {
                this.mWaivedBinding.bind(null);
            }
            TraceEvent.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupConnection(String[] commandLine, FileDescriptorInfo[] filesToBeMapped, IChildProcessCallback processCallback, ChildProcessConnection.ConnectionCallback connectionCallback, Bundle sharedRelros) {
        Object object = this.mLock;
        synchronized (object) {
            assert (this.mConnectionParams == null);
            if (this.mServiceDisconnected) {
                Log.w((String)TAG, (String)"Tried to setup a connection that already disconnected.");
                connectionCallback.onConnected(0);
                return;
            }
            TraceEvent.begin();
            this.mConnectionCallback = connectionCallback;
            this.mConnectionParams = new ConnectionParams(commandLine, filesToBeMapped, processCallback, sharedRelros);
            if (this.mServiceConnectComplete) {
                this.doConnectionSetupLocked();
            }
            TraceEvent.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.mInitialBinding.unbind();
            this.mStrongBinding.unbind();
            this.mWaivedBinding.unbind();
            this.mStrongBindingCount = 0;
            if (this.mService != null) {
                this.mService = null;
            }
            this.mConnectionParams = null;
        }
    }

    private void doConnectionSetupLocked() {
        TraceEvent.begin();
        assert (this.mServiceConnectComplete && this.mService != null);
        assert (this.mConnectionParams != null);
        Bundle bundle = new Bundle();
        bundle.putStringArray("com.google.android.apps.chrome.extra.command_line", this.mConnectionParams.mCommandLine);
        FileDescriptorInfo[] fileInfos = this.mConnectionParams.mFilesToBeMapped;
        ParcelFileDescriptor[] parcelFiles = new ParcelFileDescriptor[fileInfos.length];
        for (int i = 0; i < fileInfos.length; ++i) {
            if (fileInfos[i].mFd == -1) {
                Log.e((String)TAG, (String)("Invalid FD (id=" + fileInfos[i].mId + ") for process connection, " + "aborting connection."));
                return;
            }
            String idName = "com.google.android.apps.chrome.extra.extraFile_" + i + "_id";
            String fdName = "com.google.android.apps.chrome.extra.extraFile_" + i + "_fd";
            if (fileInfos[i].mAutoClose) {
                parcelFiles[i] = ParcelFileDescriptor.adoptFd((int)fileInfos[i].mFd);
            } else {
                try {
                    parcelFiles[i] = ParcelFileDescriptor.fromFd((int)fileInfos[i].mFd);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Invalid FD provided for process connection, aborting connection.", (Throwable)e);
                    return;
                }
            }
            bundle.putParcelable(fdName, (Parcelable)parcelFiles[i]);
            bundle.putInt(idName, fileInfos[i].mId);
        }
        bundle.putInt("com.google.android.apps.chrome.extra.cpu_count", CpuFeatures.getCount());
        bundle.putLong("com.google.android.apps.chrome.extra.cpu_features", CpuFeatures.getMask());
        bundle.putBundle("org.chromium.base.android.linker.shared_relros", this.mConnectionParams.mSharedRelros);
        try {
            this.mPid = this.mService.setupConnection(bundle, this.mConnectionParams.mCallback);
            assert (this.mPid != 0) : "Child service claims to be run by a process of pid=0.";
        }
        catch (RemoteException re) {
            Log.e((String)TAG, (String)"Failed to setup connection.", (Throwable)re);
        }
        try {
            for (ParcelFileDescriptor parcelFile : parcelFiles) {
                if (parcelFile == null) continue;
                parcelFile.close();
            }
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (String)"Failed to close FD.", (Throwable)ioe);
        }
        this.mConnectionParams = null;
        if (this.mConnectionCallback != null) {
            this.mConnectionCallback.onConnected(this.mPid);
        }
        this.mConnectionCallback = null;
        TraceEvent.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialBindingBound() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInitialBinding.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStrongBindingBound() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mStrongBinding.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInitialBinding() {
        Object object = this.mLock;
        synchronized (object) {
            this.mInitialBinding.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOomProtectedOrWasWhenDied() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mServiceDisconnected) {
                return this.mWasOomProtected;
            }
            return this.mInitialBinding.isBound() || this.mStrongBinding.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropOomBindings() {
        Object object = this.mLock;
        synchronized (object) {
            this.mInitialBinding.unbind();
            this.mStrongBindingCount = 0;
            this.mStrongBinding.unbind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStrongBinding() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService == null) {
                Log.w((String)TAG, (String)("The connection is not bound for " + this.mPid));
                return;
            }
            if (this.mStrongBindingCount == 0) {
                this.mStrongBinding.bind(null);
            }
            ++this.mStrongBindingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStrongBinding() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService == null) {
                Log.w((String)TAG, (String)("The connection is not bound for " + this.mPid));
                return;
            }
            assert (this.mStrongBindingCount > 0);
            --this.mStrongBindingCount;
            if (this.mStrongBindingCount == 0) {
                this.mStrongBinding.unbind();
            }
        }
    }

    @VisibleForTesting
    public boolean crashServiceForTesting() throws RemoteException {
        try {
            this.mService.crashIntentionallyForTesting();
        }
        catch (DeadObjectException e) {
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public boolean isConnected() {
        return this.mService != null;
    }

    private class ChildServiceConnection
    implements ServiceConnection {
        private boolean mBound = false;
        private final int mBindFlags;

        private Intent createServiceBindIntent() {
            Intent intent = new Intent();
            intent.setClassName(ChildProcessConnectionImpl.this.mContext, ChildProcessConnectionImpl.this.mServiceClass.getName() + ChildProcessConnectionImpl.this.mServiceNumber);
            intent.setPackage(ChildProcessConnectionImpl.this.mContext.getPackageName());
            return intent;
        }

        public ChildServiceConnection(int bindFlags) {
            this.mBindFlags = bindFlags;
        }

        boolean bind(String[] commandLine) {
            if (!this.mBound) {
                TraceEvent.begin();
                Intent intent = this.createServiceBindIntent();
                if (commandLine != null) {
                    intent.putExtra("com.google.android.apps.chrome.extra.command_line", commandLine);
                }
                if (ChildProcessConnectionImpl.this.mLinkerParams != null) {
                    ChildProcessConnectionImpl.this.mLinkerParams.addIntentExtras(intent);
                }
                this.mBound = ChildProcessConnectionImpl.this.mContext.bindService(intent, (ServiceConnection)this, this.mBindFlags);
                TraceEvent.end();
            }
            return this.mBound;
        }

        void unbind() {
            if (this.mBound) {
                ChildProcessConnectionImpl.this.mContext.unbindService((ServiceConnection)this);
                this.mBound = false;
            }
        }

        boolean isBound() {
            return this.mBound;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            Object object = ChildProcessConnectionImpl.this.mLock;
            synchronized (object) {
                if (ChildProcessConnectionImpl.this.mServiceConnectComplete) {
                    return;
                }
                TraceEvent.begin();
                ChildProcessConnectionImpl.this.mServiceConnectComplete = true;
                ChildProcessConnectionImpl.this.mService = IChildProcessService.Stub.asInterface(service);
                if (ChildProcessConnectionImpl.this.mConnectionParams != null) {
                    ChildProcessConnectionImpl.this.doConnectionSetupLocked();
                }
                TraceEvent.end();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName className) {
            Object object = ChildProcessConnectionImpl.this.mLock;
            synchronized (object) {
                if (ChildProcessConnectionImpl.this.mServiceDisconnected) {
                    return;
                }
                ChildProcessConnectionImpl.this.mServiceDisconnected = true;
                ChildProcessConnectionImpl.this.mWasOomProtected = ChildProcessConnectionImpl.this.mInitialBinding.isBound() || ChildProcessConnectionImpl.this.mStrongBinding.isBound();
                Log.w((String)ChildProcessConnectionImpl.TAG, (String)("onServiceDisconnected (crash or killed by oom): pid=" + ChildProcessConnectionImpl.this.mPid));
                ChildProcessConnectionImpl.this.stop();
                ChildProcessConnectionImpl.this.mDeathCallback.onChildProcessDied(ChildProcessConnectionImpl.this);
                if (ChildProcessConnectionImpl.this.mConnectionCallback != null) {
                    ChildProcessConnectionImpl.this.mConnectionCallback.onConnected(0);
                }
                ChildProcessConnectionImpl.this.mConnectionCallback = null;
            }
        }
    }

    private static class ConnectionParams {
        final String[] mCommandLine;
        final FileDescriptorInfo[] mFilesToBeMapped;
        final IChildProcessCallback mCallback;
        final Bundle mSharedRelros;

        ConnectionParams(String[] commandLine, FileDescriptorInfo[] filesToBeMapped, IChildProcessCallback callback, Bundle sharedRelros) {
            this.mCommandLine = commandLine;
            this.mFilesToBeMapped = filesToBeMapped;
            this.mCallback = callback;
            this.mSharedRelros = sharedRelros;
        }
    }
}

