/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.content.app.ContentMain;
import org.chromium.content.browser.DeviceUtils;
import org.chromium.content.browser.PepperPluginManager;
import org.chromium.content.browser.ResourceExtractor;

@JNINamespace(value="content")
public class BrowserStartupController {
    private static final String TAG = "BrowserStartupController";
    private static final boolean ALREADY_STARTED = true;
    private static final boolean NOT_ALREADY_STARTED = false;
    @VisibleForTesting
    static final int STARTUP_SUCCESS = -1;
    @VisibleForTesting
    static final int STARTUP_FAILURE = 1;
    private static BrowserStartupController sInstance;
    private static boolean sBrowserMayStartAsynchronously;
    private final List<StartupCallback> mAsyncStartupCallbacks;
    private final Context mContext;
    private boolean mHasStartedInitializingBrowserProcess;
    private boolean mStartupDone;
    public static final int MAX_RENDERERS_SINGLE_PROCESS = 0;
    public static final int MAX_RENDERERS_LIMIT = 9;
    private boolean mStartupSuccess;

    private static void setAsynchronousStartup(boolean enable) {
        sBrowserMayStartAsynchronously = enable;
    }

    @VisibleForTesting
    @CalledByNative
    static boolean browserMayStartAsynchonously() {
        return sBrowserMayStartAsynchronously;
    }

    @VisibleForTesting
    @CalledByNative
    static void browserStartupComplete(int result) {
        if (sInstance != null) {
            sInstance.executeEnqueuedCallbacks(result, false);
        }
    }

    BrowserStartupController(Context context) {
        this.mContext = context;
        this.mAsyncStartupCallbacks = new ArrayList<StartupCallback>();
    }

    public static BrowserStartupController get(Context context) {
        assert (ThreadUtils.runningOnUiThread()) : "Tried to start the browser on the wrong thread.";
        ThreadUtils.assertOnUiThread();
        if (sInstance == null) {
            sInstance = new BrowserStartupController(context.getApplicationContext());
        }
        return sInstance;
    }

    @VisibleForTesting
    static BrowserStartupController overrideInstanceForTest(BrowserStartupController controller) {
        if (sInstance == null) {
            sInstance = controller;
        }
        return sInstance;
    }

    public void startBrowserProcessesAsync(StartupCallback callback) throws ProcessInitException {
        assert (ThreadUtils.runningOnUiThread()) : "Tried to start the browser on the wrong thread.";
        if (this.mStartupDone) {
            this.postStartupCompleted(callback);
            return;
        }
        this.mAsyncStartupCallbacks.add(callback);
        if (!this.mHasStartedInitializingBrowserProcess) {
            this.mHasStartedInitializingBrowserProcess = true;
            this.prepareToStartBrowserProcess(9);
            BrowserStartupController.setAsynchronousStartup(true);
            if (this.contentStart() > 0) {
                this.enqueueCallbackExecution(1, false);
            }
        }
    }

    public void startBrowserProcessesSync(int maxRenderers) throws ProcessInitException {
        if (!this.mStartupDone) {
            if (!this.mHasStartedInitializingBrowserProcess) {
                this.prepareToStartBrowserProcess(maxRenderers);
            }
            BrowserStartupController.setAsynchronousStartup(false);
            if (this.contentStart() > 0) {
                this.enqueueCallbackExecution(1, false);
            }
        }
        assert (this.mStartupDone);
        if (!this.mStartupSuccess) {
            throw new ProcessInitException(4);
        }
    }

    @VisibleForTesting
    int contentStart() {
        return ContentMain.start();
    }

    public void addStartupCompletedObserver(StartupCallback callback) {
        ThreadUtils.assertOnUiThread();
        if (this.mStartupDone) {
            this.postStartupCompleted(callback);
        } else {
            this.mAsyncStartupCallbacks.add(callback);
        }
    }

    private void executeEnqueuedCallbacks(int startupResult, boolean alreadyStarted) {
        assert (ThreadUtils.runningOnUiThread()) : "Callback from browser startup from wrong thread.";
        this.mStartupDone = true;
        this.mStartupSuccess = startupResult <= 0;
        for (StartupCallback asyncStartupCallback : this.mAsyncStartupCallbacks) {
            if (this.mStartupSuccess) {
                asyncStartupCallback.onSuccess(alreadyStarted);
                continue;
            }
            asyncStartupCallback.onFailure();
        }
        this.mAsyncStartupCallbacks.clear();
    }

    private void enqueueCallbackExecution(final int startupFailure, final boolean alreadyStarted) {
        new Handler().post(new Runnable(){

            public void run() {
                BrowserStartupController.this.executeEnqueuedCallbacks(startupFailure, alreadyStarted);
            }
        });
    }

    private void postStartupCompleted(final StartupCallback callback) {
        new Handler().post(new Runnable(){

            public void run() {
                if (BrowserStartupController.this.mStartupSuccess) {
                    callback.onSuccess(true);
                } else {
                    callback.onFailure();
                }
            }
        });
    }

    @VisibleForTesting
    void prepareToStartBrowserProcess(int maxRendererProcesses) throws ProcessInitException {
        Log.i((String)TAG, (String)("Initializing chromium process, renderers=" + maxRendererProcesses));
        ResourceExtractor resourceExtractor = ResourceExtractor.get(this.mContext);
        resourceExtractor.startExtractingResources();
        LibraryLoader.ensureInitialized(this.mContext, true);
        DeviceUtils.addDeviceSpecificUserAgentSwitch(this.mContext);
        Context appContext = this.mContext.getApplicationContext();
        resourceExtractor.waitForCompletion();
        BrowserStartupController.nativeSetCommandLineFlags(maxRendererProcesses, BrowserStartupController.nativeIsPluginEnabled() ? this.getPlugins() : null);
        ContentMain.initApplicationContext(appContext);
    }

    public void initChromiumBrowserProcessForTests() {
        ResourceExtractor resourceExtractor = ResourceExtractor.get(this.mContext);
        resourceExtractor.startExtractingResources();
        resourceExtractor.waitForCompletion();
        BrowserStartupController.nativeSetCommandLineFlags(1, null);
    }

    private String getPlugins() {
        return PepperPluginManager.getPlugins(this.mContext);
    }

    private static native void nativeSetCommandLineFlags(int var0, String var1);

    private static native boolean nativeIsOfficialBuild();

    private static native boolean nativeIsPluginEnabled();

    static {
        sBrowserMayStartAsynchronously = false;
    }

    public static interface StartupCallback {
        public void onSuccess(boolean var1);

        public void onFailure();
    }
}

