/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.util.Log;
import android.util.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import org.chromium.base.SysUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.BindingManager;
import org.chromium.content.browser.ChildProcessConnection;

class BindingManagerImpl
implements BindingManager {
    private static final String TAG = "BindingManager";
    private static final long REMOVE_INITIAL_BINDING_DELAY_MILLIS = 1000L;
    private static final long DETACH_AS_ACTIVE_HIGH_END_DELAY_MILLIS = 1000L;
    private final long mRemoveInitialBindingDelay;
    private final long mRemoveStrongBindingDelay;
    private final boolean mIsLowMemoryDevice;
    private final SparseArray<ManagedConnection> mManagedConnections = new SparseArray();
    private ManagedConnection mLastInForeground;
    private final Object mLastInForegroundLock = new Object();
    private ManagedConnection mBoundForBackgroundPeriod;

    private BindingManagerImpl(boolean isLowMemoryDevice, long removeInitialBindingDelay, long removeStrongBindingDelay) {
        this.mIsLowMemoryDevice = isLowMemoryDevice;
        this.mRemoveInitialBindingDelay = removeInitialBindingDelay;
        this.mRemoveStrongBindingDelay = removeStrongBindingDelay;
    }

    public static BindingManagerImpl createBindingManager() {
        return new BindingManagerImpl(SysUtils.isLowEndDevice(), 1000L, 1000L);
    }

    public static BindingManagerImpl createBindingManagerForTesting(boolean isLowEndDevice) {
        return new BindingManagerImpl(isLowEndDevice, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewConnection(int pid, ChildProcessConnection connection) {
        SparseArray<ManagedConnection> sparseArray = this.mLastInForegroundLock;
        synchronized (sparseArray) {
            if (this.mIsLowMemoryDevice && this.mLastInForeground != null) {
                this.mLastInForeground.dropBindings();
            }
        }
        sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            this.mManagedConnections.put(pid, (Object)new ManagedConnection(connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInForeground(int pid, boolean inForeground) {
        ManagedConnection managedConnection;
        Object object = this.mManagedConnections;
        synchronized (object) {
            managedConnection = (ManagedConnection)this.mManagedConnections.get(pid);
        }
        if (managedConnection == null) {
            Log.w((String)TAG, (String)("Cannot setInForeground() - never saw a connection for the pid: " + Integer.toString(pid)));
            return;
        }
        object = this.mLastInForegroundLock;
        synchronized (object) {
            managedConnection.setInForeground(inForeground);
            if (inForeground) {
                this.mLastInForeground = managedConnection;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSentToBackground() {
        assert (this.mBoundForBackgroundPeriod == null);
        Object object = this.mLastInForegroundLock;
        synchronized (object) {
            if (this.mLastInForeground != null) {
                this.mLastInForeground.setBoundForBackgroundPeriod(true);
                this.mBoundForBackgroundPeriod = this.mLastInForeground;
            }
        }
    }

    public void onBroughtToForeground() {
        if (this.mBoundForBackgroundPeriod != null) {
            this.mBoundForBackgroundPeriod.setBoundForBackgroundPeriod(false);
            this.mBoundForBackgroundPeriod = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOomProtected(int pid) {
        ManagedConnection managedConnection;
        SparseArray<ManagedConnection> sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            managedConnection = (ManagedConnection)this.mManagedConnections.get(pid);
        }
        return managedConnection != null ? managedConnection.isOomProtected() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConnection(int pid) {
        ManagedConnection managedConnection;
        SparseArray<ManagedConnection> sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            managedConnection = (ManagedConnection)this.mManagedConnections.get(pid);
        }
        if (managedConnection != null) {
            managedConnection.clearConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isConnectionCleared(int pid) {
        SparseArray<ManagedConnection> sparseArray = this.mManagedConnections;
        synchronized (sparseArray) {
            return ((ManagedConnection)this.mManagedConnections.get(pid)).isConnectionCleared();
        }
    }

    private class ManagedConnection {
        private ChildProcessConnection mConnection;
        private boolean mInForeground;
        private boolean mBoundForBackgroundPeriod;
        private boolean mWasOomProtected;

        private void removeInitialBinding() {
            final ChildProcessConnection connection = this.mConnection;
            if (connection == null || !connection.isInitialBindingBound()) {
                return;
            }
            ThreadUtils.postOnUiThreadDelayed(new Runnable(){

                public void run() {
                    if (connection.isInitialBindingBound()) {
                        connection.removeInitialBinding();
                    }
                }
            }, BindingManagerImpl.this.mRemoveInitialBindingDelay);
        }

        private void addStrongBinding() {
            ChildProcessConnection connection = this.mConnection;
            if (connection == null) {
                return;
            }
            connection.addStrongBinding();
        }

        private void removeStrongBinding() {
            final ChildProcessConnection connection = this.mConnection;
            if (connection == null || !connection.isStrongBindingBound()) {
                return;
            }
            Runnable doUnbind = new Runnable(){

                public void run() {
                    if (connection.isStrongBindingBound()) {
                        connection.removeStrongBinding();
                    }
                }
            };
            if (BindingManagerImpl.this.mIsLowMemoryDevice) {
                doUnbind.run();
            } else {
                ThreadUtils.postOnUiThreadDelayed(doUnbind, BindingManagerImpl.this.mRemoveStrongBindingDelay);
            }
        }

        private void dropBindings() {
            assert (BindingManagerImpl.this.mIsLowMemoryDevice);
            ChildProcessConnection connection = this.mConnection;
            if (connection == null) {
                return;
            }
            connection.dropOomBindings();
        }

        ManagedConnection(ChildProcessConnection connection) {
            this.mConnection = connection;
        }

        void setInForeground(boolean nextInForeground) {
            if (!this.mInForeground && nextInForeground) {
                this.addStrongBinding();
            } else if (this.mInForeground && !nextInForeground) {
                this.removeStrongBinding();
            }
            this.removeInitialBinding();
            this.mInForeground = nextInForeground;
        }

        void setBoundForBackgroundPeriod(boolean nextBound) {
            if (!this.mBoundForBackgroundPeriod && nextBound) {
                this.addStrongBinding();
            } else if (this.mBoundForBackgroundPeriod && !nextBound) {
                this.removeStrongBinding();
            }
            this.mBoundForBackgroundPeriod = nextBound;
        }

        boolean isOomProtected() {
            return this.mConnection != null ? this.mConnection.isOomProtectedOrWasWhenDied() : this.mWasOomProtected;
        }

        void clearConnection() {
            this.mWasOomProtected = this.mConnection.isOomProtectedOrWasWhenDied();
            this.mConnection = null;
        }

        @VisibleForTesting
        boolean isConnectionCleared() {
            return this.mConnection == null;
        }
    }
}

