/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="content")
class BatteryStatusManager {
    private static final String TAG = "BatteryStatusManager";
    private final Context mAppContext;
    private final IntentFilter mFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BatteryStatusManager.this.onReceive(intent);
        }
    };
    private long mNativePtr;
    private final Object mNativePtrLock = new Object();
    private boolean mEnabled = false;

    protected BatteryStatusManager(Context context) {
        this.mAppContext = context.getApplicationContext();
    }

    @CalledByNative
    static BatteryStatusManager getInstance(Context appContext) {
        return new BatteryStatusManager(appContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    boolean start(long nativePtr) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (!this.mEnabled && this.mAppContext.registerReceiver(this.mReceiver, this.mFilter) != null) {
                this.mNativePtr = nativePtr;
                this.mEnabled = true;
            }
        }
        return this.mEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    void stop() {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mEnabled) {
                this.mAppContext.unregisterReceiver(this.mReceiver);
                this.mNativePtr = 0L;
                this.mEnabled = false;
            }
        }
    }

    @VisibleForTesting
    void onReceive(Intent intent) {
        int status;
        int max;
        boolean present;
        if (!intent.getAction().equals("android.intent.action.BATTERY_CHANGED")) {
            Log.e((String)TAG, (String)"Unexpected intent.");
            return;
        }
        boolean bl = present = this.ignoreBatteryPresentState() ? true : intent.getBooleanExtra("present", false);
        if (!present) {
            this.gotBatteryStatus(true, 0.0, Double.POSITIVE_INFINITY, 1.0);
            return;
        }
        int current = intent.getIntExtra("level", -1);
        double level = (double)current / (double)(max = intent.getIntExtra("scale", -1));
        if (level < 0.0 || level > 1.0) {
            level = 1.0;
        }
        boolean charging = (status = intent.getIntExtra("status", -1)) != 3;
        double chargingTime = status == 5 ? 0.0 : Double.POSITIVE_INFINITY;
        double dischargingTime = Double.POSITIVE_INFINITY;
        this.gotBatteryStatus(charging, chargingTime, dischargingTime, level);
    }

    protected boolean ignoreBatteryPresentState() {
        return Build.MODEL.equals("Galaxy Nexus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotBatteryStatus(boolean charging, double chargingTime, double dischargingTime, double level) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotBatteryStatus(this.mNativePtr, charging, chargingTime, dischargingTime, level);
            }
        }
    }

    private native void nativeGotBatteryStatus(long var1, boolean var3, double var4, double var6, double var8);
}

