/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import org.chromium.content.browser.ContentVideoViewClient;

public class ActivityContentVideoViewClient
implements ContentVideoViewClient {
    private final Activity mActivity;
    private View mView;

    public ActivityContentVideoViewClient(Activity activity) {
        this.mActivity = activity;
    }

    public boolean onShowCustomView(View view) {
        FrameLayout decor = (FrameLayout)this.mActivity.getWindow().getDecorView();
        decor.addView(view, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        this.setSystemUiVisibility((View)decor, true);
        this.mView = view;
        return true;
    }

    public void onDestroyContentVideoView() {
        FrameLayout decor = (FrameLayout)this.mActivity.getWindow().getDecorView();
        decor.removeView(this.mView);
        this.setSystemUiVisibility((View)decor, false);
        this.mView = null;
    }

    public View getVideoLoadingProgressView() {
        return null;
    }

    @SuppressLint(value={"InlinedApi"})
    private void setSystemUiVisibility(View view, boolean enterFullscreen) {
        if (enterFullscreen) {
            this.mActivity.getWindow().setFlags(1024, 1024);
        } else {
            this.mActivity.getWindow().clearFlags(1024);
        }
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        int systemUiVisibility = view.getSystemUiVisibility();
        int flags = 5638;
        systemUiVisibility = enterFullscreen ? (systemUiVisibility |= flags) : (systemUiVisibility &= ~flags);
        view.setSystemUiVisibility(systemUiVisibility);
    }
}

