/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.app;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import android.view.Surface;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.content.app.ChromiumLinkerParams;
import org.chromium.content.app.ContentMain;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.IChildProcessService;

@JNINamespace(value="content")
public class ChildProcessService
extends Service {
    private static final String MAIN_THREAD_NAME = "ChildProcessMain";
    private static final String TAG = "ChildProcessService";
    private IChildProcessCallback mCallback;
    private Thread mMainThread;
    private String[] mCommandLineParams;
    private int mCpuCount;
    private long mCpuFeatures;
    private ArrayList<Integer> mFileIds;
    private ArrayList<ParcelFileDescriptor> mFileFds;
    private ChromiumLinkerParams mLinkerParams;
    private static AtomicReference<Context> sContext = new AtomicReference<Object>(null);
    private boolean mLibraryInitialized = false;
    private boolean mIsBound = false;
    private final IChildProcessService.Stub mBinder = new IChildProcessService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int setupConnection(Bundle args, IChildProcessCallback callback) {
            ChildProcessService.this.mCallback = callback;
            Thread thread = ChildProcessService.this.mMainThread;
            synchronized (thread) {
                String fdName;
                ParcelFileDescriptor parcel;
                if (ChildProcessService.this.mCommandLineParams == null) {
                    ChildProcessService.access$202(ChildProcessService.this, args.getStringArray("com.google.android.apps.chrome.extra.command_line"));
                }
                assert (ChildProcessService.this.mCommandLineParams != null);
                ChildProcessService.this.mCpuCount = args.getInt("com.google.android.apps.chrome.extra.cpu_count");
                ChildProcessService.this.mCpuFeatures = args.getLong("com.google.android.apps.chrome.extra.cpu_features");
                assert (ChildProcessService.this.mCpuCount > 0);
                ChildProcessService.this.mFileIds = new ArrayList();
                ChildProcessService.this.mFileFds = new ArrayList();
                int i = 0;
                while ((parcel = (ParcelFileDescriptor)args.getParcelable(fdName = "com.google.android.apps.chrome.extra.extraFile_" + i + "_fd")) != null) {
                    ChildProcessService.this.mFileFds.add(parcel);
                    String idName = "com.google.android.apps.chrome.extra.extraFile_" + i + "_id";
                    ChildProcessService.this.mFileIds.add(args.getInt(idName));
                    ++i;
                }
                Bundle sharedRelros = args.getBundle("org.chromium.base.android.linker.shared_relros");
                if (sharedRelros != null) {
                    Linker.useSharedRelros(sharedRelros);
                    sharedRelros = null;
                }
                ChildProcessService.this.mMainThread.notifyAll();
            }
            return Process.myPid();
        }

        public void crashIntentionallyForTesting() {
            Process.killProcess((int)Process.myPid());
        }
    };

    static Context getContext() {
        return sContext.get();
    }

    public void onCreate() {
        Log.i((String)TAG, (String)("Creating new ChildProcessService pid=" + Process.myPid()));
        if (sContext.get() != null) {
            Log.e((String)TAG, (String)"ChildProcessService created again in process!");
        }
        sContext.set((Context)this);
        super.onCreate();
        this.mMainThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    boolean useLinker = Linker.isUsed();
                    if (useLinker) {
                        Thread thread = ChildProcessService.this.mMainThread;
                        synchronized (thread) {
                            while (!ChildProcessService.this.mIsBound) {
                                ChildProcessService.this.mMainThread.wait();
                            }
                        }
                        if (ChildProcessService.this.mLinkerParams != null) {
                            if (((ChildProcessService)ChildProcessService.this).mLinkerParams.mWaitForSharedRelro) {
                                Linker.initServiceProcess(((ChildProcessService)ChildProcessService.this).mLinkerParams.mBaseLoadAddress);
                            } else {
                                Linker.disableSharedRelros();
                            }
                            Linker.setTestRunnerClassName(((ChildProcessService)ChildProcessService.this).mLinkerParams.mTestRunnerClassName);
                        }
                    }
                    try {
                        LibraryLoader.loadNow(ChildProcessService.this.getApplicationContext(), false);
                    }
                    catch (ProcessInitException e) {
                        Log.e((String)ChildProcessService.TAG, (String)"Failed to load native library, exiting child process", (Throwable)e);
                        System.exit(-1);
                    }
                    Thread e = ChildProcessService.this.mMainThread;
                    synchronized (e) {
                        while (ChildProcessService.this.mCommandLineParams == null) {
                            ChildProcessService.this.mMainThread.wait();
                        }
                    }
                    LibraryLoader.initialize(ChildProcessService.this.mCommandLineParams);
                    e = ChildProcessService.this.mMainThread;
                    synchronized (e) {
                        ChildProcessService.this.mLibraryInitialized = true;
                        ChildProcessService.this.mMainThread.notifyAll();
                        while (ChildProcessService.this.mFileIds == null) {
                            ChildProcessService.this.mMainThread.wait();
                        }
                    }
                    assert (ChildProcessService.this.mFileIds.size() == ChildProcessService.this.mFileFds.size());
                    int[] fileIds = new int[ChildProcessService.this.mFileIds.size()];
                    int[] fileFds = new int[ChildProcessService.this.mFileFds.size()];
                    for (int i = 0; i < ChildProcessService.this.mFileIds.size(); ++i) {
                        fileIds[i] = (Integer)ChildProcessService.this.mFileIds.get(i);
                        fileFds[i] = ((ParcelFileDescriptor)ChildProcessService.this.mFileFds.get(i)).detachFd();
                    }
                    ContentMain.initApplicationContext(((Context)sContext.get()).getApplicationContext());
                    ChildProcessService.nativeInitChildProcess(((Context)sContext.get()).getApplicationContext(), ChildProcessService.this, fileIds, fileFds, ChildProcessService.this.mCpuCount, ChildProcessService.this.mCpuFeatures);
                    ContentMain.start();
                    ChildProcessService.nativeExitChildProcess();
                }
                catch (InterruptedException e) {
                    Log.w((String)ChildProcessService.TAG, (String)("ChildProcessMain startup failed: " + e));
                }
                catch (ProcessInitException e) {
                    Log.w((String)ChildProcessService.TAG, (String)("ChildProcessMain startup failed: " + e));
                }
            }
        }, MAIN_THREAD_NAME);
        this.mMainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Log.i((String)TAG, (String)("Destroying ChildProcessService pid=" + Process.myPid()));
        super.onDestroy();
        if (this.mCommandLineParams == null) {
            return;
        }
        Thread thread = this.mMainThread;
        synchronized (thread) {
            try {
                while (!this.mLibraryInitialized) {
                    this.mMainThread.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.nativeShutdownMainThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder onBind(Intent intent) {
        this.stopSelf();
        Thread thread = this.mMainThread;
        synchronized (thread) {
            this.mCommandLineParams = intent.getStringArrayExtra("com.google.android.apps.chrome.extra.command_line");
            this.mLinkerParams = null;
            if (Linker.isUsed()) {
                this.mLinkerParams = new ChromiumLinkerParams(intent);
            }
            this.mIsBound = true;
            this.mMainThread.notifyAll();
        }
        return this.mBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void establishSurfaceTexturePeer(int pid, Object surfaceObject, int primaryID, int secondaryID) {
        if (this.mCallback == null) {
            Log.e((String)TAG, (String)"No callback interface has been provided.");
            return;
        }
        Surface surface = null;
        boolean needRelease = false;
        if (surfaceObject instanceof Surface) {
            surface = (Surface)surfaceObject;
        } else if (surfaceObject instanceof SurfaceTexture) {
            surface = new Surface((SurfaceTexture)surfaceObject);
            needRelease = true;
        } else {
            Log.e((String)TAG, (String)("Not a valid surfaceObject: " + surfaceObject));
            return;
        }
        try {
            this.mCallback.establishSurfacePeer(pid, surface, primaryID, secondaryID);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Unable to call establishSurfaceTexturePeer: " + (Object)((Object)e)));
            return;
        }
        finally {
            if (needRelease) {
                surface.release();
            }
        }
    }

    @CalledByNative
    private Surface getViewSurface(int surfaceId) {
        if (this.mCallback == null) {
            Log.e((String)TAG, (String)"No callback interface has been provided.");
            return null;
        }
        try {
            return this.mCallback.getViewSurface(surfaceId).getSurface();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Unable to call establishSurfaceTexturePeer: " + (Object)((Object)e)));
            return null;
        }
    }

    @CalledByNative
    private Surface getSurfaceTextureSurface(int primaryId, int secondaryId) {
        if (this.mCallback == null) {
            Log.e((String)TAG, (String)"No callback interface has been provided.");
            return null;
        }
        try {
            return this.mCallback.getSurfaceTextureSurface(primaryId, secondaryId).getSurface();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)("Unable to call getSurfaceTextureSurface: " + (Object)((Object)e)));
            return null;
        }
    }

    private static native void nativeInitChildProcess(Context var0, ChildProcessService var1, int[] var2, int[] var3, int var4, long var5);

    private static native void nativeExitChildProcess();

    private native void nativeShutdownMainThread();

    static /* synthetic */ String[] access$202(ChildProcessService x0, String[] x1) {
        x0.mCommandLineParams = x1;
        return x1;
    }
}

