/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.chromium.base.SysUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.library_loader.NativeLibraries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linker {
    private static final String TAG = "chromium_android_linker";
    private static final boolean DEBUG = false;
    public static final int BROWSER_SHARED_RELRO_CONFIG_NEVER = 0;
    public static final int BROWSER_SHARED_RELRO_CONFIG_LOW_RAM_ONLY = 1;
    public static final int BROWSER_SHARED_RELRO_CONFIG_ALWAYS = 2;
    public static final int BROWSER_SHARED_RELRO_CONFIG = 1;
    public static final int MEMORY_DEVICE_CONFIG_INIT = 0;
    public static final int MEMORY_DEVICE_CONFIG_LOW = 1;
    public static final int MEMORY_DEVICE_CONFIG_NORMAL = 2;
    private static int sMemoryDeviceConfig = 0;
    private static boolean sInitialized = false;
    private static boolean sRelroSharingSupported = false;
    private static boolean sInBrowserProcess = true;
    private static boolean sWaitForSharedRelros = false;
    private static boolean sBrowserUsesSharedRelro = false;
    private static Bundle sSharedRelros = null;
    private static long sBaseLoadAddress = 0L;
    private static long sCurrentLoadAddress = 0L;
    private static boolean sLoadAtFixedAddressFailed = false;
    private static boolean sPrepareLibraryLoadCalled = false;
    static String sTestRunnerClassName = null;
    private static HashMap<String, LibInfo> sLoadedLibraries = null;
    public static final String EXTRA_LINKER_SHARED_RELROS = "org.chromium.base.android.linker.shared_relros";

    private static void ensureInitializedLocked() {
        assert (Thread.holdsLock(Linker.class));
        if (!sInitialized) {
            sRelroSharingSupported = false;
            if (NativeLibraries.USE_LINKER) {
                try {
                    System.loadLibrary(TAG);
                }
                catch (UnsatisfiedLinkError e) {
                    System.loadLibrary("chromium_android_linker.cr");
                }
                sRelroSharingSupported = Linker.nativeCanUseSharedRelro();
                if (!sRelroSharingSupported) {
                    Log.w((String)TAG, (String)"This system cannot safely share RELRO sections");
                }
                if (sMemoryDeviceConfig == 0) {
                    sMemoryDeviceConfig = SysUtils.isLowEndDevice() ? 1 : 2;
                }
                switch (1) {
                    case 0: {
                        sBrowserUsesSharedRelro = false;
                        break;
                    }
                    case 1: {
                        boolean bl = sBrowserUsesSharedRelro = sMemoryDeviceConfig == 1;
                        if (!sBrowserUsesSharedRelro) break;
                        Log.w((String)TAG, (String)"Low-memory device: shared RELROs used in all processes");
                        break;
                    }
                    case 2: {
                        Log.w((String)TAG, (String)"Beware: shared RELROs used in all processes!");
                        sBrowserUsesSharedRelro = true;
                        break;
                    }
                    default: {
                        assert (false) : "Unreached";
                        break;
                    }
                }
            }
            if (!sRelroSharingSupported) {
                sBrowserUsesSharedRelro = false;
                sWaitForSharedRelros = false;
            }
            sInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTestRunnerClassName(String testRunnerClassName) {
        if (!NativeLibraries.ENABLE_LINKER_TESTS) {
            return;
        }
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            assert (sTestRunnerClassName == null);
            sTestRunnerClassName = testRunnerClassName;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTestRunnerClassName() {
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sTestRunnerClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMemoryDeviceConfig(int memoryDeviceConfig) {
        assert (NativeLibraries.ENABLE_LINKER_TESTS);
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            assert (sMemoryDeviceConfig == 0);
            assert (memoryDeviceConfig == 1 || memoryDeviceConfig == 2);
            sMemoryDeviceConfig = memoryDeviceConfig;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUsed() {
        if (!NativeLibraries.USE_LINKER) {
            return false;
        }
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            Linker.ensureInitializedLocked();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sRelroSharingSupported;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareLibraryLoad() {
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            sPrepareLibraryLoadCalled = true;
            if (sInBrowserProcess) {
                Linker.setupBaseLoadAddressLocked();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishLibraryLoad() {
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            if (sLoadedLibraries != null) {
                if (sInBrowserProcess) {
                    sSharedRelros = Linker.createBundleFromLibInfoMap(sLoadedLibraries);
                    if (sBrowserUsesSharedRelro) {
                        Linker.useSharedRelrosLocked(sSharedRelros);
                    }
                }
                if (sWaitForSharedRelros) {
                    assert (!sInBrowserProcess);
                    while (sSharedRelros == null) {
                        try {
                            Linker.class.wait();
                        }
                        catch (InterruptedException ie) {}
                    }
                    Linker.useSharedRelrosLocked(sSharedRelros);
                    sSharedRelros.clear();
                    sSharedRelros = null;
                }
            }
            if (NativeLibraries.ENABLE_LINKER_TESTS && sTestRunnerClassName != null) {
                TestRunner testRunner = null;
                try {
                    testRunner = (TestRunner)Class.forName(sTestRunnerClassName).newInstance();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Could not extract test runner class name", (Throwable)e);
                    testRunner = null;
                }
                if (testRunner != null) {
                    if (!testRunner.runChecks(sMemoryDeviceConfig, sInBrowserProcess)) {
                        Log.wtf((String)TAG, (String)"Linker runtime tests failed in this process!!");
                        assert (false);
                    } else {
                        Log.i((String)TAG, (String)"All linker tests passed!");
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useSharedRelros(Bundle bundle) {
        Bundle clonedBundle = null;
        if (bundle != null) {
            bundle.setClassLoader(LibInfo.class.getClassLoader());
            clonedBundle = new Bundle(LibInfo.class.getClassLoader());
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            clonedBundle.readFromParcel(parcel);
            parcel.recycle();
        }
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            sSharedRelros = clonedBundle;
            Linker.class.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle getSharedRelros() {
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            if (!sInBrowserProcess) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sSharedRelros;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableSharedRelros() {
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            sInBrowserProcess = false;
            sWaitForSharedRelros = false;
            sBrowserUsesSharedRelro = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initServiceProcess(long baseLoadAddress) {
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            Linker.ensureInitializedLocked();
            sInBrowserProcess = false;
            sBrowserUsesSharedRelro = false;
            if (sRelroSharingSupported) {
                sWaitForSharedRelros = true;
                sBaseLoadAddress = baseLoadAddress;
                sCurrentLoadAddress = baseLoadAddress;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getBaseLoadAddress() {
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            Linker.ensureInitializedLocked();
            if (!sInBrowserProcess) {
                Log.w((String)TAG, (String)"Shared RELRO sections are disabled in this process!");
                // ** MonitorExit[var0] (shouldn't be in output)
                return 0L;
            }
            Linker.setupBaseLoadAddressLocked();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sBaseLoadAddress;
        }
    }

    private static void setupBaseLoadAddressLocked() {
        assert (Thread.holdsLock(Linker.class));
        if (sBaseLoadAddress == 0L) {
            long address;
            sBaseLoadAddress = address = Linker.computeRandomBaseLoadAddress();
            sCurrentLoadAddress = address;
            if (address == 0L) {
                Log.w((String)TAG, (String)"Disabling shared RELROs due to bad entropy sources");
                sBrowserUsesSharedRelro = false;
                sWaitForSharedRelros = false;
            }
        }
    }

    private static long computeRandomBaseLoadAddress() {
        int numBits;
        long baseAddressLimit = 0x40000000L;
        long baseAddress = 0x20000000L;
        long baseAddressMax = 0x34000000L;
        long pageSize = Linker.nativeGetPageSize();
        int offsetLimit = (int)(0x14000000L / pageSize);
        for (numBits = 30; numBits > 1 && 1 << numBits > offsetLimit; --numBits) {
        }
        int offset = Linker.getRandomBits(numBits);
        long address = 0L;
        if (offset >= 0) {
            address = 0x20000000L + (long)offset * pageSize;
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getRandomBits(int numBits) {
        FileInputStream input;
        assert (numBits > 0);
        assert (numBits < 32);
        try {
            input = new FileInputStream(new File("/dev/urandom"));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Could not open /dev/urandom", (Throwable)e);
            return -1;
        }
        int result = 0;
        try {
            for (int n = 0; n < 4; ++n) {
                result = result << 8 | input.read() & 0xFF;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Could not read /dev/urandom", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
        }
        return result &= (1 << numBits) - 1;
    }

    private static void dumpBundle(Bundle bundle) {
    }

    private static void useSharedRelrosLocked(Bundle bundle) {
        assert (Thread.holdsLock(Linker.class));
        if (bundle == null) {
            return;
        }
        if (!sRelroSharingSupported) {
            return;
        }
        if (sLoadedLibraries == null) {
            return;
        }
        HashMap<String, LibInfo> relroMap = Linker.createLibInfoMapFromBundle(bundle);
        for (Map.Entry<String, LibInfo> entry : relroMap.entrySet()) {
            LibInfo libInfo;
            String libName = entry.getKey();
            if (Linker.nativeUseSharedRelro(libName, libInfo = entry.getValue())) continue;
            Log.w((String)TAG, (String)("Could not use shared RELRO section for " + libName));
        }
        if (!sInBrowserProcess) {
            Linker.closeLibInfoMap(relroMap);
        }
    }

    public static boolean loadAtFixedAddressFailed() {
        return sLoadAtFixedAddressFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrary(String library) {
        if (library.equals(TAG) || library.equals("chromium_android_linker.cr")) {
            return;
        }
        Class<Linker> clazz = Linker.class;
        synchronized (Linker.class) {
            Linker.ensureInitializedLocked();
            assert (sPrepareLibraryLoadCalled);
            String libName = System.mapLibraryName(library);
            if (sLoadedLibraries == null) {
                sLoadedLibraries = new HashMap();
            }
            if (sLoadedLibraries.containsKey(libName)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            LibInfo libInfo = new LibInfo();
            long loadAddress = 0L;
            if (sInBrowserProcess && sBrowserUsesSharedRelro || sWaitForSharedRelros) {
                loadAddress = sCurrentLoadAddress;
            }
            if (!Linker.nativeLoadLibrary(libName, loadAddress, libInfo)) {
                String errorMessage = "Unable to load library: " + libName;
                Log.e((String)TAG, (String)errorMessage);
                throw new UnsatisfiedLinkError(errorMessage);
            }
            if (loadAddress != 0L && loadAddress != libInfo.mLoadAddress) {
                sLoadAtFixedAddressFailed = true;
            }
            if (NativeLibraries.ENABLE_LINKER_TESTS) {
                Log.i((String)TAG, (String)String.format(Locale.US, "%s_LIBRARY_ADDRESS: %s %x", sInBrowserProcess ? "BROWSER" : "RENDERER", libName, libInfo.mLoadAddress));
            }
            if (sInBrowserProcess && !Linker.nativeCreateSharedRelro(libName, sCurrentLoadAddress, libInfo)) {
                Log.w((String)TAG, (String)String.format(Locale.US, "Could not create shared RELRO for %s at %x", libName, sCurrentLoadAddress));
            }
            if (sCurrentLoadAddress != 0L) {
                sCurrentLoadAddress = libInfo.mLoadAddress + libInfo.mLoadSize;
            }
            sLoadedLibraries.put(libName, libInfo);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void postCallbackOnMainThread(final long opaque) {
        ThreadUtils.postOnUiThread(new Runnable(){

            public void run() {
                Linker.nativeRunCallbackOnUiThread(opaque);
            }
        });
    }

    private static native void nativeRunCallbackOnUiThread(long var0);

    private static native boolean nativeLoadLibrary(String var0, long var1, LibInfo var3);

    private static native boolean nativeCreateSharedRelro(String var0, long var1, LibInfo var3);

    private static native boolean nativeUseSharedRelro(String var0, LibInfo var1);

    private static native boolean nativeCanUseSharedRelro();

    private static native long nativeGetPageSize();

    private static Bundle createBundleFromLibInfoMap(HashMap<String, LibInfo> map) {
        Bundle bundle = new Bundle(map.size());
        for (Map.Entry<String, LibInfo> entry : map.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    private static HashMap<String, LibInfo> createLibInfoMapFromBundle(Bundle bundle) {
        HashMap<String, LibInfo> map = new HashMap<String, LibInfo>();
        for (String library : bundle.keySet()) {
            LibInfo libInfo = (LibInfo)bundle.getParcelable(library);
            map.put(library, libInfo);
        }
        return map;
    }

    private static void closeLibInfoMap(HashMap<String, LibInfo> map) {
        for (Map.Entry<String, LibInfo> entry : map.entrySet()) {
            entry.getValue().close();
        }
    }

    public static class LibInfo
    implements Parcelable {
        public static final Parcelable.Creator<LibInfo> CREATOR = new Parcelable.Creator<LibInfo>(){

            public LibInfo createFromParcel(Parcel in) {
                return new LibInfo(in);
            }

            public LibInfo[] newArray(int size) {
                return new LibInfo[size];
            }
        };
        public long mLoadAddress;
        public long mLoadSize;
        public long mRelroStart;
        public long mRelroSize;
        public int mRelroFd;

        public LibInfo() {
            this.mLoadAddress = 0L;
            this.mLoadSize = 0L;
            this.mRelroStart = 0L;
            this.mRelroSize = 0L;
            this.mRelroFd = -1;
        }

        public void close() {
            if (this.mRelroFd >= 0) {
                try {
                    ParcelFileDescriptor.adoptFd((int)this.mRelroFd).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mRelroFd = -1;
            }
        }

        public LibInfo(Parcel in) {
            this.mLoadAddress = in.readLong();
            this.mLoadSize = in.readLong();
            this.mRelroStart = in.readLong();
            this.mRelroSize = in.readLong();
            ParcelFileDescriptor fd = in.readFileDescriptor();
            this.mRelroFd = fd.detachFd();
        }

        public void writeToParcel(Parcel out, int flags) {
            if (this.mRelroFd >= 0) {
                out.writeLong(this.mLoadAddress);
                out.writeLong(this.mLoadSize);
                out.writeLong(this.mRelroStart);
                out.writeLong(this.mRelroSize);
                try {
                    ParcelFileDescriptor fd = ParcelFileDescriptor.fromFd((int)this.mRelroFd);
                    fd.writeToParcel(out, 0);
                    fd.close();
                }
                catch (IOException e) {
                    Log.e((String)Linker.TAG, (String)"Cant' write LibInfo file descriptor to parcel", (Throwable)e);
                }
            }
        }

        public int describeContents() {
            return 1;
        }

        public String toString() {
            return String.format(Locale.US, "[load=0x%x-0x%x relro=0x%x-0x%x fd=%d]", this.mLoadAddress, this.mLoadAddress + this.mLoadSize, this.mRelroStart, this.mRelroStart + this.mRelroSize, this.mRelroFd);
        }
    }

    public static interface TestRunner {
        public boolean runChecks(int var1, boolean var2);
    }
}

