/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.content.Context;
import android.os.SystemClock;
import android.util.Log;
import org.chromium.base.CommandLine;
import org.chromium.base.JNINamespace;
import org.chromium.base.SysUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.library_loader.LibraryLoaderHelper;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.NativeLibraries;
import org.chromium.base.library_loader.ProcessInitException;

@JNINamespace(value="base::android")
public class LibraryLoader {
    private static final String TAG = "LibraryLoader";
    private static final Object sLock = new Object();
    private static boolean sLoaded = false;
    private static boolean sInitialized = false;
    private static boolean sNativeLibraryHackWasUsed = false;

    public static void ensureInitialized() throws ProcessInitException {
        LibraryLoader.ensureInitialized(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureInitialized(Context context, boolean shouldDeleteOldWorkaroundLibraries) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            if (sInitialized) {
                return;
            }
            LibraryLoader.loadAlreadyLocked(context, shouldDeleteOldWorkaroundLibraries);
            LibraryLoader.initializeAlreadyLocked(CommandLine.getJavaSwitchesOrNull());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Object object = sLock;
        synchronized (object) {
            return sInitialized;
        }
    }

    public static void loadNow() throws ProcessInitException {
        LibraryLoader.loadNow(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNow(Context context, boolean shouldDeleteOldWorkaroundLibraries) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            LibraryLoader.loadAlreadyLocked(context, shouldDeleteOldWorkaroundLibraries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(String[] initCommandLine) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            LibraryLoader.initializeAlreadyLocked(initCommandLine);
        }
    }

    private static void loadAlreadyLocked(Context context, boolean shouldDeleteOldWorkaroundLibraries) throws ProcessInitException {
        try {
            if (!sLoaded) {
                assert (!sInitialized);
                long startTime = SystemClock.uptimeMillis();
                boolean useChromiumLinker = Linker.isUsed();
                if (useChromiumLinker) {
                    Linker.prepareLibraryLoad();
                }
                for (String library : NativeLibraries.LIBRARIES) {
                    Log.i((String)TAG, (String)("Loading: " + library));
                    if (useChromiumLinker) {
                        Linker.loadLibrary(library);
                        continue;
                    }
                    try {
                        System.loadLibrary(library);
                    }
                    catch (UnsatisfiedLinkError e) {
                        if (context != null && LibraryLoaderHelper.tryLoadLibraryUsingWorkaround(context, library)) {
                            sNativeLibraryHackWasUsed = true;
                            continue;
                        }
                        throw e;
                    }
                }
                if (useChromiumLinker) {
                    Linker.finishLibraryLoad();
                }
                if (context != null && shouldDeleteOldWorkaroundLibraries && !sNativeLibraryHackWasUsed) {
                    LibraryLoaderHelper.deleteWorkaroundLibrariesAsynchronously(context);
                }
                long stopTime = SystemClock.uptimeMillis();
                Log.i((String)TAG, (String)String.format("Time to load native libraries: %d ms (timestamps %d-%d)", stopTime - startTime, startTime % 10000L, stopTime % 10000L));
                sLoaded = true;
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new ProcessInitException(2, (Throwable)e);
        }
        Log.i((String)TAG, (String)String.format("Expected native library version number \"%s\",actual native library version number \"%s\"", NativeLibraries.VERSION_NUMBER, LibraryLoader.nativeGetVersionNumber()));
        if (!NativeLibraries.VERSION_NUMBER.equals(LibraryLoader.nativeGetVersionNumber())) {
            throw new ProcessInitException(3);
        }
    }

    private static void initializeAlreadyLocked(String[] initCommandLine) throws ProcessInitException {
        if (sInitialized) {
            return;
        }
        if (!LibraryLoader.nativeLibraryLoaded(initCommandLine)) {
            Log.e((String)TAG, (String)"error calling nativeLibraryLoaded");
            throw new ProcessInitException(1);
        }
        sInitialized = true;
        CommandLine.enableNativeProxy();
        TraceEvent.registerNativeEnabledObserver();
        if (Linker.isUsed()) {
            LibraryLoader.nativeRecordChromiumAndroidLinkerHistogram(Linker.loadAtFixedAddressFailed(), SysUtils.isLowEndDevice());
        }
        LibraryLoader.nativeRecordNativeLibraryHack(sNativeLibraryHackWasUsed);
    }

    private static native boolean nativeLibraryLoaded(String[] var0);

    private static native void nativeRecordChromiumAndroidLinkerHistogram(boolean var0, boolean var1);

    private static native String nativeGetVersionNumber();

    private static native void nativeRecordNativeLibraryHack(boolean var0);
}

