/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import android.os.Message;
import org.chromium.base.CalledByNative;

class SystemMessageHandler
extends Handler {
    private static final int SCHEDULED_WORK = 1;
    private static final int DELAYED_SCHEDULED_WORK = 2;
    private long mMessagePumpDelegateNative = 0L;
    private long mDelayedScheduledTimeTicks = 0L;

    private SystemMessageHandler(long messagePumpDelegateNative) {
        this.mMessagePumpDelegateNative = messagePumpDelegateNative;
    }

    public void handleMessage(Message msg) {
        if (msg.what == 2) {
            this.mDelayedScheduledTimeTicks = 0L;
        }
        this.nativeDoRunLoopOnce(this.mMessagePumpDelegateNative, this.mDelayedScheduledTimeTicks);
    }

    @CalledByNative
    private void scheduleWork() {
        this.sendEmptyMessage(1);
    }

    @CalledByNative
    private void scheduleDelayedWork(long delayedTimeTicks, long millis) {
        if (this.mDelayedScheduledTimeTicks != 0L) {
            this.removeMessages(2);
        }
        this.mDelayedScheduledTimeTicks = delayedTimeTicks;
        this.sendEmptyMessageDelayed(2, millis);
    }

    @CalledByNative
    private void removeAllPendingMessages() {
        this.removeMessages(1);
        this.removeMessages(2);
    }

    @CalledByNative
    private static SystemMessageHandler create(long messagePumpDelegateNative) {
        return new SystemMessageHandler(messagePumpDelegateNative);
    }

    private native void nativeDoRunLoopOnce(long var1, long var3);
}

