/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Environment;
import org.chromium.base.CalledByNative;

public abstract class PathUtils {
    private static String sDataDirectorySuffix;

    private PathUtils() {
    }

    public static void setPrivateDataDirectorySuffix(String suffix) {
        sDataDirectorySuffix = suffix;
    }

    @CalledByNative
    public static String getDataDirectory(Context appContext) {
        if (sDataDirectorySuffix == null) {
            throw new IllegalStateException("setDataDirectorySuffix must be called before getDataDirectory");
        }
        return appContext.getDir(sDataDirectorySuffix, 0).getPath();
    }

    @CalledByNative
    public static String getDatabaseDirectory(Context appContext) {
        return appContext.getDatabasePath("foo").getParent();
    }

    @CalledByNative
    public static String getCacheDirectory(Context appContext) {
        return appContext.getCacheDir().getPath();
    }

    @CalledByNative
    private static String getDownloadsDirectory(Context appContext) {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
    }

    @CalledByNative
    private static String getNativeLibraryDirectory(Context appContext) {
        ApplicationInfo ai = appContext.getApplicationInfo();
        if ((ai.flags & 0x80) != 0 || (ai.flags & 1) == 0) {
            return ai.nativeLibraryDir;
        }
        return "/system/lib/";
    }

    @CalledByNative
    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }
}

