/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ObserverList<E>
implements Iterable<E> {
    public final List<E> mObservers = new ArrayList();
    private int mIterationDepth = 0;
    private int mCount = 0;

    public boolean addObserver(E obs) {
        if (obs == null || this.mObservers.contains(obs)) {
            return false;
        }
        boolean result = this.mObservers.add(obs);
        assert (result);
        ++this.mCount;
        return true;
    }

    public boolean removeObserver(E obs) {
        if (obs == null) {
            return false;
        }
        int index = this.mObservers.indexOf(obs);
        if (index == -1) {
            return false;
        }
        if (this.mIterationDepth == 0) {
            this.mObservers.remove(index);
        } else {
            this.mObservers.set(index, null);
        }
        --this.mCount;
        assert (this.mCount >= 0);
        return true;
    }

    public boolean hasObserver(E obs) {
        return this.mObservers.contains(obs);
    }

    public void clear() {
        this.mCount = 0;
        if (this.mIterationDepth == 0) {
            this.mObservers.clear();
            return;
        }
        int size = this.mObservers.size();
        for (int i = 0; i < size; ++i) {
            this.mObservers.set(i, null);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new ObserverListIterator();
    }

    public RewindableIterator<E> rewindableIterator() {
        return new ObserverListIterator();
    }

    public int size() {
        return this.mCount;
    }

    public boolean isEmpty() {
        return this.mCount == 0;
    }

    private void compact() {
        assert (this.mIterationDepth == 0);
        for (int i = this.mObservers.size() - 1; i >= 0; --i) {
            if (this.mObservers.get(i) != null) continue;
            this.mObservers.remove(i);
        }
    }

    private void incrementIterationDepth() {
        ++this.mIterationDepth;
    }

    private void decrementIterationDepthAndCompactIfNeeded() {
        --this.mIterationDepth;
        assert (this.mIterationDepth >= 0);
        if (this.mIterationDepth == 0) {
            this.compact();
        }
    }

    private int capacity() {
        return this.mObservers.size();
    }

    private E getObserverAt(int index) {
        return this.mObservers.get(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObserverListIterator
    implements RewindableIterator<E> {
        private int mListEndMarker;
        private int mIndex = 0;
        private boolean mIsExhausted = false;

        private ObserverListIterator() {
            ObserverList.this.incrementIterationDepth();
            this.mListEndMarker = ObserverList.this.capacity();
        }

        @Override
        public void rewind() {
            this.compactListIfNeeded();
            ObserverList.this.incrementIterationDepth();
            this.mListEndMarker = ObserverList.this.capacity();
            this.mIsExhausted = false;
            this.mIndex = 0;
        }

        @Override
        public boolean hasNext() {
            int lookupIndex;
            for (lookupIndex = this.mIndex; lookupIndex < this.mListEndMarker && ObserverList.this.getObserverAt(lookupIndex) == null; ++lookupIndex) {
            }
            if (lookupIndex < this.mListEndMarker) {
                return true;
            }
            this.compactListIfNeeded();
            return false;
        }

        @Override
        public E next() {
            while (this.mIndex < this.mListEndMarker && ObserverList.this.getObserverAt(this.mIndex) == null) {
                ++this.mIndex;
            }
            if (this.mIndex < this.mListEndMarker) {
                return ObserverList.this.getObserverAt(this.mIndex++);
            }
            this.compactListIfNeeded();
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void compactListIfNeeded() {
            if (!this.mIsExhausted) {
                this.mIsExhausted = true;
                ObserverList.this.decrementIterationDepthAndCompactIfNeeded();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RewindableIterator<E>
    extends Iterator<E> {
        public void rewind();
    }
}

