/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.view.Window;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.ObserverList;
import org.chromium.base.WindowCallbackWrapper;

public class ApplicationStatusManager {
    private static ObserverList<WindowFocusChangedListener> sWindowFocusListeners = new ObserverList();

    public static void init(Application app) {
        ApplicationStatus.initialize(app);
        app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ApplicationStatusManager.setWindowFocusChangedCallback(activity);
            }

            public void onActivityDestroyed(Activity activity) {
                assert (activity.getWindow().getCallback() instanceof WindowCallbackWrapper);
            }

            public void onActivityPaused(Activity activity) {
                assert (activity.getWindow().getCallback() instanceof WindowCallbackWrapper);
            }

            public void onActivityResumed(Activity activity) {
                assert (activity.getWindow().getCallback() instanceof WindowCallbackWrapper);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                assert (activity.getWindow().getCallback() instanceof WindowCallbackWrapper);
            }

            public void onActivityStarted(Activity activity) {
                assert (activity.getWindow().getCallback() instanceof WindowCallbackWrapper);
            }

            public void onActivityStopped(Activity activity) {
                assert (activity.getWindow().getCallback() instanceof WindowCallbackWrapper);
            }
        });
    }

    public static void registerWindowFocusChangedListener(WindowFocusChangedListener listener) {
        sWindowFocusListeners.addObserver(listener);
    }

    public static void unregisterWindowFocusChangedListener(WindowFocusChangedListener listener) {
        sWindowFocusListeners.removeObserver(listener);
    }

    public static void informActivityStarted(Activity activity) {
        ApplicationStatusManager.setWindowFocusChangedCallback(activity);
        ApplicationStatus.informActivityStarted(activity);
    }

    private static void setWindowFocusChangedCallback(final Activity activity) {
        Window.Callback callback = activity.getWindow().getCallback();
        activity.getWindow().setCallback((Window.Callback)new WindowCallbackWrapper(callback){

            public void onWindowFocusChanged(boolean hasFocus) {
                super.onWindowFocusChanged(hasFocus);
                for (WindowFocusChangedListener listener : sWindowFocusListeners) {
                    listener.onWindowFocusChanged(activity, hasFocus);
                }
            }
        });
    }

    public static interface WindowFocusChangedListener {
        public void onWindowFocusChanged(Activity var1, boolean var2);
    }
}

