/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.chromium.base.ApplicationStatusManager;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ObserverList;
import org.chromium.base.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="base::android")
public class ApplicationStatus {
    private static Application sApplication;
    private static Object sCachedApplicationStateLock;
    private static Integer sCachedApplicationState;
    private static Activity sActivity;
    private static ApplicationStateListener sNativeApplicationStateListener;
    private static final Map<Activity, ActivityInfo> sActivityInfo;
    private static final ObserverList<ActivityStateListener> sGeneralActivityStateListeners;
    private static final ObserverList<ApplicationStateListener> sApplicationStateListeners;

    private ApplicationStatus() {
    }

    public static void initialize(Application app) {
        sApplication = app;
        ApplicationStatusManager.registerWindowFocusChangedListener(new ApplicationStatusManager.WindowFocusChangedListener(){

            public void onWindowFocusChanged(Activity activity, boolean hasFocus) {
                if (!hasFocus || activity == sActivity) {
                    return;
                }
                int state = ApplicationStatus.getStateForActivity(activity);
                if (state != 6 && state != 5) {
                    sActivity = activity;
                }
            }
        });
        sApplication.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ApplicationStatus.onStateChange(activity, 1);
            }

            public void onActivityDestroyed(Activity activity) {
                ApplicationStatus.onStateChange(activity, 6);
            }

            public void onActivityPaused(Activity activity) {
                ApplicationStatus.onStateChange(activity, 4);
            }

            public void onActivityResumed(Activity activity) {
                ApplicationStatus.onStateChange(activity, 3);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityStarted(Activity activity) {
                ApplicationStatus.onStateChange(activity, 2);
            }

            public void onActivityStopped(Activity activity) {
                ApplicationStatus.onStateChange(activity, 5);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onStateChange(Activity activity, int newState) {
        if (activity == null) {
            throw new IllegalArgumentException("null activity is not supported");
        }
        if (sActivity == null || newState == 1 || newState == 3 || newState == 2) {
            sActivity = activity;
        }
        int oldApplicationState = ApplicationStatus.getStateForApplication();
        if (newState == 1) {
            assert (!sActivityInfo.containsKey(activity));
            sActivityInfo.put(activity, new ActivityInfo());
        }
        Object object = sCachedApplicationStateLock;
        synchronized (object) {
            sCachedApplicationState = null;
        }
        ActivityInfo info = sActivityInfo.get(activity);
        if (info == null) {
            return;
        }
        info.setStatus(newState);
        for (ActivityStateListener listener : info.getListeners()) {
            listener.onActivityStateChange(activity, newState);
        }
        for (ActivityStateListener listener : sGeneralActivityStateListeners) {
            listener.onActivityStateChange(activity, newState);
        }
        int applicationState = ApplicationStatus.getStateForApplication();
        if (applicationState != oldApplicationState) {
            for (ApplicationStateListener listener : sApplicationStateListeners) {
                listener.onApplicationStateChange(applicationState);
            }
        }
        if (newState == 6) {
            sActivityInfo.remove(activity);
            if (activity == sActivity) {
                sActivity = null;
            }
        }
    }

    public static void onStateChangeForTesting(Activity activity, int newState) {
        ApplicationStatus.onStateChange(activity, newState);
    }

    public static Activity getLastTrackedFocusedActivity() {
        return sActivity;
    }

    public static List<WeakReference<Activity>> getRunningActivities() {
        ArrayList<WeakReference<Activity>> activities = new ArrayList<WeakReference<Activity>>();
        for (Activity activity : sActivityInfo.keySet()) {
            activities.add(new WeakReference<Activity>(activity));
        }
        return activities;
    }

    public static Context getApplicationContext() {
        return sApplication != null ? sApplication.getApplicationContext() : null;
    }

    public static int getStateForActivity(Activity activity) {
        ActivityInfo info = sActivityInfo.get(activity);
        return info != null ? info.getStatus() : 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStateForApplication() {
        Object object = sCachedApplicationStateLock;
        synchronized (object) {
            if (sCachedApplicationState == null) {
                sCachedApplicationState = ApplicationStatus.determineApplicationState();
            }
        }
        return sCachedApplicationState;
    }

    public static boolean hasVisibleActivities() {
        int state = ApplicationStatus.getStateForApplication();
        return state == 1 || state == 2;
    }

    public static boolean isEveryActivityDestroyed() {
        return sActivityInfo.isEmpty();
    }

    public static void registerStateListenerForAllActivities(ActivityStateListener listener) {
        sGeneralActivityStateListeners.addObserver(listener);
    }

    public static void registerStateListenerForActivity(ActivityStateListener listener, Activity activity) {
        assert (activity != null);
        ActivityInfo info = sActivityInfo.get(activity);
        assert (info != null && info.getStatus() != 6);
        info.getListeners().addObserver(listener);
    }

    public static void unregisterActivityStateListener(ActivityStateListener listener) {
        sGeneralActivityStateListeners.removeObserver(listener);
        for (ActivityInfo info : sActivityInfo.values()) {
            info.getListeners().removeObserver(listener);
        }
    }

    public static void registerApplicationStateListener(ApplicationStateListener listener) {
        sApplicationStateListeners.addObserver(listener);
    }

    public static void unregisterApplicationStateListener(ApplicationStateListener listener) {
        sApplicationStateListeners.removeObserver(listener);
    }

    public static void informActivityStarted(Activity activity) {
        ApplicationStatus.onStateChange(activity, 1);
        ApplicationStatus.onStateChange(activity, 2);
        ApplicationStatus.onStateChange(activity, 3);
    }

    @CalledByNative
    private static void registerThreadSafeNativeApplicationStateListener() {
        ThreadUtils.runOnUiThread(new Runnable(){

            public void run() {
                if (sNativeApplicationStateListener != null) {
                    return;
                }
                sNativeApplicationStateListener = new ApplicationStateListener(){

                    public void onApplicationStateChange(int newState) {
                        ApplicationStatus.nativeOnApplicationStateChange(newState);
                    }
                };
                ApplicationStatus.registerApplicationStateListener(sNativeApplicationStateListener);
            }
        });
    }

    private static int determineApplicationState() {
        boolean hasPausedActivity = false;
        boolean hasStoppedActivity = false;
        for (ActivityInfo info : sActivityInfo.values()) {
            int state = info.getStatus();
            if (state != 4 && state != 5 && state != 6) {
                return 1;
            }
            if (state == 4) {
                hasPausedActivity = true;
                continue;
            }
            if (state != 5) continue;
            hasStoppedActivity = true;
        }
        if (hasPausedActivity) {
            return 2;
        }
        if (hasStoppedActivity) {
            return 3;
        }
        return 4;
    }

    private static native void nativeOnApplicationStateChange(int var0);

    static {
        sCachedApplicationStateLock = new Object();
        sActivityInfo = new ConcurrentHashMap<Activity, ActivityInfo>();
        sGeneralActivityStateListeners = new ObserverList();
        sApplicationStateListeners = new ObserverList();
    }

    public static interface ActivityStateListener {
        public void onActivityStateChange(Activity var1, int var2);
    }

    public static interface ApplicationStateListener {
        public void onApplicationStateChange(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActivityInfo {
        private int mStatus = 6;
        private ObserverList<ActivityStateListener> mListeners = new ObserverList();

        private ActivityInfo() {
        }

        public int getStatus() {
            return this.mStatus;
        }

        public void setStatus(int status) {
            this.mStatus = status;
        }

        public ObserverList<ActivityStateListener> getListeners() {
            return this.mListeners;
        }
    }
}

