/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.eyesfree.braille.selfbraille;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.googlecode.eyesfree.braille.selfbraille.ISelfBrailleService;
import com.googlecode.eyesfree.braille.selfbraille.WriteData;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SelfBrailleClient {
    private static final String LOG_TAG = SelfBrailleClient.class.getSimpleName();
    private static final String ACTION_SELF_BRAILLE_SERVICE = "com.googlecode.eyesfree.braille.service.ACTION_SELF_BRAILLE_SERVICE";
    private static final String BRAILLE_BACK_PACKAGE = "com.googlecode.eyesfree.brailleback";
    private static final Intent mServiceIntent = new Intent("com.googlecode.eyesfree.braille.service.ACTION_SELF_BRAILLE_SERVICE").setPackage("com.googlecode.eyesfree.brailleback");
    private static final byte[] EYES_FREE_CERT_SHA1 = new byte[]{-101, 66, 76, 45, 39, -83, 81, -92, 42, 51, 126, 11, -74, -103, 28, 118, -20, -92, 68, 97};
    private static final int REBIND_DELAY_MILLIS = 500;
    private static final int MAX_REBIND_ATTEMPTS = 5;
    private final Binder mIdentity = new Binder();
    private final Context mContext;
    private final boolean mAllowDebugService;
    private final SelfBrailleHandler mHandler = new SelfBrailleHandler();
    private boolean mShutdown = false;
    private volatile Connection mConnection;
    private int mNumFailedBinds = 0;

    public SelfBrailleClient(Context context, boolean allowDebugService) {
        this.mContext = context;
        this.mAllowDebugService = allowDebugService;
        this.doBindService();
    }

    public void shutdown() {
        this.mShutdown = true;
        this.doUnbindService();
    }

    public void write(WriteData writeData) {
        writeData.validate();
        ISelfBrailleService localService = this.getSelfBrailleService();
        if (localService != null) {
            try {
                localService.write((IBinder)this.mIdentity, writeData);
            }
            catch (RemoteException ex) {
                Log.e((String)LOG_TAG, (String)"Self braille write failed", (Throwable)ex);
            }
        }
    }

    private void doBindService() {
        Connection localConnection = new Connection();
        if (!this.mContext.bindService(mServiceIntent, (ServiceConnection)localConnection, 1)) {
            Log.e((String)LOG_TAG, (String)"Failed to bind to service");
            this.mHandler.scheduleRebind();
            return;
        }
        this.mConnection = localConnection;
        Log.i((String)LOG_TAG, (String)"Bound to self braille service");
    }

    private void doUnbindService() {
        if (this.mConnection != null) {
            ISelfBrailleService localService = this.getSelfBrailleService();
            if (localService != null) {
                try {
                    localService.disconnect((IBinder)this.mIdentity);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mContext.unbindService((ServiceConnection)this.mConnection);
            this.mConnection = null;
        }
    }

    private ISelfBrailleService getSelfBrailleService() {
        Connection localConnection = this.mConnection;
        if (localConnection != null) {
            return localConnection.mService;
        }
        return null;
    }

    private boolean verifyPackage() {
        MessageDigest digest;
        PackageInfo pi;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pi = pm.getPackageInfo(BRAILLE_BACK_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.w((String)LOG_TAG, (String)"Can't verify package com.googlecode.eyesfree.brailleback", (Throwable)ex);
            return false;
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            Log.e((String)LOG_TAG, (String)"SHA-1 not supported", (Throwable)ex);
            return false;
        }
        for (Signature signature : pi.signatures) {
            digest.update(signature.toByteArray());
            if (MessageDigest.isEqual(EYES_FREE_CERT_SHA1, digest.digest())) {
                return true;
            }
            digest.reset();
        }
        if (this.mAllowDebugService) {
            Log.w((String)LOG_TAG, (String)String.format("*** %s connected to BrailleBack with invalid (debug?) signature ***", this.mContext.getPackageName()));
            return true;
        }
        return false;
    }

    private class SelfBrailleHandler
    extends Handler {
        private static final int MSG_REBIND_SERVICE = 1;
        private static final int MSG_UNBIND_SERVICE = 2;

        private SelfBrailleHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleRebind() {
            SelfBrailleHandler selfBrailleHandler = this;
            synchronized (selfBrailleHandler) {
                if (SelfBrailleClient.this.mNumFailedBinds < 5) {
                    int delay = 500 << SelfBrailleClient.this.mNumFailedBinds;
                    this.sendEmptyMessageDelayed(1, delay);
                    ++SelfBrailleClient.this.mNumFailedBinds;
                }
            }
        }

        public void unbindService() {
            this.sendEmptyMessage(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.handleRebindService();
                    break;
                }
                case 2: {
                    this.handleUnbindService();
                }
            }
        }

        private void handleRebindService() {
            if (SelfBrailleClient.this.mShutdown) {
                return;
            }
            if (SelfBrailleClient.this.mConnection != null) {
                SelfBrailleClient.this.doUnbindService();
            }
            SelfBrailleClient.this.doBindService();
        }

        private void handleUnbindService() {
            SelfBrailleClient.this.doUnbindService();
        }
    }

    private class Connection
    implements ServiceConnection {
        private volatile ISelfBrailleService mService;

        private Connection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder binder) {
            if (!SelfBrailleClient.this.verifyPackage()) {
                Log.w((String)LOG_TAG, (String)String.format("Service certificate mismatch for %s, dropping connection", SelfBrailleClient.BRAILLE_BACK_PACKAGE));
                SelfBrailleClient.this.mHandler.unbindService();
                return;
            }
            Log.i((String)LOG_TAG, (String)"Connected to self braille service");
            this.mService = ISelfBrailleService.Stub.asInterface(binder);
            SelfBrailleHandler selfBrailleHandler = SelfBrailleClient.this.mHandler;
            synchronized (selfBrailleHandler) {
                SelfBrailleClient.this.mNumFailedBinds = 0;
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            Log.e((String)LOG_TAG, (String)"Disconnected from self braille service");
            this.mService = null;
            SelfBrailleClient.this.mHandler.scheduleRebind();
        }
    }
}

