/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base.internal;

import com.google.common.base.internal.Finalizer$ShutDown;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Finalizer
implements Runnable {
    private static final Logger logger = Logger.getLogger(Finalizer.class.getName());
    private static final String FINALIZABLE_REFERENCE = "com.google.common.base.FinalizableReference";
    private final WeakReference<Class<?>> finalizableReferenceClassReference;
    private final PhantomReference<Object> frqReference;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Field inheritableThreadLocals = Finalizer.getInheritableThreadLocalsField();

    public static ReferenceQueue<Object> startFinalizer(Class<?> object, Object object2) {
        if (!((Class)object).getName().equals(FINALIZABLE_REFERENCE)) {
            throw new IllegalArgumentException("Expected com.google.common.base.FinalizableReference.");
        }
        object = new Finalizer((Class<?>)object, object2);
        object2 = new Thread((Runnable)object);
        ((Thread)object2).setName(Finalizer.class.getName());
        ((Thread)object2).setDaemon(true);
        try {
            if (inheritableThreadLocals != null) {
                inheritableThreadLocals.set(object2, null);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "Failed to clear thread local values inherited by reference finalizer thread.", throwable);
        }
        ((Thread)object2).start();
        return ((Finalizer)object).queue;
    }

    private Finalizer(Class<?> clazz, Object object) {
        this.finalizableReferenceClassReference = new WeakReference(clazz);
        this.frqReference = new PhantomReference<Object>(object, this.queue);
    }

    @Override
    public void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        this.cleanUp(this.queue.remove());
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (Finalizer$ShutDown finalizer$ShutDown) {
            return;
        }
    }

    private void cleanUp(Reference<?> reference) {
        Method method = this.getFinalizeReferentMethod();
        do {
            reference.clear();
            if (reference == this.frqReference) {
                throw new Finalizer$ShutDown();
            }
            try {
                method.invoke(reference, new Object[0]);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Error cleaning up after reference.", throwable);
            }
        } while ((reference = this.queue.poll()) != null);
    }

    private Method getFinalizeReferentMethod() {
        Class clazz = (Class)this.finalizableReferenceClassReference.get();
        if (clazz == null) {
            throw new Finalizer$ShutDown();
        }
        try {
            return clazz.getMethod("finalizeReferent", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    public static Field getInheritableThreadLocalsField() {
        try {
            Field field = Thread.class.getDeclaredField("inheritableThreadLocals");
            field.setAccessible(true);
            return field;
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "Couldn't access Thread.inheritableThreadLocals. Reference finalizer threads will inherit thread local values.");
            return null;
        }
    }
}

