/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers$ExpiringMemoizingSupplier;
import com.google.common.base.Suppliers$MemoizingSupplier;
import com.google.common.base.Suppliers$SupplierComposition;
import com.google.common.base.Suppliers$SupplierFunction;
import com.google.common.base.Suppliers$SupplierOfInstance;
import com.google.common.base.Suppliers$ThreadSafeSupplier;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Suppliers {
    private Suppliers() {
    }

    public static <F, T> Supplier<T> compose(Function<? super F, T> function, Supplier<F> supplier) {
        Preconditions.checkNotNull(function);
        Preconditions.checkNotNull(supplier);
        return new Suppliers$SupplierComposition<F, T>(function, supplier);
    }

    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        if (supplier instanceof Suppliers$MemoizingSupplier) {
            return supplier;
        }
        return new Suppliers$MemoizingSupplier<T>(Preconditions.checkNotNull(supplier));
    }

    public static <T> Supplier<T> memoizeWithExpiration(Supplier<T> supplier, long l, TimeUnit timeUnit) {
        return new Suppliers$ExpiringMemoizingSupplier<T>(supplier, l, timeUnit);
    }

    public static <T> Supplier<T> ofInstance(T t) {
        return new Suppliers$SupplierOfInstance<T>(t);
    }

    public static <T> Supplier<T> synchronizedSupplier(Supplier<T> supplier) {
        return new Suppliers$ThreadSafeSupplier<T>(Preconditions.checkNotNull(supplier));
    }

    public static <T> Function<Supplier<T>, T> supplierFunction() {
        return Suppliers$SupplierFunction.INSTANCE;
    }
}

