/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Suppliers$ExpiringMemoizingSupplier<T>
implements Supplier<T>,
Serializable {
    final Supplier<T> delegate;
    final long durationNanos;
    volatile transient T value;
    volatile transient long expirationNanos;
    private static final long serialVersionUID = 0L;

    Suppliers$ExpiringMemoizingSupplier(Supplier<T> supplier, long l, TimeUnit timeUnit) {
        this.delegate = Preconditions.checkNotNull(supplier);
        this.durationNanos = timeUnit.toNanos(l);
        Preconditions.checkArgument(l > 0L);
    }

    @Override
    public T get() {
        long l = this.expirationNanos;
        long l2 = Platform.systemNanoTime();
        if (l == 0L || l2 - l >= 0L) {
            Suppliers$ExpiringMemoizingSupplier suppliers$ExpiringMemoizingSupplier = this;
            synchronized (suppliers$ExpiringMemoizingSupplier) {
                if (l == this.expirationNanos) {
                    T t = this.delegate.get();
                    this.value = t;
                    l = l2 + this.durationNanos;
                    this.expirationNanos = l == 0L ? 1L : l;
                    return t;
                }
            }
        }
        return this.value;
    }

    public String toString() {
        return "Suppliers.memoizeWithExpiration(" + this.delegate + ", " + this.durationNanos + ", NANOS)";
    }
}

