/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;

public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(String string2) {
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static String emptyToNull(String string2) {
        if (Strings.isNullOrEmpty(string2)) {
            return null;
        }
        return string2;
    }

    public static boolean isNullOrEmpty(String string2) {
        return string2 == null || string2.length() == 0;
    }

    public static String padStart(String string2, int n, char c) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = string2.length(); i < n; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String padEnd(String string2, int n, char c) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string2);
        for (int i = string2.length(); i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string2, int n) {
        int n2;
        Preconditions.checkNotNull(string2);
        if (n <= 1) {
            Preconditions.checkArgument(n >= 0, "invalid count: %s", n);
            if (n == 0) {
                return "";
            }
            return string2;
        }
        int n3 = string2.length();
        long l = (long)n3 * (long)n;
        n = (int)l;
        if ((long)n != l) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + String.valueOf(l));
        }
        char[] cArray = new char[n];
        string2.getChars(0, n3, cArray, 0);
        for (n2 = n3; n2 < n - n2; n2 <<= 1) {
            System.arraycopy(cArray, 0, cArray, n2, n2);
        }
        System.arraycopy(cArray, 0, cArray, n2, n - n2);
        return new String(cArray);
    }

    public static String commonPrefix(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        Preconditions.checkNotNull(charSequence);
        Preconditions.checkNotNull(charSequence2);
        int n2 = Math.min(charSequence.length(), charSequence2.length());
        for (n = 0; n < n2 && charSequence.charAt(n) == charSequence2.charAt(n); ++n) {
        }
        if (Strings.validSurrogatePairAt(charSequence, n - 1) || Strings.validSurrogatePairAt(charSequence2, n - 1)) {
            --n;
        }
        return ((Object)charSequence.subSequence(0, n)).toString();
    }

    public static String commonSuffix(CharSequence charSequence, CharSequence charSequence2) {
        int n;
        Preconditions.checkNotNull(charSequence);
        Preconditions.checkNotNull(charSequence2);
        int n2 = Math.min(charSequence.length(), charSequence2.length());
        for (n = 0; n < n2 && charSequence.charAt(charSequence.length() - n - 1) == charSequence2.charAt(charSequence2.length() - n - 1); ++n) {
        }
        if (Strings.validSurrogatePairAt(charSequence, charSequence.length() - n - 1) || Strings.validSurrogatePairAt(charSequence2, charSequence2.length() - n - 1)) {
            --n;
        }
        return ((Object)charSequence.subSequence(charSequence.length() - n, charSequence.length())).toString();
    }

    static boolean validSurrogatePairAt(CharSequence charSequence, int n) {
        return n >= 0 && n <= charSequence.length() - 2 && Character.isHighSurrogate(charSequence.charAt(n)) && Character.isLowSurrogate(charSequence.charAt(n + 1));
    }
}

