/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;

public final class Stopwatch {
    private final Ticker ticker;
    private boolean isRunning;
    private long elapsedNanos;
    private long startTick;

    public Stopwatch() {
        this(Ticker.systemTicker());
    }

    public Stopwatch(Ticker ticker) {
        this.ticker = Preconditions.checkNotNull(ticker);
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final Stopwatch start() {
        Preconditions.checkState(!this.isRunning);
        this.isRunning = true;
        this.startTick = this.ticker.read();
        return this;
    }

    public final Stopwatch stop() {
        long l = this.ticker.read();
        Preconditions.checkState(this.isRunning);
        this.isRunning = false;
        this.elapsedNanos += l - this.startTick;
        return this;
    }

    public final Stopwatch reset() {
        this.elapsedNanos = 0L;
        this.isRunning = false;
        return this;
    }

    private long elapsedNanos() {
        if (this.isRunning) {
            return this.ticker.read() - this.startTick + this.elapsedNanos;
        }
        return this.elapsedNanos;
    }

    public final long elapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public final long elapsedMillis() {
        return this.elapsedTime(TimeUnit.MILLISECONDS);
    }

    public final String toString() {
        return this.toString(4);
    }

    public final String toString(int n) {
        long l = this.elapsedNanos();
        TimeUnit timeUnit = Stopwatch.chooseUnit(l);
        double d = (double)l / (double)TimeUnit.NANOSECONDS.convert(1L, timeUnit);
        return String.format("%." + n + "g %s", d, Stopwatch.abbreviate(timeUnit));
    }

    private static TimeUnit chooseUnit(long l) {
        if (TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
        }
        throw new AssertionError();
    }
}

