/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter$1;
import com.google.common.base.Splitter$2;
import com.google.common.base.Splitter$3;
import com.google.common.base.Splitter$4;
import com.google.common.base.Splitter$5;
import com.google.common.base.Splitter$MapSplitter;
import com.google.common.base.Splitter$Strategy;
import java.util.Iterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Splitter$Strategy strategy;
    private final int limit;

    private Splitter(Splitter$Strategy splitter$Strategy) {
        this(splitter$Strategy, false, CharMatcher.NONE, Integer.MAX_VALUE);
    }

    private Splitter(Splitter$Strategy splitter$Strategy, boolean bl, CharMatcher charMatcher, int n) {
        this.strategy = splitter$Strategy;
        this.omitEmptyStrings = bl;
        this.trimmer = charMatcher;
        this.limit = n;
    }

    public static Splitter on(char c) {
        return Splitter.on(CharMatcher.is(c));
    }

    public static Splitter on(CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(new Splitter$1(charMatcher));
    }

    public static Splitter on(String string2) {
        Preconditions.checkArgument(string2.length() != 0, "The separator may not be the empty string.");
        return new Splitter(new Splitter$2(string2));
    }

    public static Splitter on(Pattern pattern) {
        Preconditions.checkNotNull(pattern);
        Preconditions.checkArgument(!pattern.matcher("").matches(), "The pattern may not match the empty string: %s", pattern);
        return new Splitter(new Splitter$3(pattern));
    }

    public static Splitter onPattern(String string2) {
        return Splitter.on(Pattern.compile(string2));
    }

    public static Splitter fixedLength(int n) {
        Preconditions.checkArgument(n > 0, "The length may not be less than 1");
        return new Splitter(new Splitter$4(n));
    }

    public final Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    public final Splitter limit(int n) {
        Preconditions.checkArgument(n > 0, "must be greater than zero: %s", n);
        return new Splitter(this.strategy, this.omitEmptyStrings, this.trimmer, n);
    }

    public final Splitter trimResults() {
        return this.trimResults(CharMatcher.WHITESPACE);
    }

    public final Splitter trimResults(CharMatcher charMatcher) {
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(this.strategy, this.omitEmptyStrings, charMatcher, this.limit);
    }

    public final Iterable<String> split(CharSequence charSequence) {
        Preconditions.checkNotNull(charSequence);
        return new Splitter$5(this, charSequence);
    }

    private Iterator<String> spliterator(CharSequence charSequence) {
        return this.strategy.iterator(this, charSequence);
    }

    public final Splitter$MapSplitter withKeyValueSeparator(String string2) {
        return this.withKeyValueSeparator(Splitter.on(string2));
    }

    public final Splitter$MapSplitter withKeyValueSeparator(Splitter splitter) {
        return new Splitter$MapSplitter(this, splitter);
    }

    static /* synthetic */ Iterator access$000(Splitter splitter, CharSequence charSequence) {
        return splitter.spliterator(charSequence);
    }

    static /* synthetic */ CharMatcher access$200(Splitter splitter) {
        return splitter.trimmer;
    }

    static /* synthetic */ boolean access$300(Splitter splitter) {
        return splitter.omitEmptyStrings;
    }

    static /* synthetic */ int access$400(Splitter splitter) {
        return splitter.limit;
    }
}

