/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CharMatcher;

final class SmallCharMatcher
extends CharMatcher {
    static final int MAX_SIZE = 63;
    static final int MAX_TABLE_SIZE = 128;
    private final boolean reprobe;
    private final char[] table;
    private final boolean containsZero;
    final long filter;

    private SmallCharMatcher(char[] cArray, long l, boolean bl, boolean bl2, String string2) {
        super(string2);
        this.table = cArray;
        this.filter = l;
        this.containsZero = bl;
        this.reprobe = bl2;
    }

    private boolean checkFilter(int n) {
        return 1L == (1L & this.filter >> n);
    }

    public final CharMatcher precomputed() {
        return this;
    }

    static char[] buildTable(int n, char[] cArray, boolean bl) {
        char[] cArray2 = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            int n2 = c % n;
            if (n2 < 0) {
                n2 += n;
            }
            if (cArray2[n2] != '\u0000' && !bl) {
                return null;
            }
            if (bl) {
                while (cArray2[n2] != '\u0000') {
                    n2 = (n2 + 1) % n;
                }
            }
            cArray2[n2] = c;
        }
        return cArray2;
    }

    static CharMatcher from(char[] cArray, String string2) {
        long l = 0L;
        int n = cArray.length;
        boolean bl = false;
        boolean bl2 = cArray[0] == '\u0000';
        char[] cArray2 = cArray;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            char c = cArray2[i];
            l |= 1L << c;
        }
        cArray2 = null;
        for (n2 = n; n2 < 128 && (cArray2 = SmallCharMatcher.buildTable(n2, cArray, false)) == null; ++n2) {
        }
        if (cArray2 == null) {
            cArray2 = SmallCharMatcher.buildTable(128, cArray, true);
            bl = true;
        }
        return new SmallCharMatcher(cArray2, l, bl2, bl, string2);
    }

    public final boolean matches(char c) {
        if (c == '\u0000') {
            return this.containsZero;
        }
        if (!this.checkFilter(c)) {
            return false;
        }
        int n = c % this.table.length;
        if (n < 0) {
            n += this.table.length;
        }
        while (true) {
            if (this.table[n] == '\u0000') {
                return false;
            }
            if (this.table[n] == c) {
                return true;
            }
            if (!this.reprobe) break;
            n = (n + 1) % this.table.length;
        }
        return false;
    }
}

