/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Present<T>
extends Optional<T> {
    private final T reference;
    private static final long serialVersionUID = 0L;

    Present(T t) {
        this.reference = t;
    }

    @Override
    public final boolean isPresent() {
        return true;
    }

    @Override
    public final T get() {
        return this.reference;
    }

    @Override
    public final T or(T t) {
        Preconditions.checkNotNull(t, "use orNull() instead of or(null)");
        return this.reference;
    }

    @Override
    public final Optional<T> or(Optional<? extends T> optional) {
        Preconditions.checkNotNull(optional);
        return this;
    }

    @Override
    public final T or(Supplier<? extends T> supplier) {
        Preconditions.checkNotNull(supplier);
        return this.reference;
    }

    @Override
    public final T orNull() {
        return this.reference;
    }

    @Override
    public final Set<T> asSet() {
        return Collections.singleton(this.reference);
    }

    @Override
    public final <V> Optional<V> transform(Function<? super T, V> function) {
        return new Present<V>(Preconditions.checkNotNull(function.apply(this.reference), "Transformation function cannot return null."));
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof Present) {
            object = (Present)object;
            return this.reference.equals(((Present)object).reference);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return 1502476572 + this.reference.hashCode();
    }

    @Override
    public final String toString() {
        return "Optional.of(" + this.reference + ")";
    }
}

