/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates$AndPredicate;
import com.google.common.base.Predicates$AssignableFromPredicate;
import com.google.common.base.Predicates$CompositionPredicate;
import com.google.common.base.Predicates$ContainsPatternPredicate;
import com.google.common.base.Predicates$InPredicate;
import com.google.common.base.Predicates$InstanceOfPredicate;
import com.google.common.base.Predicates$IsEqualToPredicate;
import com.google.common.base.Predicates$NotPredicate;
import com.google.common.base.Predicates$ObjectPredicate;
import com.google.common.base.Predicates$OrPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Predicates {
    private static final Joiner COMMA_JOINER = Joiner.on(",");

    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return Predicates$ObjectPredicate.ALWAYS_TRUE.withNarrowedType();
    }

    public static <T> Predicate<T> alwaysFalse() {
        return Predicates$ObjectPredicate.ALWAYS_FALSE.withNarrowedType();
    }

    public static <T> Predicate<T> isNull() {
        return Predicates$ObjectPredicate.IS_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> notNull() {
        return Predicates$ObjectPredicate.NOT_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new Predicates$NotPredicate<T>(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> iterable) {
        return new Predicates$AndPredicate(Predicates.defensiveCopy(iterable), null);
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        return new Predicates$AndPredicate(Predicates.defensiveCopy(predicateArray), null);
    }

    public static <T> Predicate<T> and(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new Predicates$AndPredicate(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)), null);
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> iterable) {
        return new Predicates$OrPredicate(Predicates.defensiveCopy(iterable), null);
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        return new Predicates$OrPredicate(Predicates.defensiveCopy(predicateArray), null);
    }

    public static <T> Predicate<T> or(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new Predicates$OrPredicate(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)), null);
    }

    public static <T> Predicate<T> equalTo(T t) {
        if (t == null) {
            return Predicates.isNull();
        }
        return new Predicates$IsEqualToPredicate(t, null);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new Predicates$InstanceOfPredicate(clazz, null);
    }

    public static Predicate<Class<?>> assignableFrom(Class<?> clazz) {
        return new Predicates$AssignableFromPredicate(clazz, null);
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return new Predicates$InPredicate(collection, null);
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new Predicates$CompositionPredicate(predicate, function, null);
    }

    public static Predicate<CharSequence> containsPattern(String string2) {
        return new Predicates$ContainsPatternPredicate(string2);
    }

    public static Predicate<CharSequence> contains(Pattern pattern) {
        return new Predicates$ContainsPatternPredicate(pattern);
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return Arrays.asList(predicate, predicate2);
    }

    private static <T> List<T> defensiveCopy(T ... TArray) {
        return Predicates.defensiveCopy(Arrays.asList(TArray));
    }

    static <T> List<T> defensiveCopy(Iterable<T> object) {
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            arrayList.add(Preconditions.checkNotNull(e));
        }
        return arrayList;
    }

    static /* synthetic */ Joiner access$800() {
        return COMMA_JOINER;
    }
}

