/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PairwiseEquivalence<T>
extends Equivalence<Iterable<T>>
implements Serializable {
    final Equivalence<? super T> elementEquivalence;
    private static final long serialVersionUID = 1L;

    PairwiseEquivalence(Equivalence<? super T> equivalence) {
        this.elementEquivalence = Preconditions.checkNotNull(equivalence);
    }

    @Override
    protected final boolean doEquivalent(Iterable<T> object, Iterable<T> object2) {
        object = object.iterator();
        object2 = object2.iterator();
        while (object.hasNext() && object2.hasNext()) {
            if (this.elementEquivalence.equivalent(object.next(), object2.next())) continue;
            return false;
        }
        return !object.hasNext() && !object2.hasNext();
    }

    @Override
    protected final int doHash(Iterable<T> object) {
        int n = 78721;
        object = object.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            n = n * 24943 + this.elementEquivalence.hash(e);
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (object instanceof PairwiseEquivalence) {
            object = (PairwiseEquivalence)object;
            return this.elementEquivalence.equals(((PairwiseEquivalence)object).elementEquivalence);
        }
        return false;
    }

    public final int hashCode() {
        return this.elementEquivalence.hashCode() ^ 0x46A3EB07;
    }

    public final String toString() {
        return this.elementEquivalence + ".pairwise()";
    }
}

