/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Absent;
import com.google.common.base.Function;
import com.google.common.base.Optional$1;
import com.google.common.base.Preconditions;
import com.google.common.base.Present;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> Optional<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> Optional<T> of(T t) {
        return new Present<T>(Preconditions.checkNotNull(t));
    }

    public static <T> Optional<T> fromNullable(T t) {
        if (t == null) {
            return Optional.absent();
        }
        return new Present<T>(t);
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    public abstract T or(Supplier<? extends T> var1);

    public abstract T orNull();

    public abstract Set<T> asSet();

    public abstract <V> Optional<V> transform(Function<? super T, V> var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static <T> Iterable<T> presentInstances(Iterable<? extends Optional<? extends T>> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Optional$1(iterable);
    }
}

