/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CharMatcher;

final class MediumCharMatcher
extends CharMatcher {
    static final int MAX_SIZE = 1023;
    private final char[] table;
    private final boolean containsZero;
    private final long filter;
    private static final double DESIRED_LOAD_FACTOR = 0.5;

    private MediumCharMatcher(char[] cArray, long l, boolean bl, String string2) {
        super(string2);
        this.table = cArray;
        this.filter = l;
        this.containsZero = bl;
    }

    private boolean checkFilter(int n) {
        return 1L == (1L & this.filter >> n);
    }

    static int chooseTableSize(int n) {
        if (n == 1) {
            return 2;
        }
        int n2 = Integer.highestOneBit(n - 1) << 1;
        while ((double)n2 * 0.5 < (double)n) {
            n2 <<= 1;
        }
        return n2;
    }

    public final CharMatcher precomputed() {
        return this;
    }

    static CharMatcher from(char[] cArray, String string2) {
        int n;
        long l = 0L;
        int n2 = cArray.length;
        boolean bl = cArray[0] == '\u0000';
        char[] cArray2 = cArray;
        int n3 = cArray.length;
        for (int i = 0; i < n3; ++i) {
            n = cArray2[i];
            l |= 1L << n;
        }
        cArray2 = new char[MediumCharMatcher.chooseTableSize(n2)];
        n3 = cArray2.length - 1;
        char[] cArray3 = cArray;
        n = cArray.length;
        for (int i = 0; i < n; ++i) {
            n2 = cArray3[i];
            int n4 = n2 & n3;
            while (true) {
                if (cArray2[n4] == '\u0000') break;
                n4 = n4 + 1 & n3;
            }
            cArray2[n4] = n2;
        }
        return new MediumCharMatcher(cArray2, l, bl, string2);
    }

    public final boolean matches(char c) {
        int n;
        if (c == '\u0000') {
            return this.containsZero;
        }
        if (!this.checkFilter(c)) {
            return false;
        }
        int n2 = this.table.length - 1;
        int n3 = n = c & n2;
        do {
            if (this.table[n3] == '\u0000') {
                return false;
            }
            if (this.table[n3] != c) continue;
            return true;
        } while ((n3 = n3 + 1 & n2) != n);
        return false;
    }
}

