/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Joiner$1;
import com.google.common.base.Joiner$2;
import com.google.common.base.Joiner$3;
import com.google.common.base.Joiner$MapJoiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Joiner {
    private final String separator;

    public static Joiner on(String string2) {
        return new Joiner(string2);
    }

    public static Joiner on(char c) {
        return new Joiner(String.valueOf(c));
    }

    private Joiner(String string2) {
        this.separator = Preconditions.checkNotNull(string2);
    }

    private Joiner(Joiner joiner) {
        this.separator = joiner.separator;
    }

    public final <A extends Appendable, I extends Object & Iterator<?>> A appendTo(A a, I i) {
        return this.appendTo(a, (Iterator<?>)i);
    }

    public <A extends Appendable> A appendTo(A a, Iterable<?> iterable) {
        return this.appendTo(a, iterable.iterator());
    }

    public <A extends Appendable> A appendTo(A a, Iterator<?> iterator) {
        Preconditions.checkNotNull(a);
        if (iterator.hasNext()) {
            a.append(this.toString(iterator.next()));
            while (iterator.hasNext()) {
                a.append(this.separator);
                a.append(this.toString(iterator.next()));
            }
        }
        return a;
    }

    public final <A extends Appendable> A appendTo(A a, Object[] objectArray) {
        return this.appendTo(a, Arrays.asList(objectArray));
    }

    public final <A extends Appendable> A appendTo(A a, Object object, Object object2, Object ... objectArray) {
        return this.appendTo(a, Joiner.iterable(object, object2, objectArray));
    }

    public final <I extends Object & Iterator<?>> StringBuilder appendTo(StringBuilder stringBuilder, I i) {
        return this.appendTo(stringBuilder, (Iterator<?>)i);
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterable<?> iterable) {
        return this.appendTo(stringBuilder, iterable.iterator());
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterator<?> iterator) {
        try {
            this.appendTo((Appendable)stringBuilder, iterator);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder;
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Object[] objectArray) {
        return this.appendTo(stringBuilder, (Iterable<?>)Arrays.asList(objectArray));
    }

    public final StringBuilder appendTo(StringBuilder stringBuilder, Object object, Object object2, Object ... objectArray) {
        return this.appendTo(stringBuilder, Joiner.iterable(object, object2, objectArray));
    }

    public final <I extends Object & Iterator<?>> String join(I i) {
        return this.join((Iterator<?>)i);
    }

    public final String join(Iterable<?> iterable) {
        return this.join(iterable.iterator());
    }

    public final String join(Iterator<?> iterator) {
        return this.appendTo(new StringBuilder(), iterator).toString();
    }

    public final String join(Object[] objectArray) {
        return this.join(Arrays.asList(objectArray));
    }

    public final String join(Object object, Object object2, Object ... objectArray) {
        return this.join(Joiner.iterable(object, object2, objectArray));
    }

    public Joiner useForNull(String string2) {
        Preconditions.checkNotNull(string2);
        return new Joiner$1(this, this, string2);
    }

    public Joiner skipNulls() {
        return new Joiner$2(this, this);
    }

    public Joiner$MapJoiner withKeyValueSeparator(String string2) {
        return new Joiner$MapJoiner(this, string2, null);
    }

    CharSequence toString(Object object) {
        Preconditions.checkNotNull(object);
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        return object.toString();
    }

    private static Iterable<Object> iterable(Object object, Object object2, Object[] objectArray) {
        Preconditions.checkNotNull(objectArray);
        return new Joiner$3(objectArray, object, object2);
    }

    /* synthetic */ Joiner(Joiner joiner, Joiner$1 joiner$1) {
        this(joiner);
    }

    static /* synthetic */ String access$100(Joiner joiner) {
        return joiner.separator;
    }
}

