/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Functions$ConstantFunction;
import com.google.common.base.Functions$ForMapWithDefault;
import com.google.common.base.Functions$FunctionComposition;
import com.google.common.base.Functions$FunctionForMapNoDefault;
import com.google.common.base.Functions$IdentityFunction;
import com.google.common.base.Functions$PredicateFunction;
import com.google.common.base.Functions$SupplierFunction;
import com.google.common.base.Functions$ToStringFunction;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions {
    private Functions() {
    }

    public static Function<Object, String> toStringFunction() {
        return Functions$ToStringFunction.INSTANCE;
    }

    public static <E> Function<E, E> identity() {
        return Functions$IdentityFunction.INSTANCE;
    }

    public static <K, V> Function<K, V> forMap(Map<K, V> map) {
        return new Functions$FunctionForMapNoDefault<K, V>(map);
    }

    public static <K, V> Function<K, V> forMap(Map<K, ? extends V> map, V v) {
        return new Functions$ForMapWithDefault<K, V>(map, v);
    }

    public static <A, B, C> Function<A, C> compose(Function<B, C> function, Function<A, ? extends B> function2) {
        return new Functions$FunctionComposition<A, B, C>(function, function2);
    }

    public static <T> Function<T, Boolean> forPredicate(Predicate<T> predicate) {
        return new Functions$PredicateFunction(predicate, null);
    }

    public static <E> Function<Object, E> constant(E e) {
        return new Functions$ConstantFunction<E>(e);
    }

    public static <T> Function<Object, T> forSupplier(Supplier<T> supplier) {
        return new Functions$SupplierFunction(supplier, null);
    }
}

