/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.FinalizableReference;
import com.google.common.base.FinalizableReferenceQueue$DecoupledLoader;
import com.google.common.base.FinalizableReferenceQueue$DirectLoader;
import com.google.common.base.FinalizableReferenceQueue$FinalizerLoader;
import com.google.common.base.FinalizableReferenceQueue$SystemLoader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinalizableReferenceQueue {
    private static final Logger logger = Logger.getLogger(FinalizableReferenceQueue.class.getName());
    private static final String FINALIZER_CLASS_NAME = "com.google.common.base.internal.Finalizer";
    private static final Method startFinalizer;
    final ReferenceQueue<Object> queue;
    final boolean threadStarted;

    public FinalizableReferenceQueue() {
        ReferenceQueue referenceQueue;
        boolean bl = false;
        try {
            referenceQueue = (ReferenceQueue)startFinalizer.invoke(null, FinalizableReference.class, this);
            bl = true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "Failed to start reference finalizer thread. Reference cleanup will only occur when new references are created.", throwable);
            referenceQueue = new ReferenceQueue();
        }
        this.queue = referenceQueue;
        this.threadStarted = bl;
    }

    void cleanUp() {
        Reference<Object> reference;
        if (this.threadStarted) {
            return;
        }
        while ((reference = this.queue.poll()) != null) {
            reference.clear();
            try {
                ((FinalizableReference)((Object)reference)).finalizeReferent();
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Error cleaning up after reference.", throwable);
            }
        }
    }

    private static Class<?> loadFinalizer(FinalizableReferenceQueue$FinalizerLoader ... finalizableReferenceQueue$FinalizerLoaderArray) {
        for (FinalizableReferenceQueue$FinalizerLoader finalizableReferenceQueue$FinalizerLoader : finalizableReferenceQueue$FinalizerLoaderArray) {
            Class<?> object = finalizableReferenceQueue$FinalizerLoader.loadFinalizer();
            if (object == null) continue;
            return object;
        }
        throw new AssertionError();
    }

    static Method getStartFinalizer(Class<?> clazz) {
        try {
            return clazz.getMethod("startFinalizer", Class.class, Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static {
        Class<?> clazz = FinalizableReferenceQueue.loadFinalizer(new FinalizableReferenceQueue$SystemLoader(), new FinalizableReferenceQueue$DecoupledLoader(), new FinalizableReferenceQueue$DirectLoader());
        startFinalizer = FinalizableReferenceQueue.getStartFinalizer(clazz);
    }
}

