/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableReferenceQueue$FinalizerLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FinalizableReferenceQueue$DecoupledLoader
implements FinalizableReferenceQueue$FinalizerLoader {
    private static final String LOADING_ERROR = "Could not load Finalizer in its own class loader.Loading Finalizer in the current class loader instead. As a result, you will not be ableto garbage collect this class loader. To support reclaiming this class loader, eitherresolve the underlying issue, or move Google Collections to your system class path.";

    FinalizableReferenceQueue$DecoupledLoader() {
    }

    @Override
    public Class<?> loadFinalizer() {
        try {
            URLClassLoader uRLClassLoader = this.newLoader(this.getBaseUrl());
            return uRLClassLoader.loadClass("com.google.common.base.internal.Finalizer");
        }
        catch (Exception exception) {
            FinalizableReferenceQueue.access$000().log(Level.WARNING, LOADING_ERROR, exception);
            return null;
        }
    }

    URL getBaseUrl() {
        String string2 = "com.google.common.base.internal.Finalizer".replace('.', '/') + ".class";
        URL uRL = this.getClass().getClassLoader().getResource(string2);
        if (uRL == null) {
            throw new FileNotFoundException(string2);
        }
        String string3 = uRL.toString();
        if (!string3.endsWith(string2)) {
            throw new IOException("Unsupported path style: " + string3);
        }
        string3 = string3.substring(0, string3.length() - string2.length());
        return new URL(uRL, string3);
    }

    URLClassLoader newLoader(URL uRL) {
        return new URLClassLoader(new URL[]{uRL}, null);
    }
}

