/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Equivalence$Equals;
import com.google.common.base.Equivalence$EquivalentToPredicate;
import com.google.common.base.Equivalence$Identity;
import com.google.common.base.Equivalence$Wrapper;
import com.google.common.base.Function;
import com.google.common.base.FunctionalEquivalence;
import com.google.common.base.PairwiseEquivalence;
import com.google.common.base.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Equivalence<T> {
    protected Equivalence() {
    }

    public final boolean equivalent(T t, T t2) {
        if (t == t2) {
            return true;
        }
        if (t == null || t2 == null) {
            return false;
        }
        return this.doEquivalent(t, t2);
    }

    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(T t) {
        if (t == null) {
            return 0;
        }
        return this.doHash(t);
    }

    protected abstract int doHash(T var1);

    public final <F> Equivalence<F> onResultOf(Function<F, ? extends T> function) {
        return new FunctionalEquivalence<F, T>(function, this);
    }

    public final <S extends T> Equivalence$Wrapper<S> wrap(S s) {
        return new Equivalence$Wrapper(this, s);
    }

    public final <S extends T> Equivalence<Iterable<S>> pairwise() {
        return new PairwiseEquivalence(this);
    }

    public final Predicate<T> equivalentTo(T t) {
        return new Equivalence$EquivalentToPredicate<T>(this, t);
    }

    public static Equivalence<Object> equals() {
        return Equivalence$Equals.INSTANCE;
    }

    public static Equivalence<Object> identity() {
        return Equivalence$Identity.INSTANCE;
    }
}

