/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Equivalence$EquivalentToPredicate<T>
implements Predicate<T>,
Serializable {
    private final Equivalence<T> equivalence;
    private final T target;
    private static final long serialVersionUID = 0L;

    Equivalence$EquivalentToPredicate(Equivalence<T> equivalence, T t) {
        this.equivalence = Preconditions.checkNotNull(equivalence);
        this.target = t;
    }

    @Override
    public final boolean apply(T t) {
        return this.equivalence.equivalent(t, this.target);
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Equivalence$EquivalentToPredicate) {
            object = (Equivalence$EquivalentToPredicate)object;
            return this.equivalence.equals(((Equivalence$EquivalentToPredicate)object).equivalence) && Objects.equal(this.target, ((Equivalence$EquivalentToPredicate)object).target);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.equivalence, this.target);
    }

    public final String toString() {
        return this.equivalence + ".equivalentTo(" + this.target + ")";
    }
}

