/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Enums$ValueOfFunction;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Enums {
    private Enums() {
    }

    public static Field getField(Enum<?> enum_) {
        Class<?> clazz = enum_.getDeclaringClass();
        try {
            return clazz.getDeclaredField(enum_.name());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)noSuchFieldException);
        }
    }

    public static <T extends Enum<T>> Function<String, T> valueOfFunction(Class<T> clazz) {
        return new Enums$ValueOfFunction(clazz, null);
    }

    public static <T extends Enum<T>> Optional<T> getIfPresent(Class<T> clazz, String string2) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(string2);
        try {
            return Optional.of(Enum.valueOf(clazz, string2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.absent();
        }
    }
}

