/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.CharMatcher$1;
import com.google.common.base.CharMatcher$10;
import com.google.common.base.CharMatcher$11;
import com.google.common.base.CharMatcher$12;
import com.google.common.base.CharMatcher$13;
import com.google.common.base.CharMatcher$14;
import com.google.common.base.CharMatcher$15;
import com.google.common.base.CharMatcher$16;
import com.google.common.base.CharMatcher$2;
import com.google.common.base.CharMatcher$3;
import com.google.common.base.CharMatcher$4;
import com.google.common.base.CharMatcher$5;
import com.google.common.base.CharMatcher$6;
import com.google.common.base.CharMatcher$7;
import com.google.common.base.CharMatcher$8;
import com.google.common.base.CharMatcher$9;
import com.google.common.base.CharMatcher$And;
import com.google.common.base.CharMatcher$LookupTable;
import com.google.common.base.CharMatcher$Or;
import com.google.common.base.MediumCharMatcher;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.SmallCharMatcher;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharMatcher
implements Predicate<Character> {
    public static final CharMatcher BREAKING_WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000").or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200a')).withToString("CharMatcher.BREAKING_WHITESPACE").precomputed();
    public static final CharMatcher ASCII = CharMatcher.inRange('\u0000', '\u007f', "CharMatcher.ASCII");
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;
    final String description;
    public static final CharMatcher WHITESPACE;

    public static CharMatcher is(char c) {
        String string2 = "CharMatcher.is(" + Integer.toHexString(c) + ")";
        return new CharMatcher$8(string2, c);
    }

    public static CharMatcher isNot(char c) {
        String string2 = "CharMatcher.isNot(" + Integer.toHexString(c) + ")";
        return new CharMatcher$9(string2, c);
    }

    public static CharMatcher anyOf(CharSequence charSequence) {
        switch (charSequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(charSequence.charAt(0));
            }
            case 2: {
                char c = charSequence.charAt(0);
                char c2 = charSequence.charAt(1);
                return new CharMatcher$10("CharMatcher.anyOf(\"" + charSequence + "\")", c, c2);
            }
        }
        char[] cArray = ((Object)charSequence).toString().toCharArray();
        Arrays.sort(cArray);
        return new CharMatcher$11("CharMatcher.anyOf(\"" + cArray + "\")", cArray);
    }

    public static CharMatcher noneOf(CharSequence charSequence) {
        return CharMatcher.anyOf(charSequence).negate();
    }

    public static CharMatcher inRange(char c, char c2) {
        Preconditions.checkArgument(c2 >= c);
        String string2 = "CharMatcher.inRange(" + Integer.toHexString(c) + ", " + Integer.toHexString(c2) + ")";
        return CharMatcher.inRange(c, c2, string2);
    }

    static CharMatcher inRange(char c, char c2, String string2) {
        return new CharMatcher$12(string2, c, c2);
    }

    public static CharMatcher forPredicate(Predicate<? super Character> predicate) {
        Preconditions.checkNotNull(predicate);
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        String string2 = "CharMatcher.forPredicate(" + predicate + ')';
        return new CharMatcher$13(string2, predicate);
    }

    CharMatcher(String string2) {
        this.description = string2;
    }

    protected CharMatcher() {
        this.description = "UnknownCharMatcher";
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        CharMatcher charMatcher = this;
        return new CharMatcher$14(this, charMatcher + ".negate()", charMatcher);
    }

    public CharMatcher and(CharMatcher charMatcher) {
        return new CharMatcher$And(this, Preconditions.checkNotNull(charMatcher));
    }

    public CharMatcher or(CharMatcher charMatcher) {
        return new CharMatcher$Or(this, Preconditions.checkNotNull(charMatcher));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    char[] slowGetChars() {
        char[] cArray = new char[65536];
        int n = 0;
        for (int i = 0; i <= 65535; ++i) {
            if (!this.matches((char)i)) continue;
            cArray[n++] = (char)i;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    CharMatcher precomputedInternal() {
        Object object = this.slowGetChars();
        int n = ((char[])object).length;
        if (n == 0) {
            return NONE;
        }
        if (n == 1) {
            return CharMatcher.is(object[0]);
        }
        if (n < 63) {
            return SmallCharMatcher.from(object, this.toString());
        }
        if (n < 1023) {
            return MediumCharMatcher.from(object, this.toString());
        }
        object = new CharMatcher$LookupTable(null);
        this.setBits((CharMatcher$LookupTable)object);
        CharMatcher charMatcher = this;
        return new CharMatcher$15(this, charMatcher.toString(), (CharMatcher$LookupTable)object);
    }

    CharMatcher withToString(String string2) {
        throw new UnsupportedOperationException();
    }

    void setBits(CharMatcher$LookupTable charMatcher$LookupTable) {
        char c;
        char c2 = '\u0000';
        do {
            if (this.matches(c2)) {
                charMatcher$LookupTable.set(c2);
            }
            c = c2;
            c2 = (char)(c2 + '\u0001');
        } while (c != 65535);
    }

    public boolean matchesAnyOf(CharSequence charSequence) {
        return !this.matchesNoneOf(charSequence);
    }

    public boolean matchesAllOf(CharSequence charSequence) {
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            if (this.matches(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence charSequence) {
        return this.indexIn(charSequence) == -1;
    }

    public int indexIn(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (!this.matches(charSequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int indexIn(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        Preconditions.checkPositionIndex(n, n2);
        while (n < n2) {
            if (this.matches(charSequence.charAt(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence charSequence) {
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            if (!this.matches(charSequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public int countIn(CharSequence charSequence) {
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (!this.matches(charSequence.charAt(i))) continue;
            ++n;
        }
        return n;
    }

    public String removeFrom(CharSequence object) {
        int n = this.indexIn((CharSequence)(object = object.toString()));
        if (n == -1) {
            return object;
        }
        object = ((String)object).toCharArray();
        int n2 = 1;
        while (++n != ((Object)object).length) {
            if (!this.matches((char)object[n])) {
                object[n - n2] = object[n];
                continue;
            }
            ++n2;
        }
        return new String((char[])object, 0, n - n2);
    }

    public String retainFrom(CharSequence charSequence) {
        return this.negate().removeFrom(charSequence);
    }

    public String replaceFrom(CharSequence object, char c) {
        int n = this.indexIn((CharSequence)(object = object.toString()));
        if (n == -1) {
            return object;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        cArray[n] = c;
        ++n;
        while (n < ((Object)object).length) {
            if (this.matches((char)object[n])) {
                object[n] = c;
            }
            ++n;
        }
        return new String((char[])object);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence2.length();
        if (n == 0) {
            return this.removeFrom(charSequence);
        }
        if (n == 1) {
            return this.replaceFrom(charSequence, charSequence2.charAt(0));
        }
        n = this.indexIn(charSequence = ((Object)charSequence).toString());
        if (n == -1) {
            return charSequence;
        }
        int n2 = ((String)charSequence).length();
        StringBuilder stringBuilder = new StringBuilder(n2 * 3 / 2 + 16);
        int n3 = 0;
        do {
            stringBuilder.append(charSequence, n3, n);
            stringBuilder.append(charSequence2);
        } while ((n = this.indexIn(charSequence, n3 = n + 1)) != -1);
        stringBuilder.append(charSequence, n3, n2);
        return stringBuilder.toString();
    }

    public String trimFrom(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        for (n = 0; n < n2 && this.matches(charSequence.charAt(n)); ++n) {
        }
        --n2;
        while (n2 > n && this.matches(charSequence.charAt(n2))) {
            --n2;
        }
        return ((Object)charSequence.subSequence(n, n2 + 1)).toString();
    }

    public String trimLeadingFrom(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        for (n = 0; n < n2 && this.matches(charSequence.charAt(n)); ++n) {
        }
        return ((Object)charSequence.subSequence(n, n2)).toString();
    }

    public String trimTrailingFrom(CharSequence charSequence) {
        int n = charSequence.length();
        --n;
        while (n >= 0 && this.matches(charSequence.charAt(n))) {
            --n;
        }
        return ((Object)charSequence.subSequence(0, n + 1)).toString();
    }

    public String collapseFrom(CharSequence charSequence, char c) {
        int n = this.indexIn(charSequence);
        if (n == -1) {
            return ((Object)charSequence).toString();
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length()).append(charSequence.subSequence(0, n)).append(c);
        boolean bl = true;
        ++n;
        while (n < charSequence.length()) {
            char c2 = charSequence.charAt(n);
            if (this.matches(c2)) {
                if (!bl) {
                    stringBuilder.append(c);
                    bl = true;
                }
            } else {
                stringBuilder.append(c2);
                bl = false;
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public String trimAndCollapseFrom(CharSequence charSequence, char c) {
        int n = this.negate().indexIn(charSequence);
        if (n == -1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length());
        boolean bl = false;
        while (n < charSequence.length()) {
            char c2 = charSequence.charAt(n);
            if (this.matches(c2)) {
                bl = true;
            } else {
                if (bl) {
                    stringBuilder.append(c);
                    bl = false;
                }
                stringBuilder.append(c2);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean apply(Character c) {
        return this.matches(c.charValue());
    }

    public String toString() {
        return this.description;
    }

    static {
        CharMatcher charMatcher = CharMatcher.inRange('0', '9');
        Object object = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        char[] cArray = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".toCharArray();
        object = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = object[i];
            charMatcher = charMatcher.or(CharMatcher.inRange((char)object2, (char)(object2 + 9)));
        }
        DIGIT = charMatcher.withToString("CharMatcher.DIGIT").precomputed();
        JAVA_DIGIT = new CharMatcher$1("CharMatcher.JAVA_DIGIT");
        JAVA_LETTER = new CharMatcher$2("CharMatcher.JAVA_LETTER");
        JAVA_LETTER_OR_DIGIT = new CharMatcher$3("CharMatcher.JAVA_LETTER_OR_DIGIT");
        JAVA_UPPER_CASE = new CharMatcher$4("CharMatcher.JAVA_UPPER_CASE");
        JAVA_LOWER_CASE = new CharMatcher$5("CharMatcher.JAVA_LOWER_CASE");
        JAVA_ISO_CONTROL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f')).withToString("CharMatcher.JAVA_ISO_CONTROL");
        INVISIBLE = CharMatcher.inRange('\u0000', ' ').or(CharMatcher.inRange('\u007f', '\u00a0')).or(CharMatcher.is('\u00ad')).or(CharMatcher.inRange('\u0600', '\u0604')).or(CharMatcher.anyOf("\u06dd\u070f\u1680\u180e")).or(CharMatcher.inRange('\u2000', '\u200f')).or(CharMatcher.inRange('\u2028', '\u202f')).or(CharMatcher.inRange('\u205f', '\u2064')).or(CharMatcher.inRange('\u206a', '\u206f')).or(CharMatcher.is('\u3000')).or(CharMatcher.inRange('\ud800', '\uf8ff')).or(CharMatcher.anyOf("\ufeff\ufff9\ufffa\ufffb")).withToString("CharMatcher.INVISIBLE").precomputed();
        SINGLE_WIDTH = CharMatcher.inRange('\u0000', '\u04f9').or(CharMatcher.is('\u05be')).or(CharMatcher.inRange('\u05d0', '\u05ea')).or(CharMatcher.is('\u05f3')).or(CharMatcher.is('\u05f4')).or(CharMatcher.inRange('\u0600', '\u06ff')).or(CharMatcher.inRange('\u0750', '\u077f')).or(CharMatcher.inRange('\u0e00', '\u0e7f')).or(CharMatcher.inRange('\u1e00', '\u20af')).or(CharMatcher.inRange('\u2100', '\u213a')).or(CharMatcher.inRange('\ufb50', '\ufdff')).or(CharMatcher.inRange('\ufe70', '\ufeff')).or(CharMatcher.inRange('\uff61', '\uffdc')).withToString("CharMatcher.SINGLE_WIDTH").precomputed();
        ANY = new CharMatcher$6("CharMatcher.ANY");
        NONE = new CharMatcher$7("CharMatcher.NONE");
        WHITESPACE = new CharMatcher$16("CharMatcher.WHITESPACE");
    }
}

