/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"),
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"),
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_");

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher charMatcher, String string3) {
        this.wordBoundary = charMatcher;
        this.wordSeparator = string3;
    }

    public final String to(CaseFormat caseFormat, String string2) {
        if (caseFormat == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (caseFormat == this) {
            return string2;
        }
        switch (this) {
            case LOWER_HYPHEN: {
                switch (caseFormat) {
                    case LOWER_UNDERSCORE: {
                        return string2.replace('-', '_');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(string2.replace('-', '_'));
                    }
                }
                break;
            }
            case LOWER_UNDERSCORE: {
                switch (caseFormat) {
                    case LOWER_HYPHEN: {
                        return string2.replace('_', '-');
                    }
                    case UPPER_UNDERSCORE: {
                        return Ascii.toUpperCase(string2);
                    }
                }
                break;
            }
            case UPPER_UNDERSCORE: {
                switch (caseFormat) {
                    case LOWER_HYPHEN: {
                        return Ascii.toLowerCase(string2.replace('_', '-'));
                    }
                    case LOWER_UNDERSCORE: {
                        return Ascii.toLowerCase(string2);
                    }
                }
            }
        }
        StringBuilder stringBuilder = null;
        int n = 0;
        int n2 = -1;
        while (true) {
            ++n2;
            if ((n2 = this.wordBoundary.indexIn(string2, n2)) == -1) break;
            if (n == 0) {
                stringBuilder = new StringBuilder(string2.length() + 4 * this.wordSeparator.length());
                stringBuilder.append(caseFormat.normalizeFirstWord(string2.substring(n, n2)));
            } else {
                stringBuilder.append(caseFormat.normalizeWord(string2.substring(n, n2)));
            }
            stringBuilder.append(caseFormat.wordSeparator);
            n = n2 + this.wordSeparator.length();
        }
        if (n == 0) {
            return caseFormat.normalizeFirstWord(string2);
        }
        stringBuilder.append(caseFormat.normalizeWord(string2.substring(n)));
        return stringBuilder.toString();
    }

    private String normalizeFirstWord(String string2) {
        switch (this) {
            case LOWER_CAMEL: {
                return Ascii.toLowerCase(string2);
            }
        }
        return this.normalizeWord(string2);
    }

    private String normalizeWord(String string2) {
        switch (this) {
            case LOWER_HYPHEN: {
                return Ascii.toLowerCase(string2);
            }
            case LOWER_UNDERSCORE: {
                return Ascii.toLowerCase(string2);
            }
            case LOWER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(string2);
            }
            case UPPER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(string2);
            }
            case UPPER_UNDERSCORE: {
                return Ascii.toUpperCase(string2);
            }
        }
        throw new RuntimeException("unknown case: " + (Object)((Object)this));
    }

    private static String firstCharOnlyToUpper(String string2) {
        int n = string2.length();
        if (n == 0) {
            return string2;
        }
        return new StringBuilder(n).append(Ascii.toUpperCase(string2.charAt(0))).append(Ascii.toLowerCase(string2.substring(1))).toString();
    }
}

