/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.AbstractIterator$State;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractIterator<T>
implements Iterator<T> {
    private AbstractIterator$State state = AbstractIterator$State.NOT_READY;
    private T next;

    protected AbstractIterator() {
    }

    protected abstract T computeNext();

    protected final T endOfData() {
        this.state = AbstractIterator$State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != AbstractIterator$State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = AbstractIterator$State.FAILED;
        this.next = this.computeNext();
        if (this.state != AbstractIterator$State.DONE) {
            this.state = AbstractIterator$State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = AbstractIterator$State.NOT_READY;
        return this.next;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

